/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.walkers;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataFixer;
import net.minecraft.util.datafix.IDataWalker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockEntityTag
implements IDataWalker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, String> ITEM_ID_TO_BLOCK_ENTITY_ID = Maps.newHashMap();

    static {
        Map<String, String> map = ITEM_ID_TO_BLOCK_ENTITY_ID;
        map.put("minecraft:furnace", "Furnace");
        map.put("minecraft:lit_furnace", "Furnace");
        map.put("minecraft:chest", "Chest");
        map.put("minecraft:trapped_chest", "Chest");
        map.put("minecraft:ender_chest", "EnderChest");
        map.put("minecraft:jukebox", "RecordPlayer");
        map.put("minecraft:dispenser", "Trap");
        map.put("minecraft:dropper", "Dropper");
        map.put("minecraft:sign", "Sign");
        map.put("minecraft:mob_spawner", "MobSpawner");
        map.put("minecraft:noteblock", "Music");
        map.put("minecraft:brewing_stand", "Cauldron");
        map.put("minecraft:enhanting_table", "EnchantTable");
        map.put("minecraft:command_block", "CommandBlock");
        map.put("minecraft:beacon", "Beacon");
        map.put("minecraft:skull", "Skull");
        map.put("minecraft:daylight_detector", "DLDetector");
        map.put("minecraft:hopper", "Hopper");
        map.put("minecraft:banner", "Banner");
        map.put("minecraft:flower_pot", "FlowerPot");
        map.put("minecraft:repeating_command_block", "CommandBlock");
        map.put("minecraft:chain_command_block", "CommandBlock");
        map.put("minecraft:standing_sign", "Sign");
        map.put("minecraft:wall_sign", "Sign");
        map.put("minecraft:piston_head", "Piston");
        map.put("minecraft:daylight_detector_inverted", "DLDetector");
        map.put("minecraft:unpowered_comparator", "Comparator");
        map.put("minecraft:powered_comparator", "Comparator");
        map.put("minecraft:wall_banner", "Banner");
        map.put("minecraft:standing_banner", "Banner");
        map.put("minecraft:structure_block", "Structure");
        map.put("minecraft:end_portal", "Airportal");
        map.put("minecraft:end_gateway", "EndGateway");
        map.put("minecraft:shield", "Shield");
    }

    @Nullable
    private static String getBlockEntityID(String blockID) {
        return ITEM_ID_TO_BLOCK_ENTITY_ID.get(new ResourceLocation(blockID).toString());
    }

    @Override
    public NBTTagCompound process(IDataFixer fixer, NBTTagCompound compound, int versionIn) {
        if (!compound.hasKey("tag", 10)) {
            return compound;
        }
        NBTTagCompound nbttagcompound = compound.getCompoundTag("tag");
        if (nbttagcompound.hasKey("BlockEntityTag", 10)) {
            boolean flag;
            NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("BlockEntityTag");
            String s = compound.getString("id");
            String s1 = BlockEntityTag.getBlockEntityID(s);
            if (s1 == null) {
                LOGGER.warn("Unable to resolve BlockEntity for ItemInstance: {}", new Object[]{s});
                flag = false;
            } else {
                flag = !nbttagcompound1.hasKey("id");
                nbttagcompound1.setString("id", s1);
            }
            fixer.process(FixTypes.BLOCK_ENTITY, nbttagcompound1, versionIn);
            if (flag) {
                nbttagcompound1.removeTag("id");
            }
        }
        return compound;
    }
}

