/*
 * Decompiled with CFR 0.152.
 */
package com.bit.module.all;

import com.bit.module.Category;
import com.bit.module.Module;
import com.bit.module.ModuleSubOption;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.utility.Timing;
import com.bit.utility.Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.client.C10PacketCreativeInventoryAction;

public class Creatives
extends Module {
    private final Timing timing = new Timing();
    private final int[] helmets = new int[]{298, 302, 306, 310, 314};
    private final int[] chestplates = new int[]{299, 303, 307, 311, 315};
    private final int[] leggings = new int[]{300, 304, 308, 312, 316};
    private final int[] boots = new int[]{301, 305, 309, 313, 317};
    private float rainbowHue;
    private float woolHue;
    private float bannerHue;
    private final int[] woolColors = new int[]{14, 1, 4, 5, 3, 9, 11, 10, 2, 6};
    private final int[] bannerColors = new int[]{1, 14, 11, 10, 12, 6, 4, 5, 13, 9};

    public Creatives(String finder, Category category, String name, String description, String warning) {
        super(finder, category, name, description, warning);
        this.addOption("Keybind", String.valueOf(name) + "'s keybind", Interactable.TYPE.KEYBINDER, 0, null, false);
        ArrayList<ModuleSubOption> rso = new ArrayList<ModuleSubOption>();
        rso.add(new ModuleSubOption("Transition Speed", "Speed of the rainbow transition", Interactable.TYPE.SLIDER, 0, new float[]{0.0f, 10.0f}, true));
        this.addOption("Rainbow Armor", "Override all armor with rainbow armor", Interactable.TYPE.CHECKBOX, false, null, false, rso);
        ArrayList<ModuleSubOption> hso = new ArrayList<ModuleSubOption>();
        hso.add(new ModuleSubOption("Switch Speed", "Speed to switch blocks", Interactable.TYPE.SLIDER, 0, new float[]{0.0f, 10.0f}, true));
        this.addOption("Block Hat", "Wear a random block as a hat", Interactable.TYPE.CHECKBOX, null, null, false, hso);
        ArrayList<ModuleSubOption> wso = new ArrayList<ModuleSubOption>();
        wso.add(new ModuleSubOption("Switch Speed", "Speed to switch wool colors", Interactable.TYPE.SLIDER, 0, new float[]{0.0f, 10.0f}, true));
        this.addOption("Wool Hat", "Wear colored wool as a hat", Interactable.TYPE.CHECKBOX, null, null, false, wso);
        ArrayList<ModuleSubOption> bso = new ArrayList<ModuleSubOption>();
        bso.add(new ModuleSubOption("Switch Speed", "Speed to switch banner colors", Interactable.TYPE.SLIDER, 0, new float[]{0.0f, 10.0f}, true));
        this.addOption("Banner Hat", "Wear a colored banner as a hat", Interactable.TYPE.CHECKBOX, null, null, false, bso);
    }

    @Override
    public void onPlayerPreUpdate() {
        if (!this.active || !this.mc.thePlayer.capabilities.isCreativeMode) {
            return;
        }
        boolean rainbowArmor = Util.makeBoolean(this.getOptionValue("rainbow armor"));
        boolean blockHat = Util.makeBoolean(this.getOptionValue("block hat"));
        boolean woolHat = Util.makeBoolean(this.getOptionValue("wool hat"));
        boolean bannerHat = Util.makeBoolean(this.getOptionValue("banner hat"));
        if (rainbowArmor) {
            this.rainbowArmor();
        }
        if (blockHat) {
            this.blockHat();
            return;
        }
        if (woolHat) {
            this.woolHat();
            return;
        }
        if (bannerHat) {
            this.bannerHat();
            return;
        }
    }

    public void rainbowArmor() {
        float rainbowSpeed = Util.makeFloat(this.getSubOptionValue("rainbow armor", "transition speed"));
        this.rainbowHue += rainbowSpeed;
        if (this.rainbowHue > 255.0f) {
            this.rainbowHue = 0.0f;
        }
        try {
            ItemStack helmet = new ItemStack(Item.getItemById(this.helmets[0]));
            ItemStack chest = new ItemStack(Item.getItemById(this.chestplates[0]));
            ItemStack leg = new ItemStack(Item.getItemById(this.leggings[0]));
            ItemStack boot = new ItemStack(Item.getItemById(this.boots[0]));
            int c = new Color(Color.HSBtoRGB(this.rainbowHue / 255.0f, 1.0f, 1.0f)).getRGB();
            String cc = Integer.toHexString(c);
            c = (int)Long.parseLong(cc.substring(2, cc.length()), 16);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound display = new NBTTagCompound();
            display.setInteger("color", c);
            tag.setTag("display", display);
            helmet.setTagCompound(tag);
            chest.setTagCompound(tag);
            leg.setTagCompound(tag);
            boot.setTagCompound(tag);
            if (!Util.makeBoolean(this.getOptionValue("block hat")) && !Util.makeBoolean(this.getOptionValue("wool hat"))) {
                this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(5, helmet));
            }
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(6, chest));
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(7, leg));
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(8, boot));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void blockHat() {
        float blockSpeed = Util.makeFloat(this.getSubOptionValue("block hat", "switch speed"));
        if (!this.timing.isTime(blockSpeed / 10.0f)) {
            return;
        }
        try {
            Random rand = new Random();
            int i = rand.nextInt(Block.blockRegistry.getKeys().size());
            Object obj = Block.blockRegistry.getKeys().toArray()[i];
            Item item = Item.getItemFromBlock((Block)Block.blockRegistry.getObject(obj));
            if (item == null) {
                return;
            }
            ItemStack block = new ItemStack(item);
            ItemStack old = this.mc.thePlayer.getCurrentArmor(3);
            if (old != null && block.getDisplayName().equalsIgnoreCase(old.getDisplayName())) {
                return;
            }
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(5, block));
            this.timing.reset();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void woolHat() {
        float blockSpeed = Util.makeFloat(this.getSubOptionValue("wool hat", "switch speed"));
        try {
            this.woolHue += blockSpeed / 10.0f;
            if (this.woolHue > (float)this.woolColors.length) {
                this.woolHue = 0.0f;
            }
            Item item = Item.getItemById(35);
            ItemStack block = new ItemStack(item, 1, this.woolColors[(int)Math.floor(this.woolHue)]);
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(5, block));
            this.timing.reset();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void bannerHat() {
        float blockSpeed = Util.makeFloat(this.getSubOptionValue("banner hat", "switch speed"));
        try {
            this.bannerHue += blockSpeed / 10.0f;
            if (this.bannerHue > (float)this.bannerColors.length) {
                this.bannerHue = 0.0f;
            }
            Item item = Item.getItemById(425);
            ItemStack block = new ItemStack(item, 1, this.bannerColors[(int)Math.floor(this.bannerHue)]);
            this.mc.getNetHandler().addToSendQueue(new C10PacketCreativeInventoryAction(5, block));
            this.timing.reset();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

