/*
 * Decompiled with CFR 0.152.
 */
package com.bit.render;

import com.bit.Settings;
import com.bit.render.Align;
import com.bit.render.Gui;
import com.bit.toolbar.Positionable;
import com.bit.utility.Draw;
import com.bit.utility.Util;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class Tooltip
extends Positionable {
    public String text = "";
    private List<String> lines = new CopyOnWriteArrayList<String>();
    public boolean enabled;
    private float boxFade;
    private float padding = 4.0f;

    public void update(int mouseX, int mouseY) {
        this.x = mouseX + 24;
        this.y = mouseY - 24;
        this.text = "";
    }

    public void render(float transparency) {
        this.enabled = this.text != "";
        this.lines.clear();
        try {
            int i = 0;
            int j = 0;
            i = 0;
            while (i < this.text.length()) {
                if (this.text.charAt(i) == "|".charAt(0)) {
                    this.lines.add(this.text.substring(j, i));
                    j = ++i;
                }
                ++i;
            }
            this.lines.add(this.text.substring(j, i));
        }
        catch (Exception i) {
            // empty catch block
        }
        if (this.lines.isEmpty()) {
            this.lines.add(this.text);
        }
        float ww = 0.0f;
        for (String s : this.lines) {
            if (!((float)Settings.font_bit_tooltip.getWidth(s) > ww)) continue;
            ww = (float)Settings.font_bit_tooltip.getWidth(s) + this.padding;
        }
        this.boxFade = (float)((double)this.boxFade + ((this.enabled ? 0.8 : 0.0) - (double)this.boxFade) / (double)Gui.transitionSpeed);
        this.width += (this.enabled ? ww : 0.0f) - this.width;
        this.height += ((float)(Settings.font_bit_tooltip.getHeight() * this.lines.size()) - this.height) / Gui.transitionSpeed;
        GlStateManager.color(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        Draw.rect(this.x - this.padding, this.y - this.padding, this.x + this.width + this.padding, this.y + this.height + this.padding, Util.colorAlpha(Settings.theme_bit_dropdown_fill, this.boxFade * transparency));
        Draw.startClip(this.x - this.padding, this.y, this.x + this.width + this.padding, this.y + this.height + this.padding);
        int i = 0;
        while (i < this.lines.size()) {
            int color = Util.colorAlpha(Settings.theme_bit_tooltip_content, this.boxFade * transparency);
            if (i == this.lines.size() - 1 && i != 0) {
                color = Util.colorAlpha(Settings.theme_bit_tooltip_settings, this.boxFade * transparency);
            }
            Draw.string(Settings.font_bit_tooltip, this.x + this.width / 2.0f, this.y + (float)(Settings.font_bit_tooltip.getHeight() * i), this.lines.get(i), color, Align.CENTER, Align.TOP);
            ++i;
        }
        Draw.endClip();
    }
}

