/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar;

import com.bit.Bit;
import com.bit.Settings;
import com.bit.module.Category;
import com.bit.render.Align;
import com.bit.render.Gui;
import com.bit.toolbar.Component;
import com.bit.toolbar.dropdown.WindowModule;
import com.bit.toolbar.dropdown.WindowOptions;
import com.bit.toolbar.dropdown.WindowSubOptions;
import com.bit.utility.Draw;
import com.bit.utility.Util;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;

public class Button
extends Component {
    protected float hoverTransition;

    public Button(int id, ResourceLocation texture, float x, float y, float width, float height) {
        super(id, texture, x, y, width, height);
    }

    @Override
    public void update(int mouseX, int mouseY) {
        if (!this.enabled) {
            return;
        }
        this.hover = this.mouseOver(mouseX, mouseY);
        this.hoverTransition = this.hover ? (this.hoverTransition += (1.0f - this.hoverTransition) / Gui.transitionSpeed) : (this.hoverTransition += (0.0f - this.hoverTransition) / Gui.transitionSpeed);
        if (this.active) {
            WindowModule window = Bit.bit().gui.window;
            window.active = true;
            window.translate(this.x + this.width / 2.0f, this.y + this.height + 16.0f);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.enabled || button != 0) {
            return;
        }
        WindowModule wm = Bit.bit().gui.window;
        WindowOptions wo = Bit.bit().gui.options;
        WindowSubOptions wso = Bit.bit().gui.subOptions;
        if (!wm.mouseOver(mouseX, mouseY) && wm.active && wm.exist.getTime() >= wm.existFor && !wo.active && !wso.active) {
            this.active = false;
        }
        if (wo.active || wso.active) {
            return;
        }
        if (this.mouseOver(mouseX, mouseY)) {
            for (Component component : Bit.bit().gui.toolbarComponents) {
                if (component == this) continue;
                component.active = false;
            }
            if (!this.active) {
                WindowModule window = Bit.bit().gui.window;
                window.updateContentParent(this.id);
            }
            this.active = !this.active;
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int button) {
        if (!this.enabled) {
            return;
        }
    }

    @Override
    public void render(float transparency) {
        if (!this.enabled) {
            return;
        }
        float w = 16.0f;
        float h = 16.0f;
        Color c = new Color(Util.colorAlpha(Settings.theme_bit_toolbar_icon_fill, (this.active ? 1.0f : 0.5f + this.hoverTransition / 2.0f) * transparency));
        Draw.rect(this.x, this.y, this.x + this.width, this.y + this.height, Util.colorAlpha(Settings.theme_bit_toolbar_hover, (this.active ? 0.6666667f : this.hoverTransition / 1.5f) * transparency));
        GL11.glColor4f((float)c.r, (float)c.g, (float)c.b, (float)c.a);
        Draw.rectTexture(this.x + 32.0f - w / 2.0f, this.y + 32.0f - h / 2.0f, this.x + 32.0f + w / 2.0f, this.y + 32.0f + h / 2.0f, this.texture);
        String t = Category.values()[this.id].name();
        String b = t.substring(0, 1).toUpperCase();
        String e = t.substring(1, t.length()).toLowerCase();
        Draw.string(Settings.font_bit_toolbar_sub, this.x + this.width / 2.0f, this.y + this.height / 2.0f + 8.0f, String.valueOf(b) + e, Util.colorAlpha(Settings.theme_bit_toolbar_icon_fill, this.hover || this.active ? 1.0f : 0.5f), Align.CENTER, Align.TOP);
    }
}

