/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar.dropdown;

import com.bit.Bit;
import com.bit.Settings;
import com.bit.render.Align;
import com.bit.render.Gui;
import com.bit.toolbar.Positionable;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.toolbar.dropdown.WindowModule;
import com.bit.utility.Draw;
import com.bit.utility.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Timer;

public class Window
extends Positionable {
    public String title;
    public float toX;
    public float toY;
    public float toWidth;
    public float toHeight;
    public float maxWidth;
    public float maxHeight;
    public float boxFade;
    public float interactablesFade;
    public float arrowX;
    public boolean enabled = true;
    protected boolean showInteractables;
    protected int contentParent;
    protected int newContentParent;
    protected Window parent;
    public Timer exist = new Timer();
    public float existFor = 0.1f;
    protected float padding = 4.0f;
    public List<Interactable> interactables = new ArrayList<Interactable>();

    public Window(Window parent) {
        this.parent = parent;
        this.newContentParent = this.contentParent = -1;
    }

    public void keyboardPressed(int key) {
    }

    public void keyboardReleased(int key) {
    }

    public void updateInteractables() {
    }

    public void action(Interactable i, int mouseX, int mouseY, int button) {
    }

    public void update(int mouseX, int mouseY) {
        if (!this.enabled || !this.active) {
            this.exist.reset();
            return;
        }
        Timer.tick();
        if (this.exist.getTime() > this.existFor) {
            this.exist.set(this.existFor);
        }
    }

    public void translate(float x, float y) {
        if (!this.enabled) {
            return;
        }
        this.toX = x;
        this.toY = y;
        if (this.toX < 16.0f + this.toWidth / 2.0f) {
            this.toX = 16.0f + this.toWidth / 2.0f;
        }
        if (this.toX > (float)Display.getWidth() - this.toWidth / 2.0f - 16.0f) {
            this.toX = (float)Display.getWidth() - this.toWidth / 2.0f - 16.0f;
        }
        if (this.toX < 16.0f && this.toX > (float)Display.getWidth() - this.toWidth / 2.0f - 16.0f || this.toWidth > (float)(Display.getWidth() - 32)) {
            this.toX = Display.getWidth() / 2;
        }
    }

    public void resize(float width, float height) {
        if (!this.enabled) {
            return;
        }
        this.toWidth = width;
        this.toHeight = height;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.enabled || this.exist.getTime() < this.existFor) {
            return;
        }
        for (Interactable i : this.interactables) {
            i.mouseClicked(mouseX, mouseY, button);
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        if (!this.enabled || this.exist.getTime() < this.existFor) {
            return;
        }
        for (Interactable i : this.interactables) {
            i.mouseReleased(mouseX, mouseY, button);
        }
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        return this.enabled && this.active && (float)mouseX > this.x - this.width / 2.0f - this.padding && (float)mouseX < this.x + this.width / 2.0f + this.padding && (float)mouseY > this.y && (float)mouseY < this.y + this.height + this.padding;
    }

    public void updateContentParent(int index) {
        this.newContentParent = index;
        this.updateInteractables();
    }

    public void updateContent() {
        this.x += (this.toX - this.x) / Gui.transitionSpeed;
        this.y += (this.toY - this.y) / Gui.transitionSpeed;
        this.width += (this.toWidth - this.width) / Gui.transitionSpeed;
        this.height += (this.toHeight - this.height) / Gui.transitionSpeed;
        if (this.contentParent != this.newContentParent) {
            this.updateInteractables();
        }
    }

    public void render(float transparency) {
        if (!this.enabled) {
            return;
        }
        GlStateManager.color(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        float xx = this.arrowX;
        if (this instanceof WindowModule) {
            xx = Display.getWidth() / 2 - (Bit.bit().gui.toolbarComponents.size() - 2) * 32 + this.contentParent * 64 + 32;
            this.arrowX += (xx - this.arrowX) / Gui.transitionSpeed;
        } else {
            xx = this.parent.x;
            this.arrowX = -100.0f;
        }
        Draw.triangle(this.arrowX - 12.0f, this.y, this.arrowX, this.y - 12.0f, this.arrowX + 12.0f, this.y, Util.colorAlpha(Settings.theme_bit_dropdown_fill, this.boxFade * transparency));
        Draw.rect(this.x - this.width / 2.0f - this.padding, this.y, this.x + this.width / 2.0f + this.padding, this.y + this.height + this.padding, Util.colorAlpha(Settings.theme_bit_dropdown_fill, this.boxFade * transparency));
        Draw.startClip(this.x - this.width / 2.0f - this.padding, this.y, this.x + this.width / 2.0f + this.padding, this.y + this.height + this.padding);
        if (this.interactablesFade > 0.01f) {
            Draw.string(Settings.font_bit_dropdown_header, this.x, this.y + 16.0f, String.valueOf(this.title.substring(0, 1).toUpperCase()) + this.title.substring(1, this.title.length()).toLowerCase(), Util.colorAlpha(Settings.theme_bit_dropdown_header, this.interactablesFade * transparency), Align.CENTER, Align.CENTER);
        }
        Draw.startClip(this.x - this.width / 2.0f, this.y + 24.0f, this.x + this.width / 2.0f, this.y + this.height);
        for (Interactable i : this.interactables) {
            i.render(this.interactablesFade * transparency);
        }
        Draw.endClip();
        Draw.endClip();
    }
}

