/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar.dropdown;

import com.bit.Bit;
import com.bit.module.Category;
import com.bit.module.Module;
import com.bit.module.ModuleManager;
import com.bit.render.Gui;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.toolbar.dropdown.Toggle;
import com.bit.toolbar.dropdown.Window;
import com.bit.toolbar.dropdown.WindowOptions;
import org.lwjgl.opengl.Display;

public class WindowModule
extends Window {
    private Category category;

    public WindowModule(Window parent) {
        super(parent);
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        if (!this.enabled) {
            return;
        }
        if (this.category != null) {
            this.title = this.category.name();
        }
        for (Interactable i : this.interactables) {
            i.update(mouseX, mouseY);
            int index = i.id;
            if (!(i instanceof Toggle)) continue;
            Toggle t = (Toggle)i;
            t.active = ModuleManager.list().get((int)index).active;
        }
        if (this.contentParent == -1) {
            this.updateContentParent(0);
        }
        this.updateContent();
        this.interactablesFade += ((this.showInteractables ? 0.8f : 0.0f) - this.interactablesFade) / Gui.transitionSpeed;
        if (this.active && !Bit.bit().gui.options.active && !Bit.bit().gui.subOptions.active) {
            this.boxFade += (0.7f - this.boxFade) / Gui.transitionSpeed;
            if (this.boxFade > 0.1f) {
                this.showInteractables = true;
                this.newContentParent = this.contentParent;
            }
            this.maxWidth = Math.max(160.0f, this.maxWidth);
            this.maxHeight = Math.max(28.0f, this.maxHeight);
            this.resize(this.maxWidth, this.maxHeight);
        } else {
            this.showInteractables = false;
            this.resize(24.0f, 0.0f);
            if (this.interactablesFade < 0.1f) {
                this.boxFade += (0.0f - this.boxFade) / Gui.transitionSpeed;
            }
        }
        for (Interactable i : this.interactables) {
            i.translate(i.parent.x - i.parent.width / 2.0f + i.offsetX, i.parent.y + i.offsetY);
        }
    }

    @Override
    public void updateInteractables() {
        this.contentParent = this.newContentParent;
        this.category = Category.values()[this.contentParent];
        this.interactables.clear();
        for (Module module : ModuleManager.list()) {
            if (this.category != Category.ALL && module.category != this.category) continue;
            int index = ModuleManager.list().indexOf(module);
            this.interactables.add(new Toggle(this, Interactable.TYPE.BUTTON, module.name, index, String.valueOf(module.description) + (module.options != null ? "| |Right click for options" : ""), 0.0f, 0.0f, 160.0f, 24.0f));
        }
        float left = 0.0f;
        float top = 0.0f;
        float right = -1.0f;
        float bottom = -1.0f;
        for (Interactable i : this.interactables) {
            int index = this.interactables.indexOf(i);
            i.offsetX = left;
            i.offsetY = 32.0f + top;
            if (i.offsetX + i.width > right) {
                right = i.offsetX + i.width;
            }
            if (i.offsetY + i.height > bottom) {
                bottom = i.offsetY + i.height;
            }
            top += 24.0f;
            if (!(bottom > (float)(Display.getHeight() - 128) - this.y)) continue;
            top = 0.0f;
            left += 164.0f;
            bottom = 24.0f;
        }
        right = 0.0f;
        bottom = 0.0f;
        for (Interactable i : this.interactables) {
            if (i.offsetX + i.width > right) {
                right = i.offsetX + i.width;
            }
            if (!(i.offsetY + i.height > bottom)) continue;
            bottom = i.offsetY + i.height;
        }
        this.maxWidth = right;
        this.maxHeight = bottom;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (!this.enabled || Bit.bit().gui.options.active || Bit.bit().gui.subOptions.active || this.exist.getTime() < this.existFor) {
            return;
        }
        if (!this.mouseOver(mouseX, mouseY) && button == 0) {
            this.active = false;
        }
    }

    @Override
    public void action(Interactable i, int mouseX, int mouseY, int button) {
        if (!this.enabled || !this.active || Bit.bit().gui.options.active || Bit.bit().gui.subOptions.active || this.exist.getTime() < this.existFor) {
            return;
        }
        switch (button) {
            case 0: {
                if (!(i instanceof Toggle)) break;
                i.active = ModuleManager.list().get((int)i.id).active;
                ModuleManager.list().get(i.id).toggle();
                break;
            }
            case 1: {
                if (!(i instanceof Toggle)) break;
                WindowOptions options = Bit.bit().gui.options;
                options.active = true;
                options.updateContentParent(i.id);
            }
        }
    }
}

