/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar.dropdown;

import com.bit.Bit;
import com.bit.module.Module;
import com.bit.module.ModuleManager;
import com.bit.module.ModuleOption;
import com.bit.render.Gui;
import com.bit.toolbar.dropdown.Checkbox;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.toolbar.dropdown.Keybinder;
import com.bit.toolbar.dropdown.Slider;
import com.bit.toolbar.dropdown.Window;
import com.bit.toolbar.dropdown.WindowSubOptions;
import com.bit.utility.Util;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

public class WindowOptions
extends Window {
    public Module module;

    public WindowOptions(Window parent) {
        super(parent);
    }

    @Override
    public void update(int mouseX, int mouseY) {
        super.update(mouseX, mouseY);
        if (!this.enabled) {
            return;
        }
        if (this.module != null) {
            this.title = this.module.name;
        }
        this.translate(this.parent.x, this.parent.y);
        for (Interactable i : this.interactables) {
            i.update(mouseX, mouseY);
            i.translate(i.parent.x - i.parent.width / 2.0f + i.offsetX, i.parent.y + i.offsetY);
            int index = i.id;
            if (i instanceof Checkbox) {
                Checkbox c = (Checkbox)i;
                try {
                    c.checked = Util.makeBoolean(this.module.options.get((int)index).value);
                }
                catch (Exception exception) {}
                continue;
            }
            if (i instanceof Slider) {
                Slider s = (Slider)i;
                if (s.setting) {
                    int relMouseX = (int)((float)mouseX - s.x);
                    int relMouseY = (int)((float)mouseY - s.y);
                    float value = 0.0f;
                    value = (float)relMouseX / (s.width / (this.module.options.get((int)index).limit[1] - this.module.options.get((int)index).limit[0])) + this.module.options.get((int)index).limit[0];
                    value = Math.min(Math.max(this.module.options.get((int)index).limit[0], value), this.module.options.get((int)index).limit[1]);
                    this.module.options.get((int)index).value = !this.module.options.get((int)index).isFloat ? Float.valueOf(Math.round(value)) : Float.valueOf(value);
                }
                float val = Util.makeFloat(this.module.options.get((int)index).value);
                s.value = (val - this.module.options.get((int)index).limit[0]) * (i.width / (this.module.options.get((int)index).limit[1] - this.module.options.get((int)index).limit[0]));
                if (!this.module.options.get((int)index).isFloat) {
                    s.alt = Util.prettyFloat(val);
                    continue;
                }
                s.alt = String.format("%.2f", Float.valueOf(val));
                continue;
            }
            if (!(i instanceof Keybinder)) continue;
            Keybinder k = (Keybinder)i;
            k.alt = Keyboard.getKeyName((int)Util.makeInteger(this.module.options.get((int)index).value));
            if (!k.setting || !(this.boxFade < 0.1f)) continue;
            k.setting = false;
        }
        if (this.contentParent == -1) {
            this.updateContentParent(0);
        }
        this.updateContent();
        this.interactablesFade += ((this.showInteractables ? 0.8f : 0.0f) - this.interactablesFade) / Gui.transitionSpeed;
        if (this.active && !Bit.bit().gui.subOptions.active) {
            this.boxFade += (0.7f - this.boxFade) / Gui.transitionSpeed;
            if (this.boxFade > 0.4f) {
                this.showInteractables = true;
            }
            this.maxWidth = Math.max(200.0f, this.maxWidth);
            this.maxHeight = Math.max(28.0f, this.maxHeight);
            this.resize(this.maxWidth, this.maxHeight);
        } else {
            this.showInteractables = false;
            this.resize(24.0f, 0.0f);
            if (this.interactablesFade < 0.1f) {
                this.boxFade += (0.0f - this.boxFade) / Gui.transitionSpeed;
            }
        }
    }

    @Override
    public void keyboardPressed(int key) {
        block6: {
            Keybinder k;
            block5: {
                super.keyboardPressed(key);
                if (this.exist.getTime() < this.existFor) {
                    return;
                }
                if (key == 1 || key == 211) break block5;
                for (Interactable i : this.interactables) {
                    if (!(i instanceof Keybinder)) continue;
                    Keybinder k2 = (Keybinder)i;
                    if (!k2.setting) continue;
                    this.module.options.get((int)i.id).value = key;
                    k2.setting = false;
                }
                break block6;
            }
            if (key == 1) {
                for (Interactable i : this.interactables) {
                    if (!(i instanceof Keybinder)) continue;
                    k = (Keybinder)i;
                    if (!k.setting) continue;
                    k.setting = false;
                }
            }
            if (key != 211) break block6;
            for (Interactable i : this.interactables) {
                if (!(i instanceof Keybinder)) continue;
                k = (Keybinder)i;
                if (!k.setting) continue;
                this.module.options.get((int)i.id).value = 0;
                k.setting = false;
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (!this.enabled || Bit.bit().gui.subOptions.active || this.exist.getTime() < this.existFor) {
            return;
        }
        if (!this.mouseOver(mouseX, mouseY) && button == 0) {
            this.active = false;
        }
    }

    @Override
    public void updateInteractables() {
        this.contentParent = this.newContentParent;
        this.module = ModuleManager.list().get(this.contentParent);
        this.interactables.clear();
        int index = 0;
        for (ModuleOption mo : this.module.options) {
            switch (mo.type) {
                case CHECKBOX: {
                    this.interactables.add(new Checkbox(this, Interactable.TYPE.CHECKBOX, this.module.options.get((int)index).name, index, String.valueOf(this.module.options.get((int)index).description) + (this.module.options.get((int)index).subOptions != null ? "| |Right click for options" : ""), 0.0f, 0.0f, 200.0f, 24.0f));
                    break;
                }
                case SLIDER: {
                    this.interactables.add(new Slider(this, Interactable.TYPE.SLIDER, this.module.options.get((int)index).name, index, String.valueOf(this.module.options.get((int)index).description) + (this.module.options.get((int)index).subOptions != null ? "| |Right click for options" : ""), 0.0f, 0.0f, 200.0f, 24.0f));
                    break;
                }
                case KEYBINDER: {
                    this.interactables.add(new Keybinder(this, Interactable.TYPE.KEYBINDER, this.module.options.get((int)index).name, index, String.valueOf(this.module.options.get((int)index).description) + (this.module.options.get((int)index).subOptions != null ? "| |Right click for options" : ""), 0.0f, 0.0f, 200.0f, 24.0f));
                    break;
                }
            }
            ++index;
        }
        float left = 0.0f;
        float top = 0.0f;
        float right = -1.0f;
        float bottom = -1.0f;
        for (Interactable i : this.interactables) {
            index = this.interactables.indexOf(i);
            i.offsetX = left;
            i.offsetY = 32.0f + top;
            if (i.offsetX + i.width > right) {
                right = i.offsetX + i.width;
            }
            if (i.offsetY + i.height > bottom) {
                bottom = i.offsetY + i.height;
            }
            top += 24.0f;
            if (!(bottom > (float)(Display.getHeight() - 128) - this.y)) continue;
            top = 0.0f;
            left += 204.0f;
            bottom = 24.0f;
        }
        right = 0.0f;
        bottom = 0.0f;
        for (Interactable i : this.interactables) {
            if (i.offsetX + i.width > right) {
                right = i.offsetX + i.width;
            }
            if (!(i.offsetY + i.height > bottom)) continue;
            bottom = i.offsetY + i.height;
        }
        this.maxWidth = right;
        this.maxHeight = bottom;
    }

    @Override
    public void action(Interactable i, int mouseX, int mouseY, int button) {
        if (!this.enabled || !this.active || Bit.bit().gui.subOptions.active || this.exist.getTime() < this.existFor) {
            return;
        }
        int index = i.id;
        switch (button) {
            case 0: {
                if (i instanceof Checkbox) {
                    try {
                        boolean checked = Util.makeBoolean(this.module.options.get((int)index).value);
                        this.module.options.get((int)index).value = !checked;
                    }
                    catch (Exception checked) {}
                    break;
                }
                if (i instanceof Slider) {
                    Slider s = (Slider)i;
                    s.setting = true;
                    break;
                }
                if (!(i instanceof Keybinder)) break;
                Keybinder k = (Keybinder)i;
                k.setting = true;
                break;
            }
            case 1: {
                if (this.module.options.get((int)index).subOptions == null) break;
                WindowSubOptions subOptions = Bit.bit().gui.subOptions;
                subOptions.active = true;
                subOptions.updateContentParent(i.id);
            }
        }
    }
}

