/*
 * Decompiled with CFR 0.152.
 */
package com.bit.utility;

import com.mojang.authlib.Agent;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Session;
import net.minecraft.util.Vec3;
import org.json.JSONArray;
import org.json.JSONObject;

public class Util {
    private static final Minecraft mc = Minecraft.getMinecraft();

    public static List<String> usernameHistory(String username) {
        String uuid = null;
        List<String> names = new ArrayList<String>();
        try {
            uuid = Util.getUUIDFromName(username);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            return names;
        }
        try {
            names = Util.getNamesFromUUID(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return names;
    }

    public static String getUUIDFromName(String username) throws Exception {
        String inputLine;
        URL getUUID = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
        BufferedReader in = new BufferedReader(new InputStreamReader(getUUID.openStream()));
        String line = "";
        while ((inputLine = in.readLine()) != null) {
            line = inputLine;
        }
        in.close();
        JSONObject jo = new JSONObject(line);
        return jo.getString("id");
    }

    public static List<String> getNamesFromUUID(String uuid) throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        URL getNames = new URL("https://api.mojang.com/user/profiles/" + uuid + "/names");
        BufferedReader in = new BufferedReader(new InputStreamReader(getNames.openStream()));
        String inputLine = "";
        String line = "";
        while ((inputLine = in.readLine()) != null) {
            line = inputLine;
        }
        in.close();
        JSONArray ja = new JSONArray(line);
        int i = 0;
        while (i < ja.length()) {
            JSONObject jao = new JSONObject(ja.get(i).toString());
            names.add(jao.getString("name"));
            ++i;
        }
        return names;
    }

    public static String setSessionData(String user, String pass) {
        if (pass.length() != 0) {
            YggdrasilAuthenticationService authentication = new YggdrasilAuthenticationService(Proxy.NO_PROXY, "");
            YggdrasilUserAuthentication auth = (YggdrasilUserAuthentication)authentication.createUserAuthentication(Agent.MINECRAFT);
            auth.setUsername(user);
            auth.setPassword(pass);
            try {
                auth.logIn();
                mc.setSession(new Session(auth.getSelectedProfile().getName(), auth.getSelectedProfile().getId().toString(), auth.getAuthenticatedToken(), "legacy"));
                return "Login successful";
            }
            catch (AuthenticationException authenticationException) {
                return "Login failed";
            }
        }
        mc.setSession(new Session(user, "0", "0", "legacy"));
        return "Username changed";
    }

    public static int colorAlpha(int color, float alpha) {
        Color c = new Color(color);
        float r = 0.003921569f * (float)c.getRed();
        float g = 0.003921569f * (float)c.getGreen();
        float b = 0.003921569f * (float)c.getBlue();
        return new Color(r, g, b, alpha).getRGB();
    }

    public static int blendColor(int color1, int color2, float perc) {
        Color blended;
        Color x = new Color(color1);
        Color y = new Color(color2);
        float inverse_blending = 1.0f - perc;
        float red = (float)x.getRed() * perc + (float)y.getRed() * inverse_blending;
        float green = (float)x.getGreen() * perc + (float)y.getGreen() * inverse_blending;
        float blue = (float)x.getBlue() * perc + (float)y.getBlue() * inverse_blending;
        try {
            blended = new Color(red / 255.0f, green / 255.0f, blue / 255.0f);
        }
        catch (Exception e) {
            blended = new Color(-1);
        }
        return blended.getRGB();
    }

    public static double safeDiv(double x, double y) {
        try {
            return x / y;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public static String prettyFloat(double f) {
        if (f == (double)((long)f)) {
            return String.format("%d", (long)f);
        }
        return String.format("%s", f);
    }

    public static float angleDifference(float a, float b) {
        return ((a - b) % 360.0f + 540.0f) % 360.0f - 180.0f;
    }

    public static float makeFloat(Object o) {
        try {
            return Float.parseFloat(String.valueOf(o));
        }
        catch (Exception e) {
            return -1.0f;
        }
    }

    public static int makeInteger(Object o) {
        try {
            return Integer.parseInt(String.valueOf(Util.prettyFloat(Util.makeFloat(o))));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean makeBoolean(Object o) {
        try {
            return Boolean.parseBoolean(String.valueOf(o));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canSeeEntity(EntityLivingBase from, EntityLivingBase to) {
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.posX, to.posY + (double)to.getEyeHeight(), to.posZ)) == null) {
            return true;
        }
        if (to.getEntityBoundingBox() == null) {
            return false;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().minX, to.getEntityBoundingBox().maxY, to.getEntityBoundingBox().minZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().minX, to.getEntityBoundingBox().maxY, to.getEntityBoundingBox().maxZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().maxX, to.getEntityBoundingBox().maxY, to.getEntityBoundingBox().maxZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().maxX, to.getEntityBoundingBox().maxY, to.getEntityBoundingBox().minZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().minX, to.getEntityBoundingBox().minY, to.getEntityBoundingBox().minZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().minX, to.getEntityBoundingBox().minY, to.getEntityBoundingBox().maxZ)) == null) {
            return true;
        }
        if (from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().maxX, to.getEntityBoundingBox().minY, to.getEntityBoundingBox().maxZ)) == null) {
            return true;
        }
        return from.worldObj.rayTraceBlocks(new Vec3(from.posX, from.posY + (double)from.getEyeHeight(), from.posZ), new Vec3(to.getEntityBoundingBox().maxX, to.getEntityBoundingBox().minY, to.getEntityBoundingBox().minZ)) == null;
    }
}

