/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.bit.utility.RenderUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ChunkRenderContainer;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VboRenderList;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.ListChunkFactory;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VboChunkFactory;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemRecord;
import net.minecraft.src.ChunkUtils;
import net.minecraft.src.CloudRenderer;
import net.minecraft.src.Config;
import net.minecraft.src.CustomColorizer;
import net.minecraft.src.CustomSky;
import net.minecraft.src.Lagometer;
import net.minecraft.src.RandomMobs;
import net.minecraft.src.Reflector;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
implements IWorldAccess,
IResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    private static final ResourceLocation locationMoonPhasesPng = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation locationSunPng = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation locationCloudsPng = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation locationEndSkyPng = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation field_175006_g = new ResourceLocation("textures/misc/forcefield.png");
    public final Minecraft mc;
    private final TextureManager renderEngine;
    private final RenderManager field_175010_j;
    private WorldClient theWorld;
    private Set field_175009_l = Sets.newLinkedHashSet();
    private List glRenderLists = Lists.newArrayListWithCapacity((int)69696);
    private ViewFrustum field_175008_n;
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;
    private VertexFormat field_175014_r;
    private VertexBuffer field_175013_s;
    private VertexBuffer field_175012_t;
    private VertexBuffer field_175011_u;
    private int cloudTickCounter;
    public final Map damagedBlocks = Maps.newHashMap();
    private final Map mapSoundPositions = Maps.newHashMap();
    private final TextureAtlasSprite[] destroyBlockIcons = new TextureAtlasSprite[10];
    private Framebuffer field_175015_z;
    private ShaderGroup field_174991_A;
    private double field_174992_B = Double.MIN_VALUE;
    private double field_174993_C = Double.MIN_VALUE;
    private double field_174987_D = Double.MIN_VALUE;
    private int field_174988_E = Integer.MIN_VALUE;
    private int field_174989_F = Integer.MIN_VALUE;
    private int field_174990_G = Integer.MIN_VALUE;
    private double field_174997_H = Double.MIN_VALUE;
    private double field_174998_I = Double.MIN_VALUE;
    private double field_174999_J = Double.MIN_VALUE;
    private double field_175000_K = Double.MIN_VALUE;
    private double field_174994_L = Double.MIN_VALUE;
    private final ChunkRenderDispatcher field_174995_M = new ChunkRenderDispatcher();
    private ChunkRenderContainer field_174996_N;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private boolean field_175002_T = false;
    private ClippingHelper field_175001_U;
    private final Vector4f[] field_175004_V = new Vector4f[8];
    private final Vector3d field_175003_W = new Vector3d();
    private boolean field_175005_X = false;
    IRenderChunkFactory field_175007_a;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    public boolean displayListEntitiesDirty = true;
    private CloudRenderer cloudRenderer;
    public Entity renderedEntity;
    public Set chunksToResortTransparency = new LinkedHashSet();
    public Set chunksToUpdateForced = new LinkedHashSet();
    private Deque visibilityDeque = new ArrayDeque();
    private List renderInfosEntities = new ArrayList(1024);
    private List renderInfosTileEntities = new ArrayList(1024);
    private int renderDistance = 0;
    private int renderDistanceSq = 0;
    private static final Set SET_ALL_FACINGS = Collections.unmodifiableSet(new HashSet<EnumFacing>(Arrays.asList(EnumFacing.VALUES)));

    public RenderGlobal(Minecraft mcIn) {
        this.cloudRenderer = new CloudRenderer(mcIn);
        this.mc = mcIn;
        this.field_175010_j = mcIn.getRenderManager();
        this.renderEngine = mcIn.getTextureManager();
        this.renderEngine.bindTexture(field_175006_g);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GlStateManager.func_179144_i(0);
        this.func_174971_n();
        this.field_175005_X = OpenGlHelper.func_176075_f();
        if (this.field_175005_X) {
            this.field_174996_N = new VboRenderList();
            this.field_175007_a = new VboChunkFactory();
        } else {
            this.field_174996_N = new RenderList();
            this.field_175007_a = new ListChunkFactory();
        }
        this.field_175014_r = new VertexFormat();
        this.field_175014_r.func_177349_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUseage.POSITION, 3));
        this.func_174963_q();
        this.func_174980_p();
        this.func_174964_o();
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.func_174971_n();
    }

    private void func_174971_n() {
        TextureMap var1 = this.mc.getTextureMapBlocks();
        int var2 = 0;
        while (var2 < this.destroyBlockIcons.length) {
            this.destroyBlockIcons[var2] = var1.getAtlasSprite("minecraft:blocks/destroy_stage_" + var2);
            ++var2;
        }
    }

    public void func_174966_b() {
        if (OpenGlHelper.shadersSupported) {
            if (ShaderLinkHelper.getStaticShaderLinkHelper() == null) {
                ShaderLinkHelper.setNewStaticShaderLinkHelper();
            }
            ResourceLocation var1 = new ResourceLocation("shaders/post/entity_outline.json");
            try {
                this.field_174991_A = new ShaderGroup(this.mc.getTextureManager(), this.mc.getResourceManager(), this.mc.getFramebuffer(), var1);
                this.field_174991_A.createBindFramebuffers(this.mc.displayWidth, this.mc.displayHeight);
                this.field_175015_z = this.field_174991_A.func_177066_a("final");
            }
            catch (IOException var3) {
                logger.warn("Failed to load shader: " + var1, (Throwable)var3);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
            catch (JsonSyntaxException var4) {
                logger.warn("Failed to load shader: " + var1, (Throwable)var4);
                this.field_174991_A = null;
                this.field_175015_z = null;
            }
        } else {
            this.field_174991_A = null;
            this.field_175015_z = null;
        }
    }

    public void func_174975_c() {
        if (this.func_174985_d()) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 771, 0, 1);
            this.field_175015_z.func_178038_a(this.mc.displayWidth, this.mc.displayHeight, false);
            GlStateManager.disableBlend();
        }
    }

    protected boolean func_174985_d() {
        return this.field_175015_z != null && this.field_174991_A != null && this.mc.thePlayer != null && this.mc.thePlayer.func_175149_v() && this.mc.gameSettings.field_178883_an.getIsKeyPressed();
    }

    private void func_174964_o() {
        Tessellator var1 = Tessellator.getInstance();
        WorldRenderer var2 = var1.getWorldRenderer();
        if (this.field_175011_u != null) {
            this.field_175011_u.func_177362_c();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.deleteDisplayLists(this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.field_175005_X) {
            this.field_175011_u = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(var2, -16.0f, true);
            var2.draw();
            var2.reset();
            this.field_175011_u.func_177360_a(var2.func_178966_f(), var2.func_178976_e());
        } else {
            this.glSkyList2 = GLAllocation.generateDisplayLists(1);
            GL11.glNewList((int)this.glSkyList2, (int)4864);
            this.func_174968_a(var2, -16.0f, true);
            var1.draw();
            GL11.glEndList();
        }
    }

    private void func_174980_p() {
        Tessellator var1 = Tessellator.getInstance();
        WorldRenderer var2 = var1.getWorldRenderer();
        if (this.field_175012_t != null) {
            this.field_175012_t.func_177362_c();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.deleteDisplayLists(this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.field_175005_X) {
            this.field_175012_t = new VertexBuffer(this.field_175014_r);
            this.func_174968_a(var2, 16.0f, false);
            var2.draw();
            var2.reset();
            this.field_175012_t.func_177360_a(var2.func_178966_f(), var2.func_178976_e());
        } else {
            this.glSkyList = GLAllocation.generateDisplayLists(1);
            GL11.glNewList((int)this.glSkyList, (int)4864);
            this.func_174968_a(var2, 16.0f, false);
            var1.draw();
            GL11.glEndList();
        }
    }

    private void func_174968_a(WorldRenderer worldRendererIn, float p_174968_2_, boolean p_174968_3_) {
        boolean var4 = true;
        boolean var5 = true;
        worldRendererIn.startDrawingQuads();
        int var6 = -384;
        while (var6 <= 384) {
            int var7 = -384;
            while (var7 <= 384) {
                float var8 = var6;
                float var9 = var6 + 64;
                if (p_174968_3_) {
                    var9 = var6;
                    var8 = var6 + 64;
                }
                worldRendererIn.addVertex(var8, p_174968_2_, var7);
                worldRendererIn.addVertex(var9, p_174968_2_, var7);
                worldRendererIn.addVertex(var9, p_174968_2_, var7 + 64);
                worldRendererIn.addVertex(var8, p_174968_2_, var7 + 64);
                var7 += 64;
            }
            var6 += 64;
        }
    }

    private void func_174963_q() {
        Tessellator var1 = Tessellator.getInstance();
        WorldRenderer var2 = var1.getWorldRenderer();
        if (this.field_175013_s != null) {
            this.field_175013_s.func_177362_c();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.deleteDisplayLists(this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.field_175005_X) {
            this.field_175013_s = new VertexBuffer(this.field_175014_r);
            this.func_180444_a(var2);
            var2.draw();
            var2.reset();
            this.field_175013_s.func_177360_a(var2.func_178966_f(), var2.func_178976_e());
        } else {
            this.starGLCallList = GLAllocation.generateDisplayLists(1);
            GlStateManager.pushMatrix();
            GL11.glNewList((int)this.starGLCallList, (int)4864);
            this.func_180444_a(var2);
            var1.draw();
            GL11.glEndList();
            GlStateManager.popMatrix();
        }
    }

    private void func_180444_a(WorldRenderer worldRendererIn) {
        Random var2 = new Random(10842L);
        worldRendererIn.startDrawingQuads();
        int var3 = 0;
        while (var3 < 1500) {
            double var4 = var2.nextFloat() * 2.0f - 1.0f;
            double var6 = var2.nextFloat() * 2.0f - 1.0f;
            double var8 = var2.nextFloat() * 2.0f - 1.0f;
            double var10 = 0.15f + var2.nextFloat() * 0.1f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (var12 < 1.0 && var12 > 0.01) {
                var12 = 1.0 / Math.sqrt(var12);
                double var14 = (var4 *= var12) * 100.0;
                double var16 = (var6 *= var12) * 100.0;
                double var18 = (var8 *= var12) * 100.0;
                double var20 = Math.atan2(var4, var8);
                double var22 = Math.sin(var20);
                double var24 = Math.cos(var20);
                double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
                double var28 = Math.sin(var26);
                double var30 = Math.cos(var26);
                double var32 = var2.nextDouble() * Math.PI * 2.0;
                double var34 = Math.sin(var32);
                double var36 = Math.cos(var32);
                int var38 = 0;
                while (var38 < 4) {
                    double var39 = 0.0;
                    double var41 = (double)((var38 & 2) - 1) * var10;
                    double var43 = (double)((var38 + 1 & 2) - 1) * var10;
                    double var45 = 0.0;
                    double var47 = var41 * var36 - var43 * var34;
                    double var49 = var43 * var36 + var41 * var34;
                    double var53 = var47 * var28 + 0.0 * var30;
                    double var55 = 0.0 * var28 - var47 * var30;
                    double var57 = var55 * var22 - var49 * var24;
                    double var61 = var49 * var22 + var55 * var24;
                    worldRendererIn.addVertex(var14 + var57, var16 + var53, var18 + var61);
                    ++var38;
                }
            }
            ++var3;
        }
    }

    public void setWorldAndLoadRenderers(WorldClient worldClientIn) {
        if (this.theWorld != null) {
            this.theWorld.removeWorldAccess(this);
        }
        this.field_174992_B = Double.MIN_VALUE;
        this.field_174993_C = Double.MIN_VALUE;
        this.field_174987_D = Double.MIN_VALUE;
        this.field_174988_E = Integer.MIN_VALUE;
        this.field_174989_F = Integer.MIN_VALUE;
        this.field_174990_G = Integer.MIN_VALUE;
        this.field_175010_j.set(worldClientIn);
        this.theWorld = worldClientIn;
        if (worldClientIn != null) {
            worldClientIn.addWorldAccess(this);
            this.loadRenderers();
        }
    }

    public void loadRenderers() {
        if (this.theWorld != null) {
            Entity var2;
            this.displayListEntitiesDirty = true;
            Blocks.leaves.setGraphicsLevel(Config.isTreesFancy());
            Blocks.leaves2.setGraphicsLevel(Config.isTreesFancy());
            BlockModelRenderer.updateAoLightValue();
            this.renderDistanceChunks = this.mc.gameSettings.renderDistanceChunks;
            this.renderDistance = this.renderDistanceChunks * 16;
            this.renderDistanceSq = this.renderDistance * this.renderDistance;
            boolean var1 = this.field_175005_X;
            this.field_175005_X = OpenGlHelper.func_176075_f();
            if (var1 && !this.field_175005_X) {
                this.field_174996_N = new RenderList();
                this.field_175007_a = new ListChunkFactory();
            } else if (!var1 && this.field_175005_X) {
                this.field_174996_N = new VboRenderList();
                this.field_175007_a = new VboChunkFactory();
            }
            if (var1 != this.field_175005_X) {
                this.func_174963_q();
                this.func_174980_p();
                this.func_174964_o();
            }
            if (this.field_175008_n != null) {
                this.field_175008_n.func_178160_a();
            }
            this.func_174986_e();
            this.field_175008_n = new ViewFrustum(this.theWorld, this.mc.gameSettings.renderDistanceChunks, this, this.field_175007_a);
            if (this.theWorld != null && (var2 = this.mc.func_175606_aa()) != null) {
                this.field_175008_n.func_178163_a(var2.posX, var2.posZ);
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void func_174986_e() {
        this.field_175009_l.clear();
        this.field_174995_M.func_178514_b();
    }

    public void checkOcclusionQueryResult(int p_72720_1_, int p_72720_2_) {
        if (OpenGlHelper.shadersSupported && this.field_174991_A != null) {
            this.field_174991_A.createBindFramebuffers(p_72720_1_, p_72720_2_);
        }
    }

    public void func_180446_a(Entity p_180446_1_, ICamera p_180446_2_, float partialTicks) {
        int pass = 0;
        if (Reflector.MinecraftForgeClient_getRenderPass.exists()) {
            pass = Reflector.callInt(Reflector.MinecraftForgeClient_getRenderPass, new Object[0]);
        }
        if (this.renderEntitiesStartupCounter > 0) {
            if (pass > 0) {
                return;
            }
            --this.renderEntitiesStartupCounter;
        } else {
            Entity var19;
            double var4 = p_180446_1_.prevPosX + (p_180446_1_.posX - p_180446_1_.prevPosX) * (double)partialTicks;
            double var6 = p_180446_1_.prevPosY + (p_180446_1_.posY - p_180446_1_.prevPosY) * (double)partialTicks;
            double var8 = p_180446_1_.prevPosZ + (p_180446_1_.posZ - p_180446_1_.prevPosZ) * (double)partialTicks;
            this.theWorld.theProfiler.startSection("prepare");
            TileEntityRendererDispatcher.instance.func_178470_a(this.theWorld, this.mc.getTextureManager(), this.mc.fontRendererObj, this.mc.func_175606_aa(), partialTicks);
            this.field_175010_j.func_180597_a(this.theWorld, this.mc.fontRendererObj, this.mc.func_175606_aa(), this.mc.pointedEntity, this.mc.gameSettings, partialTicks);
            if (pass == 0) {
                this.countEntitiesTotal = 0;
                this.countEntitiesRendered = 0;
                this.countEntitiesHidden = 0;
            }
            Entity var10 = this.mc.func_175606_aa();
            double var11 = var10.lastTickPosX + (var10.posX - var10.lastTickPosX) * (double)partialTicks;
            double var13 = var10.lastTickPosY + (var10.posY - var10.lastTickPosY) * (double)partialTicks;
            double var15 = var10.lastTickPosZ + (var10.posZ - var10.lastTickPosZ) * (double)partialTicks;
            TileEntityRendererDispatcher.staticPlayerX = var11;
            TileEntityRendererDispatcher.staticPlayerY = var13;
            TileEntityRendererDispatcher.staticPlayerZ = var15;
            this.field_175010_j.func_178628_a(var11, var13, var15);
            this.mc.entityRenderer.func_180436_i();
            this.theWorld.theProfiler.endStartSection("global");
            List var17 = this.theWorld.getLoadedEntityList();
            if (pass == 0) {
                this.countEntitiesTotal = var17.size();
            }
            if (Config.isFogOff() && this.mc.entityRenderer.fogStandard) {
                GlStateManager.disableFog();
            }
            boolean forgeEntityPass = Reflector.ForgeEntity_shouldRenderInPass.exists();
            boolean forgeTileEntityPass = Reflector.ForgeTileEntity_shouldRenderInPass.exists();
            int var18 = 0;
            while (var18 < this.theWorld.weatherEffects.size()) {
                var19 = (Entity)this.theWorld.weatherEffects.get(var18);
                if (!forgeEntityPass || Reflector.callBoolean(var19, Reflector.ForgeEntity_shouldRenderInPass, pass)) {
                    ++this.countEntitiesRendered;
                    if (var19.isInRangeToRender3d(var4, var6, var8)) {
                        this.field_175010_j.renderEntitySimple(var19, partialTicks);
                    }
                }
                ++var18;
            }
            if (this.func_174985_d()) {
                GlStateManager.depthFunc(519);
                GlStateManager.disableFog();
                this.field_175015_z.framebufferClear();
                this.field_175015_z.bindFramebuffer(false);
                this.theWorld.theProfiler.endStartSection("entityOutlines");
                RenderHelper.disableStandardItemLighting();
                this.field_175010_j.func_178632_c(true);
                var18 = 0;
                while (var18 < var17.size()) {
                    var19 = (Entity)var17.get(var18);
                    if (!forgeEntityPass || Reflector.callBoolean(var19, Reflector.ForgeEntity_shouldRenderInPass, pass)) {
                        boolean var26;
                        boolean var25 = this.mc.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.mc.func_175606_aa()).isPlayerSleeping();
                        boolean bl = var26 = var19.isInRangeToRender3d(var4, var6, var8) && (var19.ignoreFrustumCheck || p_180446_2_.isBoundingBoxInFrustum(var19.getEntityBoundingBox()) || var19.riddenByEntity == this.mc.thePlayer) && var19 instanceof EntityPlayer;
                        if ((var19 != this.mc.func_175606_aa() || this.mc.gameSettings.thirdPersonView != 0 || var25) && var26) {
                            this.field_175010_j.renderEntitySimple(var19, partialTicks);
                        }
                    }
                    ++var18;
                }
                this.field_175010_j.func_178632_c(false);
                RenderHelper.enableStandardItemLighting();
                GlStateManager.depthMask(false);
                this.field_174991_A.loadShaderGroup(partialTicks);
                GlStateManager.depthMask(true);
                this.mc.getFramebuffer().bindFramebuffer(false);
                GlStateManager.enableFog();
                GlStateManager.depthFunc(515);
                GlStateManager.enableDepth();
                GlStateManager.enableAlpha();
            }
            this.theWorld.theProfiler.endStartSection("entities");
            Iterator<Object> var341 = this.renderInfosEntities.iterator();
            boolean oldFancyGraphics = this.mc.gameSettings.fancyGraphics;
            this.mc.gameSettings.fancyGraphics = Config.isDroppedItemsFancy();
            while (var341.hasNext()) {
                ContainerLocalRenderInformation var35 = (ContainerLocalRenderInformation)var341.next();
                Chunk fontRenderer = this.theWorld.getChunkFromBlockCoords(var35.field_178036_a.func_178568_j());
                for (Entity var27 : fontRenderer.getEntityLists()[var35.field_178036_a.func_178568_j().getY() / 16]) {
                    boolean var30;
                    if (forgeEntityPass && !Reflector.callBoolean(var27, Reflector.ForgeEntity_shouldRenderInPass, pass)) continue;
                    boolean bl = var30 = this.field_175010_j.func_178635_a(var27, p_180446_2_, var4, var6, var8) || var27.riddenByEntity == this.mc.thePlayer;
                    if (var30) {
                        boolean var34;
                        boolean bl2 = var34 = this.mc.func_175606_aa() instanceof EntityLivingBase ? ((EntityLivingBase)this.mc.func_175606_aa()).isPlayerSleeping() : false;
                        if (var27 == this.mc.func_175606_aa() && this.mc.gameSettings.thirdPersonView == 0 && !var34 || var27.posY >= 0.0 && var27.posY < 256.0 && !this.theWorld.isBlockLoaded(new BlockPos(var27))) continue;
                        ++this.countEntitiesRendered;
                        if (var27.getClass() == EntityItemFrame.class) {
                            var27.renderDistanceWeight = 0.06;
                        }
                        this.renderedEntity = var27;
                        this.field_175010_j.renderEntitySimple(var27, partialTicks);
                        this.renderedEntity = null;
                    }
                    if (var30 || !(var27 instanceof EntityWitherSkull)) continue;
                    this.mc.getRenderManager().func_178630_b(var27, partialTicks);
                }
            }
            this.mc.gameSettings.fancyGraphics = oldFancyGraphics;
            FontRenderer var36 = TileEntityRendererDispatcher.instance.getFontRenderer();
            this.theWorld.theProfiler.endStartSection("blockentities");
            RenderHelper.enableStandardItemLighting();
            for (ContainerLocalRenderInformation var35 : this.renderInfosTileEntities) {
                for (TileEntity var37 : var35.field_178036_a.func_178571_g().func_178485_b()) {
                    AxisAlignedBB var40;
                    if (forgeTileEntityPass && (!Reflector.callBoolean(var37, Reflector.ForgeTileEntity_shouldRenderInPass, pass) || (var40 = (AxisAlignedBB)Reflector.call(var37, Reflector.ForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !p_180446_2_.isBoundingBoxInFrustum(var40))) continue;
                    Class<?> var42 = var37.getClass();
                    if (var42 == TileEntitySign.class && !Config.zoomMode) {
                        EntityPlayerSP shouldRender = this.mc.thePlayer;
                        double tileEntity = var37.getDistanceSq(shouldRender.posX, shouldRender.posY, shouldRender.posZ);
                        if (tileEntity > 256.0) {
                            var36.enabled = false;
                        }
                    }
                    TileEntityRendererDispatcher.instance.func_180546_a(var37, partialTicks, -1);
                    var36.enabled = true;
                }
            }
            this.func_180443_s();
            for (DestroyBlockProgress var39 : this.damagedBlocks.values()) {
                boolean var45;
                TileEntity var37;
                BlockPos var41 = var39.func_180246_b();
                var37 = this.theWorld.getTileEntity(var41);
                if (var37 instanceof TileEntityChest) {
                    TileEntityChest var43 = (TileEntityChest)var37;
                    if (var43.adjacentChestXNeg != null) {
                        var41 = var41.offset(EnumFacing.WEST);
                        var37 = this.theWorld.getTileEntity(var41);
                    } else if (var43.adjacentChestZNeg != null) {
                        var41 = var41.offset(EnumFacing.NORTH);
                        var37 = this.theWorld.getTileEntity(var41);
                    }
                }
                Block var44 = this.theWorld.getBlockState(var41).getBlock();
                if (forgeTileEntityPass) {
                    AxisAlignedBB aabb;
                    var45 = false;
                    if (var37 != null && Reflector.callBoolean(var37, Reflector.ForgeTileEntity_shouldRenderInPass, pass) && Reflector.callBoolean(var37, Reflector.ForgeTileEntity_canRenderBreaking, new Object[0]) && (aabb = (AxisAlignedBB)Reflector.call(var37, Reflector.ForgeTileEntity_getRenderBoundingBox, new Object[0])) != null) {
                        var45 = p_180446_2_.isBoundingBoxInFrustum(aabb);
                    }
                } else {
                    boolean bl = var45 = var37 != null && (var44 instanceof BlockChest || var44 instanceof BlockEnderChest || var44 instanceof BlockSign || var44 instanceof BlockSkull);
                }
                if (!var45) continue;
                TileEntityRendererDispatcher.instance.func_180546_a(var37, partialTicks, var39.getPartialBlockDamage());
            }
            this.func_174969_t();
            this.mc.entityRenderer.func_175072_h();
            this.mc.mcProfiler.endSection();
        }
    }

    public String getDebugInfoRenders() {
        int var1 = this.field_175008_n.field_178164_f.length;
        int var2 = 0;
        for (ContainerLocalRenderInformation var4 : this.glRenderLists) {
            CompiledChunk var5 = var4.field_178036_a.field_178590_b;
            if (var5 == CompiledChunk.field_178502_a || var5.func_178489_a()) continue;
            ++var2;
        }
        return String.format("C: %d/%d %sD: %d, %s", var2, var1, this.mc.field_175612_E ? "(s) " : "", this.renderDistanceChunks, this.field_174995_M.func_178504_a());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden + ", I: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered) + ", " + Config.getVersion();
    }

    public void func_174970_a(Entity viewEntity, double partialTicks, ICamera camera, int frameCount, boolean playerSpectator) {
        RenderChunk var41;
        ContainerLocalRenderInformation var39;
        if (this.mc.gameSettings.renderDistanceChunks != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        this.theWorld.theProfiler.startSection("camera");
        double var7 = viewEntity.posX - this.field_174992_B;
        double var9 = viewEntity.posY - this.field_174993_C;
        double var11 = viewEntity.posZ - this.field_174987_D;
        if (this.field_174988_E != viewEntity.chunkCoordX || this.field_174989_F != viewEntity.chunkCoordY || this.field_174990_G != viewEntity.chunkCoordZ || var7 * var7 + var9 * var9 + var11 * var11 > 16.0) {
            this.field_174992_B = viewEntity.posX;
            this.field_174993_C = viewEntity.posY;
            this.field_174987_D = viewEntity.posZ;
            this.field_174988_E = viewEntity.chunkCoordX;
            this.field_174989_F = viewEntity.chunkCoordY;
            this.field_174990_G = viewEntity.chunkCoordZ;
            this.field_175008_n.func_178163_a(viewEntity.posX, viewEntity.posZ);
        }
        this.theWorld.theProfiler.endStartSection("renderlistcamera");
        double var13 = viewEntity.lastTickPosX + (viewEntity.posX - viewEntity.lastTickPosX) * partialTicks;
        double var15 = viewEntity.lastTickPosY + (viewEntity.posY - viewEntity.lastTickPosY) * partialTicks;
        double var17 = viewEntity.lastTickPosZ + (viewEntity.posZ - viewEntity.lastTickPosZ) * partialTicks;
        this.field_174996_N.func_178004_a(var13, var15, var17);
        this.theWorld.theProfiler.endStartSection("cull");
        if (this.field_175001_U != null) {
            Frustrum var35 = new Frustrum(this.field_175001_U);
            var35.setPosition(this.field_175003_W.x, this.field_175003_W.y, this.field_175003_W.z);
            camera = var35;
        }
        this.mc.mcProfiler.endStartSection("culling");
        BlockPos var351 = new BlockPos(var13, var15 + (double)viewEntity.getEyeHeight(), var17);
        RenderChunk var20 = this.field_175008_n.func_178161_a(var351);
        BlockPos var21 = new BlockPos(MathHelper.floor_double(var13) / 16 * 16, MathHelper.floor_double(var15) / 16 * 16, MathHelper.floor_double(var17) / 16 * 16);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.field_175009_l.isEmpty() || viewEntity.posX != this.field_174997_H || viewEntity.posY != this.field_174998_I || viewEntity.posZ != this.field_174999_J || (double)viewEntity.rotationPitch != this.field_175000_K || (double)viewEntity.rotationYaw != this.field_174994_L;
        this.field_174997_H = viewEntity.posX;
        this.field_174998_I = viewEntity.posY;
        this.field_174999_J = viewEntity.posZ;
        this.field_175000_K = viewEntity.rotationPitch;
        this.field_174994_L = viewEntity.rotationYaw;
        boolean var22 = this.field_175001_U != null;
        Lagometer.timerVisibility.start();
        if (!var22 && this.displayListEntitiesDirty) {
            int var30;
            this.displayListEntitiesDirty = false;
            this.glRenderLists.clear();
            this.renderInfosEntities.clear();
            this.renderInfosTileEntities.clear();
            this.visibilityDeque.clear();
            Deque var36 = this.visibilityDeque;
            boolean var37 = this.mc.field_175612_E;
            if (var20 == null) {
                int var46 = var351.getY() > 0 ? 248 : 8;
                var30 = -this.renderDistanceChunks;
                while (var30 <= this.renderDistanceChunks) {
                    int var43 = -this.renderDistanceChunks;
                    while (var43 <= this.renderDistanceChunks) {
                        RenderChunk var45 = this.field_175008_n.func_178161_a(new BlockPos((var30 << 4) + 8, var46, (var43 << 4) + 8));
                        if (var45 != null && camera.isBoundingBoxInFrustum(var45.field_178591_c)) {
                            var45.func_178577_a(frameCount);
                            var36.add(new ContainerLocalRenderInformation(var45, null, 0, null));
                        }
                        ++var43;
                    }
                    ++var30;
                }
            } else {
                boolean var38 = false;
                ContainerLocalRenderInformation var40 = new ContainerLocalRenderInformation(var20, null, 0, null);
                Set var411 = SET_ALL_FACINGS;
                if (!var411.isEmpty() && var411.size() == 1) {
                    Vector3f var431 = this.func_174962_a(viewEntity, partialTicks);
                    EnumFacing var31 = EnumFacing.func_176737_a(var431.x, var431.y, var431.z).getOpposite();
                    var411.remove(var31);
                }
                if (var411.isEmpty()) {
                    var38 = true;
                }
                if (var38 && !playerSpectator && !RenderUtil.renderFar()) {
                    this.glRenderLists.add(var40);
                } else {
                    if (playerSpectator && this.theWorld.getBlockState(var351).getBlock().isOpaqueCube() || RenderUtil.renderFar()) {
                        var37 = false;
                    }
                    var20.func_178577_a(frameCount);
                    var36.add(var40);
                }
            }
            EnumFacing[] var391 = EnumFacing.VALUES;
            var30 = var391.length;
            while (!var36.isEmpty()) {
                var39 = (ContainerLocalRenderInformation)var36.poll();
                var41 = var39.field_178036_a;
                EnumFacing var42 = var39.field_178034_b;
                BlockPos var44 = var41.func_178568_j();
                if (!var41.field_178590_b.func_178489_a() || var41.func_178569_m()) {
                    this.glRenderLists.add(var39);
                }
                if (ChunkUtils.hasEntities(this.theWorld.getChunkFromBlockCoords(var44))) {
                    this.renderInfosEntities.add(var39);
                }
                if (var41.func_178571_g().func_178485_b().size() > 0) {
                    this.renderInfosTileEntities.add(var39);
                }
                int var451 = 0;
                while (var451 < var30) {
                    RenderChunk var33;
                    EnumFacing var32 = var391[var451];
                    if (!(var37 && var39.field_178035_c.contains(var32.getOpposite()) || var37 && var42 != null && !var41.func_178571_g().func_178495_a(var42.getOpposite(), var32) || (var33 = this.getRenderChunkOffset(var351, var41, var32)) == null || !var33.func_178577_a(frameCount) || !camera.isBoundingBoxInFrustum(var33.field_178591_c))) {
                        ContainerLocalRenderInformation var34 = new ContainerLocalRenderInformation(var33, var32, var39.field_178032_d + 1, null);
                        var34.field_178035_c.addAll(var39.field_178035_c);
                        var34.field_178035_c.add(var32);
                        var36.add(var34);
                    }
                    ++var451;
                }
            }
        }
        if (this.field_175002_T) {
            this.func_174984_a(var13, var15, var17);
            this.field_175002_T = false;
        }
        Lagometer.timerVisibility.end();
        this.field_174995_M.func_178513_e();
        Set var361 = this.field_175009_l;
        this.field_175009_l = Sets.newLinkedHashSet();
        Iterator var371 = this.glRenderLists.iterator();
        Lagometer.timerChunkUpdate.start();
        while (var371.hasNext()) {
            var39 = (ContainerLocalRenderInformation)var371.next();
            var41 = var39.field_178036_a;
            if (!var41.func_178569_m() && !var361.contains(var41)) continue;
            this.displayListEntitiesDirty = true;
            if (this.func_174983_a(var21, var39.field_178036_a)) {
                if (!Config.isActing()) {
                    this.chunksToUpdateForced.add(var41);
                    continue;
                }
                this.mc.mcProfiler.startSection("build near");
                this.field_174995_M.func_178505_b(var41);
                var41.func_178575_a(false);
                this.mc.mcProfiler.endSection();
                continue;
            }
            this.field_175009_l.add(var41);
        }
        Lagometer.timerChunkUpdate.end();
        this.field_175009_l.addAll(var361);
        this.mc.mcProfiler.endSection();
    }

    private boolean func_174983_a(BlockPos p_174983_1_, RenderChunk p_174983_2_) {
        BlockPos var3 = p_174983_2_.func_178568_j();
        return MathHelper.abs_int(p_174983_1_.getX() - var3.getX()) > 16 ? false : (MathHelper.abs_int(p_174983_1_.getY() - var3.getY()) > 16 ? false : MathHelper.abs_int(p_174983_1_.getZ() - var3.getZ()) <= 16);
    }

    private Set func_174978_c(BlockPos p_174978_1_) {
        VisGraph var2 = new VisGraph();
        BlockPos var3 = new BlockPos(p_174978_1_.getX() >> 4 << 4, p_174978_1_.getY() >> 4 << 4, p_174978_1_.getZ() >> 4 << 4);
        Chunk var4 = this.theWorld.getChunkFromBlockCoords(var3);
        for (BlockPos.MutableBlockPos var6 : BlockPos.getAllInBoxMutable(var3, var3.add(15, 15, 15))) {
            if (!var4.getBlock(var6).isOpaqueCube()) continue;
            var2.func_178606_a(var6);
        }
        return var2.func_178609_b(p_174978_1_);
    }

    private RenderChunk getRenderChunkOffset(BlockPos p_174973_1_, RenderChunk renderChunk, EnumFacing p_174973_3_) {
        BlockPos var4 = renderChunk.getPositionOffset16(p_174973_3_);
        if (var4.getY() >= 0 && var4.getY() < 256) {
            int distSq;
            int dx = MathHelper.abs_int(p_174973_1_.getX() - var4.getX());
            int dz = MathHelper.abs_int(p_174973_1_.getZ() - var4.getZ());
            if (Config.isFogOff() ? dx > this.renderDistance || dz > this.renderDistance : (distSq = dx * dx + dz * dz) > this.renderDistanceSq) {
                return null;
            }
            return this.field_175008_n.func_178161_a(var4);
        }
        return null;
    }

    private void func_174984_a(double p_174984_1_, double p_174984_3_, double p_174984_5_) {
        this.field_175001_U = new ClippingHelperImpl();
        ((ClippingHelperImpl)this.field_175001_U).init();
        Matrix4f var7 = new Matrix4f(this.field_175001_U.field_178626_c);
        var7.transpose();
        Matrix4f var8 = new Matrix4f(this.field_175001_U.field_178625_b);
        var8.transpose();
        Matrix4f var9 = new Matrix4f();
        var9.mul(var8, var7);
        var9.invert();
        this.field_175003_W.x = p_174984_1_;
        this.field_175003_W.y = p_174984_3_;
        this.field_175003_W.z = p_174984_5_;
        this.field_175004_V[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.field_175004_V[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.field_175004_V[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.field_175004_V[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.field_175004_V[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        int var10 = 0;
        while (var10 < 8) {
            var9.transform((Tuple4f)this.field_175004_V[var10]);
            this.field_175004_V[var10].x /= this.field_175004_V[var10].w;
            this.field_175004_V[var10].y /= this.field_175004_V[var10].w;
            this.field_175004_V[var10].z /= this.field_175004_V[var10].w;
            this.field_175004_V[var10].w = 1.0f;
            ++var10;
        }
    }

    protected Vector3f func_174962_a(Entity entityIn, double partialTicks) {
        float var4 = (float)((double)entityIn.prevRotationPitch + (double)(entityIn.rotationPitch - entityIn.prevRotationPitch) * partialTicks);
        float var5 = (float)((double)entityIn.prevRotationYaw + (double)(entityIn.rotationYaw - entityIn.prevRotationYaw) * partialTicks);
        if (Minecraft.getMinecraft().gameSettings.thirdPersonView == 2) {
            var4 += 180.0f;
        }
        float var6 = MathHelper.cos(-var5 * ((float)Math.PI / 180) - (float)Math.PI);
        float var7 = MathHelper.sin(-var5 * ((float)Math.PI / 180) - (float)Math.PI);
        float var8 = -MathHelper.cos(-var4 * ((float)Math.PI / 180));
        float var9 = MathHelper.sin(-var4 * ((float)Math.PI / 180));
        return new Vector3f(var7 * var8, var9, var6 * var8);
    }

    public int func_174977_a(EnumWorldBlockLayer blockLayerIn, double partialTicks, int pass, Entity entityIn) {
        RenderHelper.disableStandardItemLighting();
        if (blockLayerIn == EnumWorldBlockLayer.TRANSLUCENT) {
            this.mc.mcProfiler.startSection("translucent_sort");
            double var15 = entityIn.posX - this.prevRenderSortX;
            double var16 = entityIn.posY - this.prevRenderSortY;
            double var17 = entityIn.posZ - this.prevRenderSortZ;
            if (var15 * var15 + var16 * var16 + var17 * var17 > 1.0) {
                this.prevRenderSortX = entityIn.posX;
                this.prevRenderSortY = entityIn.posY;
                this.prevRenderSortZ = entityIn.posZ;
                int var18 = 0;
                Iterator var13 = this.glRenderLists.iterator();
                this.chunksToResortTransparency.clear();
                while (var13.hasNext()) {
                    ContainerLocalRenderInformation var14 = (ContainerLocalRenderInformation)var13.next();
                    if (!var14.field_178036_a.field_178590_b.func_178492_d(blockLayerIn) || var18++ >= 15) continue;
                    this.chunksToResortTransparency.add(var14.field_178036_a);
                }
            }
            this.mc.mcProfiler.endSection();
        }
        this.mc.mcProfiler.startSection("filterempty");
        int var151 = 0;
        boolean var7 = blockLayerIn == EnumWorldBlockLayer.TRANSLUCENT;
        int var161 = var7 ? this.glRenderLists.size() - 1 : 0;
        int var9 = var7 ? -1 : this.glRenderLists.size();
        int var171 = var7 ? -1 : 1;
        int var11 = var161;
        while (var11 != var9) {
            RenderChunk var181 = ((ContainerLocalRenderInformation)this.glRenderLists.get((int)var11)).field_178036_a;
            if (!var181.func_178571_g().func_178491_b(blockLayerIn)) {
                ++var151;
                this.field_174996_N.func_178002_a(var181, blockLayerIn);
            }
            var11 += var171;
        }
        if (Config.isFogOff() && this.mc.entityRenderer.fogStandard) {
            GlStateManager.disableFog();
        }
        this.mc.mcProfiler.endStartSection("render_" + (Object)((Object)blockLayerIn));
        this.func_174982_a(blockLayerIn);
        this.mc.mcProfiler.endSection();
        return var151;
    }

    private void func_174982_a(EnumWorldBlockLayer blockLayerIn) {
        this.mc.entityRenderer.func_180436_i();
        if (OpenGlHelper.func_176075_f()) {
            GL11.glEnableClientState((int)32884);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
            GL11.glEnableClientState((int)32888);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.lightmapTexUnit);
            GL11.glEnableClientState((int)32888);
            OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
            GL11.glEnableClientState((int)32886);
        }
        this.field_174996_N.func_178001_a(blockLayerIn);
        if (OpenGlHelper.func_176075_f()) {
            List var2 = DefaultVertexFormats.field_176600_a.func_177343_g();
            for (VertexFormatElement var4 : var2) {
                VertexFormatElement.EnumUseage var5 = var4.func_177375_c();
                int var6 = var4.func_177369_e();
                switch (SwitchEnumUseage.field_178037_a[var5.ordinal()]) {
                    case 1: {
                        GL11.glDisableClientState((int)32884);
                        break;
                    }
                    case 2: {
                        OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit + var6);
                        GL11.glDisableClientState((int)32888);
                        OpenGlHelper.setClientActiveTexture(OpenGlHelper.defaultTexUnit);
                        break;
                    }
                    case 3: {
                        GL11.glDisableClientState((int)32886);
                        GlStateManager.func_179117_G();
                    }
                }
            }
        }
        this.mc.entityRenderer.func_175072_h();
    }

    private void func_174965_a(Iterator p_174965_1_) {
        while (p_174965_1_.hasNext()) {
            DestroyBlockProgress var2 = (DestroyBlockProgress)p_174965_1_.next();
            int var3 = var2.getCreationCloudUpdateTick();
            if (this.cloudTickCounter - var3 <= 400) continue;
            p_174965_1_.remove();
        }
    }

    public void updateClouds() {
        ++this.cloudTickCounter;
        if (this.cloudTickCounter % 20 == 0) {
            this.func_174965_a(this.damagedBlocks.values().iterator());
        }
    }

    private void func_180448_r() {
        if (Config.isSkyEnabled()) {
            GlStateManager.disableFog();
            GlStateManager.disableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
            RenderHelper.disableStandardItemLighting();
            GlStateManager.depthMask(false);
            this.renderEngine.bindTexture(locationEndSkyPng);
            Tessellator var1 = Tessellator.getInstance();
            WorldRenderer var2 = var1.getWorldRenderer();
            int var3 = 0;
            while (var3 < 6) {
                GlStateManager.pushMatrix();
                if (var3 == 1) {
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                }
                if (var3 == 2) {
                    GlStateManager.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                }
                if (var3 == 3) {
                    GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
                }
                if (var3 == 4) {
                    GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                }
                if (var3 == 5) {
                    GlStateManager.rotate(-90.0f, 0.0f, 0.0f, 1.0f);
                }
                var2.startDrawingQuads();
                var2.func_178991_c(0x282828);
                var2.addVertexWithUV(-100.0, -100.0, -100.0, 0.0, 0.0);
                var2.addVertexWithUV(-100.0, -100.0, 100.0, 0.0, 16.0);
                var2.addVertexWithUV(100.0, -100.0, 100.0, 16.0, 16.0);
                var2.addVertexWithUV(100.0, -100.0, -100.0, 16.0, 0.0);
                var1.draw();
                GlStateManager.popMatrix();
                ++var3;
            }
            GlStateManager.depthMask(true);
            GlStateManager.func_179098_w();
            GlStateManager.enableAlpha();
        }
    }

    public void func_174976_a(float partialTicks, int pass) {
        WorldProvider var3;
        Object var4;
        if (Reflector.ForgeWorldProvider_getSkyRenderer.exists() && (var4 = Reflector.call(var3 = this.mc.theWorld.provider, Reflector.ForgeWorldProvider_getSkyRenderer, new Object[0])) != null) {
            Reflector.callVoid(var4, Reflector.IRenderHandler_render, Float.valueOf(partialTicks), this.theWorld, this.mc);
            return;
        }
        if (this.mc.theWorld.provider.getDimensionId() == 1) {
            this.func_180448_r();
        } else if (this.mc.theWorld.provider.isSurfaceWorld()) {
            float var19;
            float var18;
            int var31;
            float var22;
            float var14;
            float var13;
            float var12;
            float var11;
            float var10;
            GlStateManager.func_179090_x();
            Vec3 var221 = this.theWorld.getSkyColor(this.mc.func_175606_aa(), partialTicks);
            var221 = CustomColorizer.getSkyColor(var221, this.mc.theWorld, this.mc.func_175606_aa().posX, this.mc.func_175606_aa().posY + 1.0, this.mc.func_175606_aa().posZ);
            float var231 = (float)var221.xCoord;
            float var5 = (float)var221.yCoord;
            float var6 = (float)var221.zCoord;
            if (pass != 2) {
                float var23 = (var231 * 30.0f + var5 * 59.0f + var6 * 11.0f) / 100.0f;
                float var24 = (var231 * 30.0f + var5 * 70.0f) / 100.0f;
                float var25 = (var231 * 30.0f + var6 * 70.0f) / 100.0f;
                var231 = var23;
                var5 = var24;
                var6 = var25;
            }
            GlStateManager.color(var231, var5, var6);
            Tessellator var241 = Tessellator.getInstance();
            WorldRenderer var251 = var241.getWorldRenderer();
            GlStateManager.depthMask(false);
            GlStateManager.enableFog();
            GlStateManager.color(var231, var5, var6);
            if (Config.isSkyEnabled()) {
                if (this.field_175005_X) {
                    this.field_175012_t.func_177359_a();
                    GL11.glEnableClientState((int)32884);
                    GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                    this.field_175012_t.func_177358_a(7);
                    this.field_175012_t.func_177361_b();
                    GL11.glDisableClientState((int)32884);
                } else {
                    GlStateManager.callList(this.glSkyList);
                }
            }
            GlStateManager.disableFog();
            GlStateManager.disableAlpha();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
            RenderHelper.disableStandardItemLighting();
            float[] var261 = this.theWorld.provider.calcSunriseSunsetColors(this.theWorld.getCelestialAngle(partialTicks), partialTicks);
            if (var261 != null && Config.isSunMoonEnabled()) {
                GlStateManager.func_179090_x();
                GlStateManager.shadeModel(7425);
                GlStateManager.pushMatrix();
                GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                GlStateManager.rotate(MathHelper.sin(this.theWorld.getCelestialAngleRadians(partialTicks)) < 0.0f ? 180.0f : 0.0f, 0.0f, 0.0f, 1.0f);
                GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
                var10 = var261[0];
                var11 = var261[1];
                var12 = var261[2];
                if (pass != 2) {
                    var13 = (var10 * 30.0f + var11 * 59.0f + var12 * 11.0f) / 100.0f;
                    var14 = (var10 * 30.0f + var11 * 70.0f) / 100.0f;
                    var22 = (var10 * 30.0f + var12 * 70.0f) / 100.0f;
                    var10 = var13;
                    var11 = var14;
                    var12 = var22;
                }
                var251.startDrawing(6);
                var251.func_178960_a(var10, var11, var12, var261[3]);
                var251.addVertex(0.0, 100.0, 0.0);
                boolean var26 = true;
                var251.func_178960_a(var261[0], var261[1], var261[2], 0.0f);
                var31 = 0;
                while (var31 <= 16) {
                    var22 = (float)var31 * (float)Math.PI * 2.0f / 16.0f;
                    var18 = MathHelper.sin(var22);
                    var19 = MathHelper.cos(var22);
                    var251.addVertex(var18 * 120.0f, var19 * 120.0f, -var19 * 40.0f * var261[3]);
                    ++var31;
                }
                var241.draw();
                GlStateManager.popMatrix();
                GlStateManager.shadeModel(7424);
            }
            GlStateManager.func_179098_w();
            GlStateManager.tryBlendFuncSeparate(770, 1, 1, 0);
            GlStateManager.pushMatrix();
            var10 = 1.0f - this.theWorld.getRainStrength(partialTicks);
            var11 = 0.0f;
            var12 = 0.0f;
            var13 = 0.0f;
            GlStateManager.color(1.0f, 1.0f, 1.0f, var10);
            GlStateManager.translate(0.0f, 0.0f, 0.0f);
            GlStateManager.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
            CustomSky.renderSky(this.theWorld, this.renderEngine, this.theWorld.getCelestialAngle(partialTicks), var10);
            GlStateManager.rotate(this.theWorld.getCelestialAngle(partialTicks) * 360.0f, 1.0f, 0.0f, 0.0f);
            if (Config.isSunMoonEnabled()) {
                var14 = 30.0f;
                this.renderEngine.bindTexture(locationSunPng);
                var251.startDrawingQuads();
                var251.addVertexWithUV(-var14, 100.0, -var14, 0.0, 0.0);
                var251.addVertexWithUV(var14, 100.0, -var14, 1.0, 0.0);
                var251.addVertexWithUV(var14, 100.0, var14, 1.0, 1.0);
                var251.addVertexWithUV(-var14, 100.0, var14, 0.0, 1.0);
                var241.draw();
                var14 = 20.0f;
                this.renderEngine.bindTexture(locationMoonPhasesPng);
                int var27 = this.theWorld.getMoonPhase();
                int var28 = var27 % 4;
                var31 = var27 / 4 % 2;
                var18 = (float)(var28 + 0) / 4.0f;
                var19 = (float)(var31 + 0) / 2.0f;
                float var20 = (float)(var28 + 1) / 4.0f;
                float var21 = (float)(var31 + 1) / 2.0f;
                var251.startDrawingQuads();
                var251.addVertexWithUV(-var14, -100.0, var14, var20, var21);
                var251.addVertexWithUV(var14, -100.0, var14, var18, var21);
                var251.addVertexWithUV(var14, -100.0, -var14, var18, var19);
                var251.addVertexWithUV(-var14, -100.0, -var14, var20, var19);
                var241.draw();
            }
            GlStateManager.func_179090_x();
            var22 = this.theWorld.getStarBrightness(partialTicks) * var10;
            if (var22 > 0.0f && Config.isStarsEnabled() && !CustomSky.hasSkyLayers(this.theWorld)) {
                GlStateManager.color(var22, var22, var22, var22);
                if (this.field_175005_X) {
                    this.field_175013_s.func_177359_a();
                    GL11.glEnableClientState((int)32884);
                    GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                    this.field_175013_s.func_177358_a(7);
                    this.field_175013_s.func_177361_b();
                    GL11.glDisableClientState((int)32884);
                } else {
                    GlStateManager.callList(this.starGLCallList);
                }
            }
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.disableBlend();
            GlStateManager.enableAlpha();
            GlStateManager.enableFog();
            GlStateManager.popMatrix();
            GlStateManager.func_179090_x();
            GlStateManager.color(0.0f, 0.0f, 0.0f);
            double var29 = this.mc.thePlayer.func_174824_e((float)partialTicks).yCoord - this.theWorld.getHorizon();
            if (var29 < 0.0) {
                GlStateManager.pushMatrix();
                GlStateManager.translate(0.0f, 12.0f, 0.0f);
                if (this.field_175005_X) {
                    this.field_175011_u.func_177359_a();
                    GL11.glEnableClientState((int)32884);
                    GL11.glVertexPointer((int)3, (int)5126, (int)12, (long)0L);
                    this.field_175011_u.func_177358_a(7);
                    this.field_175011_u.func_177361_b();
                    GL11.glDisableClientState((int)32884);
                } else {
                    GlStateManager.callList(this.glSkyList2);
                }
                GlStateManager.popMatrix();
                var12 = 1.0f;
                var13 = -((float)(var29 + 65.0));
                var14 = -1.0f;
                var251.startDrawingQuads();
                var251.func_178974_a(0, 255);
                var251.addVertex(-1.0, var13, 1.0);
                var251.addVertex(1.0, var13, 1.0);
                var251.addVertex(1.0, -1.0, 1.0);
                var251.addVertex(-1.0, -1.0, 1.0);
                var251.addVertex(-1.0, -1.0, -1.0);
                var251.addVertex(1.0, -1.0, -1.0);
                var251.addVertex(1.0, var13, -1.0);
                var251.addVertex(-1.0, var13, -1.0);
                var251.addVertex(1.0, -1.0, -1.0);
                var251.addVertex(1.0, -1.0, 1.0);
                var251.addVertex(1.0, var13, 1.0);
                var251.addVertex(1.0, var13, -1.0);
                var251.addVertex(-1.0, var13, -1.0);
                var251.addVertex(-1.0, var13, 1.0);
                var251.addVertex(-1.0, -1.0, 1.0);
                var251.addVertex(-1.0, -1.0, -1.0);
                var251.addVertex(-1.0, -1.0, -1.0);
                var251.addVertex(-1.0, -1.0, 1.0);
                var251.addVertex(1.0, -1.0, 1.0);
                var251.addVertex(1.0, -1.0, -1.0);
                var241.draw();
            }
            if (this.theWorld.provider.isSkyColored()) {
                GlStateManager.color(var231 * 0.2f + 0.04f, var5 * 0.2f + 0.04f, var6 * 0.6f + 0.1f);
            } else {
                GlStateManager.color(var231, var5, var6);
            }
            if (this.mc.gameSettings.renderDistanceChunks <= 4) {
                GlStateManager.color(this.mc.entityRenderer.field_175080_Q, this.mc.entityRenderer.field_175082_R, this.mc.entityRenderer.field_175081_S);
            }
            GlStateManager.pushMatrix();
            GlStateManager.translate(0.0f, -((float)(var29 - 16.0)), 0.0f);
            if (Config.isSkyEnabled()) {
                GlStateManager.callList(this.glSkyList2);
            }
            GlStateManager.popMatrix();
            GlStateManager.func_179098_w();
            GlStateManager.depthMask(true);
        }
    }

    public void func_180447_b(float p_180447_1_, int p_180447_2_) {
        if (!Config.isCloudsOff()) {
            WorldProvider partialTicks;
            Object var3;
            if (Reflector.ForgeWorldProvider_getCloudRenderer.exists() && (var3 = Reflector.call(partialTicks = this.mc.theWorld.provider, Reflector.ForgeWorldProvider_getCloudRenderer, new Object[0])) != null) {
                Reflector.callVoid(var3, Reflector.IRenderHandler_render, Float.valueOf(p_180447_1_), this.theWorld, this.mc);
                return;
            }
            if (this.mc.theWorld.provider.isSurfaceWorld()) {
                if (Config.isCloudsFancy()) {
                    this.func_180445_c(p_180447_1_, p_180447_2_);
                } else {
                    this.cloudRenderer.prepareToRender(false, this.cloudTickCounter, p_180447_1_);
                    p_180447_1_ = 0.0f;
                    GlStateManager.disableCull();
                    float var31 = (float)(this.mc.func_175606_aa().lastTickPosY + (this.mc.func_175606_aa().posY - this.mc.func_175606_aa().lastTickPosY) * (double)p_180447_1_);
                    boolean var4 = true;
                    boolean var5 = true;
                    Tessellator var6 = Tessellator.getInstance();
                    WorldRenderer var7 = var6.getWorldRenderer();
                    this.renderEngine.bindTexture(locationCloudsPng);
                    GlStateManager.enableBlend();
                    GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
                    if (this.cloudRenderer.shouldUpdateGlList()) {
                        float var12;
                        this.cloudRenderer.startUpdateGlList();
                        Vec3 var8 = this.theWorld.getCloudColour(p_180447_1_);
                        float var9 = (float)var8.xCoord;
                        float var10 = (float)var8.yCoord;
                        float var11 = (float)var8.zCoord;
                        if (p_180447_2_ != 2) {
                            var12 = (var9 * 30.0f + var10 * 59.0f + var11 * 11.0f) / 100.0f;
                            float var26 = (var9 * 30.0f + var10 * 70.0f) / 100.0f;
                            float var14 = (var9 * 30.0f + var11 * 70.0f) / 100.0f;
                            var9 = var12;
                            var10 = var26;
                            var11 = var14;
                        }
                        var12 = 4.8828125E-4f;
                        double var261 = (float)this.cloudTickCounter + p_180447_1_;
                        double var15 = this.mc.func_175606_aa().prevPosX + (this.mc.func_175606_aa().posX - this.mc.func_175606_aa().prevPosX) * (double)p_180447_1_ + var261 * (double)0.03f;
                        double var17 = this.mc.func_175606_aa().prevPosZ + (this.mc.func_175606_aa().posZ - this.mc.func_175606_aa().prevPosZ) * (double)p_180447_1_;
                        int var19 = MathHelper.floor_double(var15 / 2048.0);
                        int var20 = MathHelper.floor_double(var17 / 2048.0);
                        float var21 = this.theWorld.provider.getCloudHeight() - var31 + 0.33f;
                        var21 += this.mc.gameSettings.ofCloudsHeight * 128.0f;
                        float var22 = (float)((var15 -= (double)(var19 * 2048)) * 4.8828125E-4);
                        float var23 = (float)((var17 -= (double)(var20 * 2048)) * 4.8828125E-4);
                        var7.startDrawingQuads();
                        var7.func_178960_a(var9, var10, var11, 0.8f);
                        int var24 = -256;
                        while (var24 < 256) {
                            int var25 = -256;
                            while (var25 < 256) {
                                var7.addVertexWithUV(var24 + 0, var21, var25 + 32, (float)(var24 + 0) * 4.8828125E-4f + var22, (float)(var25 + 32) * 4.8828125E-4f + var23);
                                var7.addVertexWithUV(var24 + 32, var21, var25 + 32, (float)(var24 + 32) * 4.8828125E-4f + var22, (float)(var25 + 32) * 4.8828125E-4f + var23);
                                var7.addVertexWithUV(var24 + 32, var21, var25 + 0, (float)(var24 + 32) * 4.8828125E-4f + var22, (float)(var25 + 0) * 4.8828125E-4f + var23);
                                var7.addVertexWithUV(var24 + 0, var21, var25 + 0, (float)(var24 + 0) * 4.8828125E-4f + var22, (float)(var25 + 0) * 4.8828125E-4f + var23);
                                var25 += 32;
                            }
                            var24 += 32;
                        }
                        var6.draw();
                        this.cloudRenderer.endUpdateGlList();
                    }
                    this.cloudRenderer.renderGlList();
                    GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                    GlStateManager.disableBlend();
                    GlStateManager.enableCull();
                }
            }
        }
    }

    public boolean hasCloudFog(double p_72721_1_, double p_72721_3_, double p_72721_5_, float p_72721_7_) {
        return false;
    }

    private void func_180445_c(float p_180445_1_, int p_180445_2_) {
        float var23;
        float var22;
        float var21;
        this.cloudRenderer.prepareToRender(true, this.cloudTickCounter, p_180445_1_);
        p_180445_1_ = 0.0f;
        GlStateManager.disableCull();
        float var3 = (float)(this.mc.func_175606_aa().lastTickPosY + (this.mc.func_175606_aa().posY - this.mc.func_175606_aa().lastTickPosY) * (double)p_180445_1_);
        Tessellator var4 = Tessellator.getInstance();
        WorldRenderer var5 = var4.getWorldRenderer();
        float var6 = 12.0f;
        float var7 = 4.0f;
        double var8 = (float)this.cloudTickCounter + p_180445_1_;
        double var10 = (this.mc.func_175606_aa().prevPosX + (this.mc.func_175606_aa().posX - this.mc.func_175606_aa().prevPosX) * (double)p_180445_1_ + var8 * (double)0.03f) / 12.0;
        double var12 = (this.mc.func_175606_aa().prevPosZ + (this.mc.func_175606_aa().posZ - this.mc.func_175606_aa().prevPosZ) * (double)p_180445_1_) / 12.0 + (double)0.33f;
        float var14 = this.theWorld.provider.getCloudHeight() - var3 + 0.33f;
        var14 += this.mc.gameSettings.ofCloudsHeight * 128.0f;
        int var15 = MathHelper.floor_double(var10 / 2048.0);
        int var16 = MathHelper.floor_double(var12 / 2048.0);
        var10 -= (double)(var15 * 2048);
        var12 -= (double)(var16 * 2048);
        this.renderEngine.bindTexture(locationCloudsPng);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        Vec3 var17 = this.theWorld.getCloudColour(p_180445_1_);
        float var18 = (float)var17.xCoord;
        float var19 = (float)var17.yCoord;
        float var20 = (float)var17.zCoord;
        if (p_180445_2_ != 2) {
            var21 = (var18 * 30.0f + var19 * 59.0f + var20 * 11.0f) / 100.0f;
            var22 = (var18 * 30.0f + var19 * 70.0f) / 100.0f;
            var23 = (var18 * 30.0f + var20 * 70.0f) / 100.0f;
            var18 = var21;
            var19 = var22;
            var20 = var23;
        }
        var21 = 0.00390625f;
        var22 = (float)MathHelper.floor_double(var10) * 0.00390625f;
        var23 = (float)MathHelper.floor_double(var12) * 0.00390625f;
        float var24 = (float)(var10 - (double)MathHelper.floor_double(var10));
        float var25 = (float)(var12 - (double)MathHelper.floor_double(var12));
        boolean var26 = true;
        boolean var27 = true;
        float var28 = 9.765625E-4f;
        GlStateManager.scale(12.0f, 1.0f, 12.0f);
        int var30 = 0;
        while (var30 < 2) {
            if (var30 == 0) {
                GlStateManager.colorMask(false, false, false, false);
            } else {
                switch (p_180445_2_) {
                    case 0: {
                        GlStateManager.colorMask(false, true, true, true);
                        break;
                    }
                    case 1: {
                        GlStateManager.colorMask(true, false, false, true);
                        break;
                    }
                    case 2: {
                        GlStateManager.colorMask(true, true, true, true);
                    }
                }
            }
            this.cloudRenderer.renderGlList();
            ++var30;
        }
        if (this.cloudRenderer.shouldUpdateGlList()) {
            this.cloudRenderer.startUpdateGlList();
            var30 = -3;
            while (var30 <= 4) {
                int var31 = -3;
                while (var31 <= 4) {
                    int var36;
                    var5.startDrawingQuads();
                    float var32 = var30 * 8;
                    float var33 = var31 * 8;
                    float var34 = var32 - var24;
                    float var35 = var33 - var25;
                    if (var14 > -5.0f) {
                        var5.func_178960_a(var18 * 0.7f, var19 * 0.7f, var20 * 0.7f, 0.8f);
                        var5.func_178980_d(0.0f, -1.0f, 0.0f);
                        var5.addVertexWithUV(var34 + 0.0f, var14 + 0.0f, var35 + 8.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 8.0f, var14 + 0.0f, var35 + 8.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 8.0f, var14 + 0.0f, var35 + 0.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 0.0f, var14 + 0.0f, var35 + 0.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                    }
                    if (var14 <= 5.0f) {
                        var5.func_178960_a(var18, var19, var20, 0.8f);
                        var5.func_178980_d(0.0f, 1.0f, 0.0f);
                        var5.addVertexWithUV(var34 + 0.0f, var14 + 4.0f - 9.765625E-4f, var35 + 8.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 8.0f, var14 + 4.0f - 9.765625E-4f, var35 + 8.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 8.0f, var14 + 4.0f - 9.765625E-4f, var35 + 0.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                        var5.addVertexWithUV(var34 + 0.0f, var14 + 4.0f - 9.765625E-4f, var35 + 0.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                    }
                    var5.func_178960_a(var18 * 0.9f, var19 * 0.9f, var20 * 0.9f, 0.8f);
                    if (var30 > -1) {
                        var5.func_178980_d(-1.0f, 0.0f, 0.0f);
                        var36 = 0;
                        while (var36 < 8) {
                            var5.addVertexWithUV(var34 + (float)var36 + 0.0f, var14 + 0.0f, var35 + 8.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 0.0f, var14 + 4.0f, var35 + 8.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 0.0f, var14 + 4.0f, var35 + 0.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 0.0f, var14 + 0.0f, var35 + 0.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                            ++var36;
                        }
                    }
                    if (var30 <= 1) {
                        var5.func_178980_d(1.0f, 0.0f, 0.0f);
                        var36 = 0;
                        while (var36 < 8) {
                            var5.addVertexWithUV(var34 + (float)var36 + 1.0f - 9.765625E-4f, var14 + 0.0f, var35 + 8.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 1.0f - 9.765625E-4f, var14 + 4.0f, var35 + 8.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 8.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 1.0f - 9.765625E-4f, var14 + 4.0f, var35 + 0.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + (float)var36 + 1.0f - 9.765625E-4f, var14 + 0.0f, var35 + 0.0f, (var32 + (float)var36 + 0.5f) * 0.00390625f + var22, (var33 + 0.0f) * 0.00390625f + var23);
                            ++var36;
                        }
                    }
                    var5.func_178960_a(var18 * 0.8f, var19 * 0.8f, var20 * 0.8f, 0.8f);
                    if (var31 > -1) {
                        var5.func_178980_d(0.0f, 0.0f, -1.0f);
                        var36 = 0;
                        while (var36 < 8) {
                            var5.addVertexWithUV(var34 + 0.0f, var14 + 4.0f, var35 + (float)var36 + 0.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 8.0f, var14 + 4.0f, var35 + (float)var36 + 0.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 8.0f, var14 + 0.0f, var35 + (float)var36 + 0.0f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 0.0f, var14 + 0.0f, var35 + (float)var36 + 0.0f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            ++var36;
                        }
                    }
                    if (var31 <= 1) {
                        var5.func_178980_d(0.0f, 0.0f, 1.0f);
                        var36 = 0;
                        while (var36 < 8) {
                            var5.addVertexWithUV(var34 + 0.0f, var14 + 4.0f, var35 + (float)var36 + 1.0f - 9.765625E-4f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 8.0f, var14 + 4.0f, var35 + (float)var36 + 1.0f - 9.765625E-4f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 8.0f, var14 + 0.0f, var35 + (float)var36 + 1.0f - 9.765625E-4f, (var32 + 8.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            var5.addVertexWithUV(var34 + 0.0f, var14 + 0.0f, var35 + (float)var36 + 1.0f - 9.765625E-4f, (var32 + 0.0f) * 0.00390625f + var22, (var33 + (float)var36 + 0.5f) * 0.00390625f + var23);
                            ++var36;
                        }
                    }
                    var4.draw();
                    ++var31;
                }
                ++var30;
            }
            this.cloudRenderer.endUpdateGlList();
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
    }

    public void func_174967_a(long p_174967_1_) {
        RenderChunk updatesPerFrame;
        Iterator countUpdated;
        this.displayListEntitiesDirty |= this.field_174995_M.func_178516_a(p_174967_1_);
        if (this.chunksToUpdateForced.size() > 0) {
            countUpdated = this.chunksToUpdateForced.iterator();
            while (countUpdated.hasNext()) {
                updatesPerFrame = (RenderChunk)countUpdated.next();
                if (!this.field_174995_M.func_178507_a(updatesPerFrame)) break;
                updatesPerFrame.func_178575_a(false);
                countUpdated.remove();
                this.field_175009_l.remove(updatesPerFrame);
                this.chunksToResortTransparency.remove(updatesPerFrame);
            }
        }
        if (this.chunksToResortTransparency.size() > 0 && (countUpdated = this.chunksToResortTransparency.iterator()).hasNext() && this.field_174995_M.func_178509_c(updatesPerFrame = (RenderChunk)countUpdated.next())) {
            countUpdated.remove();
        }
        int var8 = 0;
        int var9 = Config.getUpdatesPerFrame();
        int maxUpdatesPerFrame = var9 * 2;
        Iterator var3 = this.field_175009_l.iterator();
        while (var3.hasNext()) {
            RenderChunk var4 = (RenderChunk)var3.next();
            if (!this.field_174995_M.func_178507_a(var4)) break;
            var4.func_178575_a(false);
            var3.remove();
            if (var4.func_178571_g().func_178489_a() && var9 < maxUpdatesPerFrame) {
                ++var9;
            }
            if (++var8 >= var9) break;
        }
    }

    public void func_180449_a(Entity p_180449_1_, float p_180449_2_) {
        Tessellator var3 = Tessellator.getInstance();
        WorldRenderer var4 = var3.getWorldRenderer();
        WorldBorder var5 = this.theWorld.getWorldBorder();
        double var6 = this.mc.gameSettings.renderDistanceChunks * 16;
        if (p_180449_1_.posX >= var5.maxX() - var6 || p_180449_1_.posX <= var5.minX() + var6 || p_180449_1_.posZ >= var5.maxZ() - var6 || p_180449_1_.posZ <= var5.minZ() + var6) {
            float var33;
            double var31;
            double var29;
            float var28;
            double var8 = 1.0 - var5.getClosestDistance(p_180449_1_) / var6;
            var8 = Math.pow(var8, 4.0);
            double var10 = p_180449_1_.lastTickPosX + (p_180449_1_.posX - p_180449_1_.lastTickPosX) * (double)p_180449_2_;
            double var12 = p_180449_1_.lastTickPosY + (p_180449_1_.posY - p_180449_1_.lastTickPosY) * (double)p_180449_2_;
            double var14 = p_180449_1_.lastTickPosZ + (p_180449_1_.posZ - p_180449_1_.lastTickPosZ) * (double)p_180449_2_;
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 1, 1, 0);
            this.renderEngine.bindTexture(field_175006_g);
            GlStateManager.depthMask(false);
            GlStateManager.pushMatrix();
            int var16 = var5.getStatus().func_177766_a();
            float var17 = (float)(var16 >> 16 & 0xFF) / 255.0f;
            float var18 = (float)(var16 >> 8 & 0xFF) / 255.0f;
            float var19 = (float)(var16 & 0xFF) / 255.0f;
            GlStateManager.color(var17, var18, var19, (float)var8);
            GlStateManager.doPolygonOffset(-3.0f, -3.0f);
            GlStateManager.enablePolygonOffset();
            GlStateManager.alphaFunc(516, 0.1f);
            GlStateManager.enableAlpha();
            GlStateManager.disableCull();
            float var20 = (float)(Minecraft.getSystemTime() % 3000L) / 3000.0f;
            float var21 = 0.0f;
            float var22 = 0.0f;
            float var23 = 128.0f;
            var4.startDrawingQuads();
            var4.setTranslation(-var10, -var12, -var14);
            var4.markDirty();
            double var24 = Math.max((double)MathHelper.floor_double(var14 - var6), var5.minZ());
            double var26 = Math.min((double)MathHelper.ceiling_double_int(var14 + var6), var5.maxZ());
            if (var10 > var5.maxX() - var6) {
                var28 = 0.0f;
                var29 = var24;
                while (var29 < var26) {
                    var31 = Math.min(1.0, var26 - var29);
                    var33 = (float)var31 * 0.5f;
                    var4.addVertexWithUV(var5.maxX(), 256.0, var29, var20 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var5.maxX(), 256.0, var29 + var31, var20 + var33 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var5.maxX(), 0.0, var29 + var31, var20 + var33 + var28, var20 + 128.0f);
                    var4.addVertexWithUV(var5.maxX(), 0.0, var29, var20 + var28, var20 + 128.0f);
                    var29 += 1.0;
                    var28 += 0.5f;
                }
            }
            if (var10 < var5.minX() + var6) {
                var28 = 0.0f;
                var29 = var24;
                while (var29 < var26) {
                    var31 = Math.min(1.0, var26 - var29);
                    var33 = (float)var31 * 0.5f;
                    var4.addVertexWithUV(var5.minX(), 256.0, var29, var20 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var5.minX(), 256.0, var29 + var31, var20 + var33 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var5.minX(), 0.0, var29 + var31, var20 + var33 + var28, var20 + 128.0f);
                    var4.addVertexWithUV(var5.minX(), 0.0, var29, var20 + var28, var20 + 128.0f);
                    var29 += 1.0;
                    var28 += 0.5f;
                }
            }
            var24 = Math.max((double)MathHelper.floor_double(var10 - var6), var5.minX());
            var26 = Math.min((double)MathHelper.ceiling_double_int(var10 + var6), var5.maxX());
            if (var14 > var5.maxZ() - var6) {
                var28 = 0.0f;
                var29 = var24;
                while (var29 < var26) {
                    var31 = Math.min(1.0, var26 - var29);
                    var33 = (float)var31 * 0.5f;
                    var4.addVertexWithUV(var29, 256.0, var5.maxZ(), var20 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var29 + var31, 256.0, var5.maxZ(), var20 + var33 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var29 + var31, 0.0, var5.maxZ(), var20 + var33 + var28, var20 + 128.0f);
                    var4.addVertexWithUV(var29, 0.0, var5.maxZ(), var20 + var28, var20 + 128.0f);
                    var29 += 1.0;
                    var28 += 0.5f;
                }
            }
            if (var14 < var5.minZ() + var6) {
                var28 = 0.0f;
                var29 = var24;
                while (var29 < var26) {
                    var31 = Math.min(1.0, var26 - var29);
                    var33 = (float)var31 * 0.5f;
                    var4.addVertexWithUV(var29, 256.0, var5.minZ(), var20 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var29 + var31, 256.0, var5.minZ(), var20 + var33 + var28, var20 + 0.0f);
                    var4.addVertexWithUV(var29 + var31, 0.0, var5.minZ(), var20 + var33 + var28, var20 + 128.0f);
                    var4.addVertexWithUV(var29, 0.0, var5.minZ(), var20 + var28, var20 + 128.0f);
                    var29 += 1.0;
                    var28 += 0.5f;
                }
            }
            var3.draw();
            var4.setTranslation(0.0, 0.0, 0.0);
            GlStateManager.enableCull();
            GlStateManager.disableAlpha();
            GlStateManager.doPolygonOffset(0.0f, 0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.enableAlpha();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
            GlStateManager.depthMask(true);
        }
    }

    private void func_180443_s() {
        GlStateManager.tryBlendFuncSeparate(774, 768, 1, 0);
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 0.5f);
        GlStateManager.doPolygonOffset(-3.0f, -3.0f);
        GlStateManager.enablePolygonOffset();
        GlStateManager.alphaFunc(516, 0.1f);
        GlStateManager.enableAlpha();
        GlStateManager.pushMatrix();
    }

    private void func_174969_t() {
        GlStateManager.disableAlpha();
        GlStateManager.doPolygonOffset(0.0f, 0.0f);
        GlStateManager.disablePolygonOffset();
        GlStateManager.enableAlpha();
        GlStateManager.depthMask(true);
        GlStateManager.popMatrix();
    }

    public void func_174981_a(Tessellator p_174981_1_, WorldRenderer p_174981_2_, Entity p_174981_3_, float p_174981_4_) {
        double var5 = p_174981_3_.lastTickPosX + (p_174981_3_.posX - p_174981_3_.lastTickPosX) * (double)p_174981_4_;
        double var7 = p_174981_3_.lastTickPosY + (p_174981_3_.posY - p_174981_3_.lastTickPosY) * (double)p_174981_4_;
        double var9 = p_174981_3_.lastTickPosZ + (p_174981_3_.posZ - p_174981_3_.lastTickPosZ) * (double)p_174981_4_;
        if (!this.damagedBlocks.isEmpty()) {
            this.renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            this.func_180443_s();
            p_174981_2_.startDrawingQuads();
            p_174981_2_.setVertexFormat(DefaultVertexFormats.field_176600_a);
            p_174981_2_.setTranslation(-var5, -var7, -var9);
            p_174981_2_.markDirty();
            Iterator var11 = this.damagedBlocks.values().iterator();
            while (var11.hasNext()) {
                boolean renderBreaking;
                DestroyBlockProgress var12 = (DestroyBlockProgress)var11.next();
                BlockPos var13 = var12.func_180246_b();
                double var14 = (double)var13.getX() - var5;
                double var16 = (double)var13.getY() - var7;
                double var18 = (double)var13.getZ() - var9;
                Block var20 = this.theWorld.getBlockState(var13).getBlock();
                if (Reflector.ForgeTileEntity_canRenderBreaking.exists()) {
                    TileEntity var23;
                    boolean var22;
                    boolean bl = var22 = var20 instanceof BlockChest || var20 instanceof BlockEnderChest || var20 instanceof BlockSign || var20 instanceof BlockSkull;
                    if (!var22 && (var23 = this.theWorld.getTileEntity(var13)) != null) {
                        var22 = Reflector.callBoolean(var23, Reflector.ForgeTileEntity_canRenderBreaking, new Object[0]);
                    }
                    renderBreaking = !var22;
                } else {
                    boolean bl = renderBreaking = !(var20 instanceof BlockChest) && !(var20 instanceof BlockEnderChest) && !(var20 instanceof BlockSign) && !(var20 instanceof BlockSkull);
                }
                if (!renderBreaking) continue;
                if (var14 * var14 + var16 * var16 + var18 * var18 > 1024.0) {
                    var11.remove();
                    continue;
                }
                IBlockState var21 = this.theWorld.getBlockState(var13);
                if (var21.getBlock().getMaterial() == Material.air) continue;
                int var221 = var12.getPartialBlockDamage();
                TextureAtlasSprite var231 = this.destroyBlockIcons[var221];
                BlockRendererDispatcher var24 = this.mc.getBlockRendererDispatcher();
                var24.func_175020_a(var21, var13, var231, this.theWorld);
            }
            p_174981_1_.draw();
            p_174981_2_.setTranslation(0.0, 0.0, 0.0);
            this.func_174969_t();
        }
    }

    public void drawSelectionBox(EntityPlayer p_72731_1_, MovingObjectPosition p_72731_2_, int p_72731_3_, float p_72731_4_) {
        if (p_72731_3_ == 0 && p_72731_2_.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
            GlStateManager.color(0.0f, 0.0f, 0.0f, 0.4f);
            GL11.glLineWidth((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.depthMask(false);
            float var5 = 0.002f;
            BlockPos var6 = p_72731_2_.func_178782_a();
            Block var7 = this.theWorld.getBlockState(var6).getBlock();
            if (var7.getMaterial() != Material.air && this.theWorld.getWorldBorder().contains(var6)) {
                var7.setBlockBoundsBasedOnState(this.theWorld, var6);
                double var8 = p_72731_1_.lastTickPosX + (p_72731_1_.posX - p_72731_1_.lastTickPosX) * (double)p_72731_4_;
                double var10 = p_72731_1_.lastTickPosY + (p_72731_1_.posY - p_72731_1_.lastTickPosY) * (double)p_72731_4_;
                double var12 = p_72731_1_.lastTickPosZ + (p_72731_1_.posZ - p_72731_1_.lastTickPosZ) * (double)p_72731_4_;
                RenderGlobal.drawOutlinedBoundingBox(var7.getSelectedBoundingBox(this.theWorld, var6).expand(0.002f, 0.002f, 0.002f).offset(-var8, -var10, -var12), -1);
            }
            GlStateManager.depthMask(true);
            GlStateManager.func_179098_w();
            GlStateManager.disableBlend();
        }
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB p_147590_0_, int p_147590_1_) {
        Tessellator var2 = Tessellator.getInstance();
        WorldRenderer var3 = var2.getWorldRenderer();
        var3.startDrawing(3);
        if (p_147590_1_ != -1) {
            var3.func_178991_c(p_147590_1_);
        }
        var3.addVertex(p_147590_0_.minX, p_147590_0_.minY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.minY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.minY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.minY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.minY, p_147590_0_.minZ);
        var2.draw();
        var3.startDrawing(3);
        if (p_147590_1_ != -1) {
            var3.func_178991_c(p_147590_1_);
        }
        var3.addVertex(p_147590_0_.minX, p_147590_0_.maxY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.maxY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.maxY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.maxY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.maxY, p_147590_0_.minZ);
        var2.draw();
        var3.startDrawing(1);
        if (p_147590_1_ != -1) {
            var3.func_178991_c(p_147590_1_);
        }
        var3.addVertex(p_147590_0_.minX, p_147590_0_.minY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.maxY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.minY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.maxY, p_147590_0_.minZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.minY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.maxX, p_147590_0_.maxY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.minY, p_147590_0_.maxZ);
        var3.addVertex(p_147590_0_.minX, p_147590_0_.maxY, p_147590_0_.maxZ);
        var2.draw();
    }

    private void markBlocksForUpdate(int p_72725_1_, int p_72725_2_, int p_72725_3_, int p_72725_4_, int p_72725_5_, int p_72725_6_) {
        this.field_175008_n.func_178162_a(p_72725_1_, p_72725_2_, p_72725_3_, p_72725_4_, p_72725_5_, p_72725_6_);
    }

    @Override
    public void markBlockForUpdate(BlockPos pos) {
        int var2 = pos.getX();
        int var3 = pos.getY();
        int var4 = pos.getZ();
        this.markBlocksForUpdate(var2 - 1, var3 - 1, var4 - 1, var2 + 1, var3 + 1, var4 + 1);
    }

    @Override
    public void notifyLightSet(BlockPos pos) {
        int var2 = pos.getX();
        int var3 = pos.getY();
        int var4 = pos.getZ();
        this.markBlocksForUpdate(var2 - 1, var3 - 1, var4 - 1, var2 + 1, var3 + 1, var4 + 1);
    }

    @Override
    public void markBlockRangeForRenderUpdate(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.markBlocksForUpdate(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1);
    }

    @Override
    public void func_174961_a(String p_174961_1_, BlockPos p_174961_2_) {
        ISound var3 = (ISound)this.mapSoundPositions.get(p_174961_2_);
        if (var3 != null) {
            this.mc.getSoundHandler().stopSound(var3);
            this.mapSoundPositions.remove(p_174961_2_);
        }
        if (p_174961_1_ != null) {
            ItemRecord var4 = ItemRecord.getRecord(p_174961_1_);
            if (var4 != null) {
                this.mc.ingameGUI.setRecordPlayingMessage(var4.getRecordNameLocal());
            }
            ResourceLocation resource = null;
            if (Reflector.ForgeItemRecord_getRecordResource.exists() && var4 != null) {
                resource = (ResourceLocation)Reflector.call(var4, Reflector.ForgeItemRecord_getRecordResource, p_174961_1_);
            }
            if (resource == null) {
                resource = new ResourceLocation(p_174961_1_);
            }
            PositionedSoundRecord var5 = PositionedSoundRecord.createRecordSoundAtPosition(resource, p_174961_2_.getX(), p_174961_2_.getY(), p_174961_2_.getZ());
            this.mapSoundPositions.put(p_174961_2_, var5);
            this.mc.getSoundHandler().playSound(var5);
        }
    }

    @Override
    public void playSound(String soundName, double x, double y, double z, float volume, float pitch) {
    }

    @Override
    public void playSoundToNearExcept(EntityPlayer except, String soundName, double x, double y, double z, float volume, float pitch) {
    }

    @Override
    public void func_180442_a(int p_180442_1_, boolean p_180442_2_, final double p_180442_3_, final double p_180442_5_, final double p_180442_7_, double p_180442_9_, double p_180442_11_, double p_180442_13_, int ... p_180442_15_) {
        try {
            this.func_174974_b(p_180442_1_, p_180442_2_, p_180442_3_, p_180442_5_, p_180442_7_, p_180442_9_, p_180442_11_, p_180442_13_, p_180442_15_);
        }
        catch (Throwable var19) {
            CrashReport var17 = CrashReport.makeCrashReport(var19, "Exception while adding particle");
            CrashReportCategory var18 = var17.makeCategory("Particle being added");
            var18.addCrashSection("ID", p_180442_1_);
            if (p_180442_15_ != null) {
                var18.addCrashSection("Parameters", p_180442_15_);
            }
            var18.addCrashSectionCallable("Position", new Callable(){

                public String call() {
                    return CrashReportCategory.getCoordinateInfo(p_180442_3_, p_180442_5_, p_180442_7_);
                }
            });
            throw new ReportedException(var17);
        }
    }

    private void func_174972_a(EnumParticleTypes p_174972_1_, double p_174972_2_, double p_174972_4_, double p_174972_6_, double p_174972_8_, double p_174972_10_, double p_174972_12_, int ... p_174972_14_) {
        this.func_180442_a(p_174972_1_.func_179348_c(), p_174972_1_.func_179344_e(), p_174972_2_, p_174972_4_, p_174972_6_, p_174972_8_, p_174972_10_, p_174972_12_, p_174972_14_);
    }

    private EntityFX func_174974_b(int p_174974_1_, boolean p_174974_2_, double p_174974_3_, double p_174974_5_, double p_174974_7_, double p_174974_9_, double p_174974_11_, double p_174974_13_, int ... p_174974_15_) {
        if (this.mc != null && this.mc.func_175606_aa() != null && this.mc.effectRenderer != null) {
            int var16 = this.mc.gameSettings.particleSetting;
            if (var16 == 1 && this.theWorld.rand.nextInt(3) == 0) {
                var16 = 2;
            }
            double var17 = this.mc.func_175606_aa().posX - p_174974_3_;
            double var19 = this.mc.func_175606_aa().posY - p_174974_5_;
            double var21 = this.mc.func_175606_aa().posZ - p_174974_7_;
            if (p_174974_1_ == EnumParticleTypes.EXPLOSION_HUGE.func_179348_c() && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.EXPLOSION_LARGE.func_179348_c() && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c() && !Config.isAnimatedExplosion()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SUSPENDED.func_179348_c() && !Config.isWaterParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SUSPENDED_DEPTH.func_179348_c() && !Config.isVoidParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SMOKE_NORMAL.func_179348_c() && !Config.isAnimatedSmoke()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SMOKE_LARGE.func_179348_c() && !Config.isAnimatedSmoke()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SPELL_MOB.func_179348_c() && !Config.isPotionParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SPELL_MOB_AMBIENT.func_179348_c() && !Config.isPotionParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SPELL.func_179348_c() && !Config.isPotionParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SPELL_INSTANT.func_179348_c() && !Config.isPotionParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.SPELL_WITCH.func_179348_c() && !Config.isPotionParticles()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.PORTAL.func_179348_c() && !Config.isAnimatedPortal()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.FLAME.func_179348_c() && !Config.isAnimatedFlame()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.REDSTONE.func_179348_c() && !Config.isAnimatedRedstone()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.DRIP_WATER.func_179348_c() && !Config.isDrippingWaterLava()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.DRIP_LAVA.func_179348_c() && !Config.isDrippingWaterLava()) {
                return null;
            }
            if (p_174974_1_ == EnumParticleTypes.FIREWORKS_SPARK.func_179348_c() && !Config.isFireworkParticles()) {
                return null;
            }
            if (p_174974_2_) {
                return this.mc.effectRenderer.func_178927_a(p_174974_1_, p_174974_3_, p_174974_5_, p_174974_7_, p_174974_9_, p_174974_11_, p_174974_13_, p_174974_15_);
            }
            double var23 = 16.0;
            double maxDistSq = 256.0;
            if (p_174974_1_ == EnumParticleTypes.CRIT.func_179348_c()) {
                maxDistSq = 38416.0;
            }
            if (var17 * var17 + var19 * var19 + var21 * var21 > maxDistSq) {
                return null;
            }
            if (var16 > 1) {
                return null;
            }
            EntityFX entityFx = this.mc.effectRenderer.func_178927_a(p_174974_1_, p_174974_3_, p_174974_5_, p_174974_7_, p_174974_9_, p_174974_11_, p_174974_13_, p_174974_15_);
            if (p_174974_1_ == EnumParticleTypes.WATER_BUBBLE.func_179348_c()) {
                CustomColorizer.updateWaterFX(entityFx, this.theWorld, p_174974_3_, p_174974_5_, p_174974_7_);
            }
            if (p_174974_1_ == EnumParticleTypes.WATER_SPLASH.func_179348_c()) {
                CustomColorizer.updateWaterFX(entityFx, this.theWorld, p_174974_3_, p_174974_5_, p_174974_7_);
            }
            if (p_174974_1_ == EnumParticleTypes.WATER_DROP.func_179348_c()) {
                CustomColorizer.updateWaterFX(entityFx, this.theWorld, p_174974_3_, p_174974_5_, p_174974_7_);
            }
            if (p_174974_1_ == EnumParticleTypes.TOWN_AURA.func_179348_c()) {
                CustomColorizer.updateMyceliumFX(entityFx);
            }
            if (p_174974_1_ == EnumParticleTypes.PORTAL.func_179348_c()) {
                CustomColorizer.updatePortalFX(entityFx);
            }
            if (p_174974_1_ == EnumParticleTypes.REDSTONE.func_179348_c()) {
                CustomColorizer.updateReddustFX(entityFx, this.theWorld, p_174974_3_, p_174974_5_, p_174974_7_);
            }
            return entityFx;
        }
        return null;
    }

    @Override
    public void onEntityAdded(Entity entityIn) {
        RandomMobs.entityLoaded(entityIn);
    }

    @Override
    public void onEntityRemoved(Entity entityIn) {
    }

    public void deleteAllDisplayLists() {
    }

    @Override
    public void func_180440_a(int p_180440_1_, BlockPos p_180440_2_, int p_180440_3_) {
        switch (p_180440_1_) {
            case 1013: 
            case 1018: {
                if (this.mc.func_175606_aa() == null) break;
                double var4 = (double)p_180440_2_.getX() - this.mc.func_175606_aa().posX;
                double var6 = (double)p_180440_2_.getY() - this.mc.func_175606_aa().posY;
                double var8 = (double)p_180440_2_.getZ() - this.mc.func_175606_aa().posZ;
                double var10 = Math.sqrt(var4 * var4 + var6 * var6 + var8 * var8);
                double var12 = this.mc.func_175606_aa().posX;
                double var14 = this.mc.func_175606_aa().posY;
                double var16 = this.mc.func_175606_aa().posZ;
                if (var10 > 0.0) {
                    var12 += var4 / var10 * 2.0;
                    var14 += var6 / var10 * 2.0;
                    var16 += var8 / var10 * 2.0;
                }
                if (p_180440_1_ == 1013) {
                    this.theWorld.playSound(var12, var14, var16, "mob.wither.spawn", 1.0f, 1.0f, false);
                    break;
                }
                this.theWorld.playSound(var12, var14, var16, "mob.enderdragon.end", 5.0f, 1.0f, false);
            }
        }
    }

    @Override
    public void func_180439_a(EntityPlayer p_180439_1_, int p_180439_2_, BlockPos p_180439_3_, int p_180439_4_) {
        Random var5 = this.theWorld.rand;
        switch (p_180439_2_) {
            case 1000: {
                this.theWorld.func_175731_a(p_180439_3_, "random.click", 1.0f, 1.0f, false);
                break;
            }
            case 1001: {
                this.theWorld.func_175731_a(p_180439_3_, "random.click", 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.theWorld.func_175731_a(p_180439_3_, "random.bow", 1.0f, 1.2f, false);
                break;
            }
            case 1003: {
                this.theWorld.func_175731_a(p_180439_3_, "random.door_open", 1.0f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1004: {
                this.theWorld.func_175731_a(p_180439_3_, "random.fizz", 0.5f, 2.6f + (var5.nextFloat() - var5.nextFloat()) * 0.8f, false);
                break;
            }
            case 1005: {
                if (Item.getItemById(p_180439_4_) instanceof ItemRecord) {
                    this.theWorld.func_175717_a(p_180439_3_, "records." + ((ItemRecord)Item.getItemById((int)p_180439_4_)).recordName);
                    break;
                }
                this.theWorld.func_175717_a(p_180439_3_, null);
                break;
            }
            case 1006: {
                this.theWorld.func_175731_a(p_180439_3_, "random.door_close", 1.0f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1007: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.ghast.charge", 10.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1008: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.ghast.fireball", 10.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1009: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.ghast.fireball", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1010: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.zombie.wood", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1011: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.zombie.metal", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1012: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.zombie.woodbreak", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1014: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.wither.shoot", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1015: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.bat.takeoff", 0.05f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.zombie.infect", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.theWorld.func_175731_a(p_180439_3_, "mob.zombie.unfect", 2.0f, (var5.nextFloat() - var5.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.theWorld.func_175731_a(p_180439_3_, "random.anvil_break", 1.0f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1021: {
                this.theWorld.func_175731_a(p_180439_3_, "random.anvil_use", 1.0f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1022: {
                this.theWorld.func_175731_a(p_180439_3_, "random.anvil_land", 0.3f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2000: {
                int var31 = p_180439_4_ % 3 - 1;
                int var8 = p_180439_4_ / 3 % 3 - 1;
                double var9 = (double)p_180439_3_.getX() + (double)var31 * 0.6 + 0.5;
                double var11 = (double)p_180439_3_.getY() + 0.5;
                double var32 = (double)p_180439_3_.getZ() + (double)var8 * 0.6 + 0.5;
                int var39 = 0;
                while (var39 < 10) {
                    double var40 = var5.nextDouble() * 0.2 + 0.01;
                    double var41 = var9 + (double)var31 * 0.01 + (var5.nextDouble() - 0.5) * (double)var8 * 0.5;
                    double var25 = var11 + (var5.nextDouble() - 0.5) * 0.5;
                    double var27 = var32 + (double)var8 * 0.01 + (var5.nextDouble() - 0.5) * (double)var31 * 0.5;
                    double var42 = (double)var31 * var40 + var5.nextGaussian() * 0.01;
                    double var26 = -0.03 + var5.nextGaussian() * 0.01;
                    double var28 = (double)var8 * var40 + var5.nextGaussian() * 0.01;
                    this.func_174972_a(EnumParticleTypes.SMOKE_NORMAL, var41, var25, var27, var42, var26, var28, new int[0]);
                    ++var39;
                }
                return;
            }
            case 2001: {
                Block var6 = Block.getBlockById(p_180439_4_ & 0xFFF);
                if (var6.getMaterial() != Material.air) {
                    this.mc.getSoundHandler().playSound(new PositionedSoundRecord(new ResourceLocation(var6.stepSound.getBreakSound()), (var6.stepSound.getVolume() + 1.0f) / 2.0f, var6.stepSound.getFrequency() * 0.8f, (float)p_180439_3_.getX() + 0.5f, (float)p_180439_3_.getY() + 0.5f, (float)p_180439_3_.getZ() + 0.5f));
                }
                this.mc.effectRenderer.func_180533_a(p_180439_3_, var6.getStateFromMeta(p_180439_4_ >> 12 & 0xFF));
                break;
            }
            case 2002: {
                double var7 = p_180439_3_.getX();
                double var9 = p_180439_3_.getY();
                double var11 = p_180439_3_.getZ();
                int var13 = 0;
                while (var13 < 8) {
                    this.func_174972_a(EnumParticleTypes.ITEM_CRACK, var7, var9, var11, var5.nextGaussian() * 0.15, var5.nextDouble() * 0.2, var5.nextGaussian() * 0.15, Item.getIdFromItem(Items.potionitem), p_180439_4_);
                    ++var13;
                }
                var13 = Items.potionitem.getColorFromDamage(p_180439_4_);
                float var14 = (float)(var13 >> 16 & 0xFF) / 255.0f;
                float var15 = (float)(var13 >> 8 & 0xFF) / 255.0f;
                float var16 = (float)(var13 >> 0 & 0xFF) / 255.0f;
                EnumParticleTypes var17 = EnumParticleTypes.SPELL;
                if (Items.potionitem.isEffectInstant(p_180439_4_)) {
                    var17 = EnumParticleTypes.SPELL_INSTANT;
                }
                int var18 = 0;
                while (var18 < 100) {
                    double var19 = var5.nextDouble() * 4.0;
                    double var21 = var5.nextDouble() * Math.PI * 2.0;
                    double var23 = Math.cos(var21) * var19;
                    double var25 = 0.01 + var5.nextDouble() * 0.5;
                    double var27 = Math.sin(var21) * var19;
                    EntityFX var29 = this.func_174974_b(var17.func_179348_c(), var17.func_179344_e(), var7 + var23 * 0.1, var9 + 0.3, var11 + var27 * 0.1, var23, var25, var27, new int[0]);
                    if (var29 != null) {
                        float var30 = 0.75f + var5.nextFloat() * 0.25f;
                        var29.setRBGColorF(var14 * var30, var15 * var30, var16 * var30);
                        var29.multiplyVelocity((float)var19);
                    }
                    ++var18;
                }
                this.theWorld.func_175731_a(p_180439_3_, "game.potion.smash", 1.0f, this.theWorld.rand.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2003: {
                double var7 = (double)p_180439_3_.getX() + 0.5;
                double var9 = p_180439_3_.getY();
                double var11 = (double)p_180439_3_.getZ() + 0.5;
                int var13 = 0;
                while (var13 < 8) {
                    this.func_174972_a(EnumParticleTypes.ITEM_CRACK, var7, var9, var11, var5.nextGaussian() * 0.15, var5.nextDouble() * 0.2, var5.nextGaussian() * 0.15, Item.getIdFromItem(Items.ender_eye));
                    ++var13;
                }
                double var32 = 0.0;
                while (var32 < Math.PI * 2) {
                    this.func_174972_a(EnumParticleTypes.PORTAL, var7 + Math.cos(var32) * 5.0, var9 - 0.4, var11 + Math.sin(var32) * 5.0, Math.cos(var32) * -5.0, 0.0, Math.sin(var32) * -5.0, new int[0]);
                    this.func_174972_a(EnumParticleTypes.PORTAL, var7 + Math.cos(var32) * 5.0, var9 - 0.4, var11 + Math.sin(var32) * 5.0, Math.cos(var32) * -7.0, 0.0, Math.sin(var32) * -7.0, new int[0]);
                    var32 += 0.15707963267948966;
                }
                return;
            }
            case 2004: {
                int var18 = 0;
                while (var18 < 20) {
                    double var19 = (double)p_180439_3_.getX() + 0.5 + ((double)this.theWorld.rand.nextFloat() - 0.5) * 2.0;
                    double var21 = (double)p_180439_3_.getY() + 0.5 + ((double)this.theWorld.rand.nextFloat() - 0.5) * 2.0;
                    double var23 = (double)p_180439_3_.getZ() + 0.5 + ((double)this.theWorld.rand.nextFloat() - 0.5) * 2.0;
                    this.theWorld.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, var19, var21, var23, 0.0, 0.0, 0.0, new int[0]);
                    this.theWorld.spawnParticle(EnumParticleTypes.FLAME, var19, var21, var23, 0.0, 0.0, 0.0, new int[0]);
                    ++var18;
                }
                return;
            }
            case 2005: {
                ItemDye.func_180617_a(this.theWorld, p_180439_3_, p_180439_4_);
            }
        }
    }

    @Override
    public void sendBlockBreakProgress(int breakerId, BlockPos pos, int progress) {
        if (progress >= 0 && progress < 10) {
            DestroyBlockProgress var4 = (DestroyBlockProgress)this.damagedBlocks.get(breakerId);
            if (var4 == null || var4.func_180246_b().getX() != pos.getX() || var4.func_180246_b().getY() != pos.getY() || var4.func_180246_b().getZ() != pos.getZ()) {
                var4 = new DestroyBlockProgress(breakerId, pos);
                this.damagedBlocks.put(breakerId, var4);
            }
            var4.setPartialBlockDamage(progress);
            var4.setCloudUpdateTick(this.cloudTickCounter);
        } else {
            this.damagedBlocks.remove(breakerId);
        }
    }

    public void func_174979_m() {
        this.displayListEntitiesDirty = true;
    }

    public void resetClouds() {
        this.cloudRenderer.reset();
    }

    class ContainerLocalRenderInformation {
        final RenderChunk field_178036_a;
        final EnumFacing field_178034_b;
        final Set field_178035_c = EnumSet.noneOf(EnumFacing.class);
        final int field_178032_d;

        private ContainerLocalRenderInformation(RenderChunk p_i46248_2_, EnumFacing p_i46248_3_, int p_i46248_4_) {
            this.field_178036_a = p_i46248_2_;
            this.field_178034_b = p_i46248_3_;
            this.field_178032_d = p_i46248_4_;
        }

        ContainerLocalRenderInformation(RenderChunk p_i46249_2_, EnumFacing p_i46249_3_, int p_i46249_4_, Object p_i46249_5_) {
            this(p_i46249_2_, p_i46249_3_, p_i46249_4_);
        }
    }

    static final class SwitchEnumUseage {
        static final int[] field_178037_a = new int[VertexFormatElement.EnumUseage.values().length];

        static {
            try {
                SwitchEnumUseage.field_178037_a[VertexFormatElement.EnumUseage.POSITION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumUseage.field_178037_a[VertexFormatElement.EnumUseage.UV.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumUseage.field_178037_a[VertexFormatElement.EnumUseage.COLOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        SwitchEnumUseage() {
        }
    }
}

