/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.pathfinder.WalkNodeProcessor;

public class PathNavigateGround
extends PathNavigate {
    protected WalkNodeProcessor field_179695_a;
    private boolean field_179694_f;

    public PathNavigateGround(EntityLiving p_i45875_1_, World worldIn) {
        super(p_i45875_1_, worldIn);
    }

    @Override
    protected PathFinder func_179679_a() {
        this.field_179695_a = new WalkNodeProcessor();
        this.field_179695_a.func_176175_a(true);
        return new PathFinder(this.field_179695_a);
    }

    @Override
    protected boolean canNavigate() {
        return this.theEntity.onGround || this.func_179684_h() && this.isInLiquid() || this.theEntity.isRiding() && this.theEntity instanceof EntityZombie && this.theEntity.ridingEntity instanceof EntityChicken;
    }

    @Override
    protected Vec3 getEntityPosition() {
        return new Vec3(this.theEntity.posX, this.func_179687_p(), this.theEntity.posZ);
    }

    private int func_179687_p() {
        if (this.theEntity.isInWater() && this.func_179684_h()) {
            int var1 = (int)this.theEntity.getEntityBoundingBox().minY;
            Block var2 = this.worldObj.getBlockState(new BlockPos(MathHelper.floor_double(this.theEntity.posX), var1, MathHelper.floor_double(this.theEntity.posZ))).getBlock();
            int var3 = 0;
            do {
                if (var2 != Blocks.flowing_water && var2 != Blocks.water) {
                    return var1;
                }
                var2 = this.worldObj.getBlockState(new BlockPos(MathHelper.floor_double(this.theEntity.posX), ++var1, MathHelper.floor_double(this.theEntity.posZ))).getBlock();
            } while (++var3 <= 16);
            return (int)this.theEntity.getEntityBoundingBox().minY;
        }
        return (int)(this.theEntity.getEntityBoundingBox().minY + 0.5);
    }

    @Override
    protected void removeSunnyPath() {
        super.removeSunnyPath();
        if (this.field_179694_f) {
            if (this.worldObj.isAgainstSky(new BlockPos(MathHelper.floor_double(this.theEntity.posX), (int)(this.theEntity.getEntityBoundingBox().minY + 0.5), MathHelper.floor_double(this.theEntity.posZ)))) {
                return;
            }
            int var1 = 0;
            while (var1 < this.currentPath.getCurrentPathLength()) {
                PathPoint var2 = this.currentPath.getPathPointFromIndex(var1);
                if (this.worldObj.isAgainstSky(new BlockPos(var2.xCoord, var2.yCoord, var2.zCoord))) {
                    this.currentPath.setCurrentPathLength(var1 - 1);
                    return;
                }
                ++var1;
            }
        }
    }

    @Override
    protected boolean isDirectPathBetweenPoints(Vec3 p_75493_1_, Vec3 p_75493_2_, int p_75493_3_, int p_75493_4_, int p_75493_5_) {
        int var6 = MathHelper.floor_double(p_75493_1_.xCoord);
        int var7 = MathHelper.floor_double(p_75493_1_.zCoord);
        double var8 = p_75493_2_.xCoord - p_75493_1_.xCoord;
        double var10 = p_75493_2_.zCoord - p_75493_1_.zCoord;
        double var12 = var8 * var8 + var10 * var10;
        if (var12 < 1.0E-8) {
            return false;
        }
        double var14 = 1.0 / Math.sqrt(var12);
        if (!this.func_179683_a(var6, (int)p_75493_1_.yCoord, var7, p_75493_3_ += 2, p_75493_4_, p_75493_5_ += 2, p_75493_1_, var8 *= var14, var10 *= var14)) {
            return false;
        }
        p_75493_3_ -= 2;
        p_75493_5_ -= 2;
        double var16 = 1.0 / Math.abs(var8);
        double var18 = 1.0 / Math.abs(var10);
        double var20 = (double)(var6 * 1) - p_75493_1_.xCoord;
        double var22 = (double)(var7 * 1) - p_75493_1_.zCoord;
        if (var8 >= 0.0) {
            var20 += 1.0;
        }
        if (var10 >= 0.0) {
            var22 += 1.0;
        }
        var20 /= var8;
        var22 /= var10;
        int var24 = var8 < 0.0 ? -1 : 1;
        int var25 = var10 < 0.0 ? -1 : 1;
        int var26 = MathHelper.floor_double(p_75493_2_.xCoord);
        int var27 = MathHelper.floor_double(p_75493_2_.zCoord);
        int var28 = var26 - var6;
        int var29 = var27 - var7;
        do {
            if (var28 * var24 <= 0 && var29 * var25 <= 0) {
                return true;
            }
            if (var20 < var22) {
                var20 += var16;
                var28 = var26 - (var6 += var24);
                continue;
            }
            var22 += var18;
            var29 = var27 - (var7 += var25);
        } while (this.func_179683_a(var6, (int)p_75493_1_.yCoord, var7, p_75493_3_, p_75493_4_, p_75493_5_, p_75493_1_, var8, var10));
        return false;
    }

    private boolean func_179683_a(int p_179683_1_, int p_179683_2_, int p_179683_3_, int p_179683_4_, int p_179683_5_, int p_179683_6_, Vec3 p_179683_7_, double p_179683_8_, double p_179683_10_) {
        int var12 = p_179683_1_ - p_179683_4_ / 2;
        int var13 = p_179683_3_ - p_179683_6_ / 2;
        if (!this.func_179692_b(var12, p_179683_2_, var13, p_179683_4_, p_179683_5_, p_179683_6_, p_179683_7_, p_179683_8_, p_179683_10_)) {
            return false;
        }
        int var14 = var12;
        while (var14 < var12 + p_179683_4_) {
            int var15 = var13;
            while (var15 < var13 + p_179683_6_) {
                double var16 = (double)var14 + 0.5 - p_179683_7_.xCoord;
                double var18 = (double)var15 + 0.5 - p_179683_7_.zCoord;
                if (var16 * p_179683_8_ + var18 * p_179683_10_ >= 0.0) {
                    Block var20 = this.worldObj.getBlockState(new BlockPos(var14, p_179683_2_ - 1, var15)).getBlock();
                    Material var21 = var20.getMaterial();
                    if (var21 == Material.air) {
                        return false;
                    }
                    if (var21 == Material.water && !this.theEntity.isInWater()) {
                        return false;
                    }
                    if (var21 == Material.lava) {
                        return false;
                    }
                }
                ++var15;
            }
            ++var14;
        }
        return true;
    }

    private boolean func_179692_b(int p_179692_1_, int p_179692_2_, int p_179692_3_, int p_179692_4_, int p_179692_5_, int p_179692_6_, Vec3 p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos var13 : BlockPos.getAllInBox(new BlockPos(p_179692_1_, p_179692_2_, p_179692_3_), new BlockPos(p_179692_1_ + p_179692_4_ - 1, p_179692_2_ + p_179692_5_ - 1, p_179692_3_ + p_179692_6_ - 1))) {
            Block var18;
            double var16;
            double var14 = (double)var13.getX() + 0.5 - p_179692_7_.xCoord;
            if (!(var14 * p_179692_8_ + (var16 = (double)var13.getZ() + 0.5 - p_179692_7_.zCoord) * p_179692_10_ >= 0.0) || (var18 = this.worldObj.getBlockState(var13).getBlock()).isPassable(this.worldObj, var13)) continue;
            return false;
        }
        return true;
    }

    public void func_179690_a(boolean p_179690_1_) {
        this.field_179695_a.func_176176_c(p_179690_1_);
    }

    public boolean func_179689_e() {
        return this.field_179695_a.func_176173_e();
    }

    public void func_179688_b(boolean p_179688_1_) {
        this.field_179695_a.func_176172_b(p_179688_1_);
    }

    public void func_179691_c(boolean p_179691_1_) {
        this.field_179695_a.func_176175_a(p_179691_1_);
    }

    public boolean func_179686_g() {
        return this.field_179695_a.func_176179_b();
    }

    public void func_179693_d(boolean p_179693_1_) {
        this.field_179695_a.func_176178_d(p_179693_1_);
    }

    public boolean func_179684_h() {
        return this.field_179695_a.func_176174_d();
    }

    public void func_179685_e(boolean p_179685_1_) {
        this.field_179694_f = p_179685_1_;
    }
}

