/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiVideoSettings;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;

public class GuiDetailSettingsOF
extends GuiScreen {
    private GuiScreen prevScreen;
    protected String title = "Detail Settings";
    private GameSettings settings;
    private static GameSettings.Options[] enumOptions = new GameSettings.Options[]{GameSettings.Options.CLOUDS, GameSettings.Options.CLOUD_HEIGHT, GameSettings.Options.TREES, GameSettings.Options.RAIN, GameSettings.Options.SKY, GameSettings.Options.STARS, GameSettings.Options.SUN_MOON, GameSettings.Options.SHOW_CAPES, GameSettings.Options.TRANSLUCENT_BLOCKS, GameSettings.Options.HELD_ITEM_TOOLTIPS, GameSettings.Options.DROPPED_ITEMS};
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private long mouseStillTime = 0L;

    public GuiDetailSettingsOF(GuiScreen guiscreen, GameSettings gamesettings) {
        this.prevScreen = guiscreen;
        this.settings = gamesettings;
    }

    @Override
    public void initGui() {
        int i = 0;
        GameSettings.Options[] aenumoptions = enumOptions;
        int j = aenumoptions.length;
        int k = 0;
        while (k < j) {
            GameSettings.Options enumoptions = aenumoptions[k];
            int x = this.width / 2 - 155 + i % 2 * 160;
            int y = this.height / 6 + 21 * (i / 2) - 10;
            if (!enumoptions.getEnumFloat()) {
                this.buttonList.add(new GuiOptionButton(enumoptions.returnEnumOrdinal(), x, y, enumoptions, this.settings.getKeyBinding(enumoptions)));
            } else {
                this.buttonList.add(new GuiOptionSlider(enumoptions.returnEnumOrdinal(), x, y, enumoptions));
            }
            ++i;
            ++k;
        }
        this.buttonList.add(new GuiButton(200, this.width / 2 - 100, this.height / 6 + 168 + 11, I18n.format("gui.done", new Object[0])));
    }

    @Override
    protected void actionPerformed(GuiButton guibutton) {
        if (guibutton.enabled) {
            if (guibutton.id < 200 && guibutton instanceof GuiOptionButton) {
                this.settings.setOptionValue(((GuiOptionButton)guibutton).returnEnumOptions(), 1);
                guibutton.displayString = this.settings.getKeyBinding(GameSettings.Options.getEnumOptions(guibutton.id));
            }
            if (guibutton.id == 200) {
                this.mc.gameSettings.saveOptions();
                this.mc.displayGuiScreen(this.prevScreen);
            }
            if (guibutton.id != GameSettings.Options.CLOUD_HEIGHT.ordinal()) {
                ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.displayWidth, this.mc.displayHeight);
                int i = scaledresolution.getScaledWidth();
                int j = scaledresolution.getScaledHeight();
                this.setWorldAndResolution(this.mc, i, j);
            }
        }
    }

    @Override
    public void drawScreen(int x, int y, float f) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(x, y, f);
        if (Math.abs(x - this.lastMouseX) <= 5 && Math.abs(y - this.lastMouseY) <= 5) {
            int activateDelay = 700;
            if (System.currentTimeMillis() >= this.mouseStillTime + (long)activateDelay) {
                int x1 = this.width / 2 - 150;
                int y1 = this.height / 6 - 5;
                if (y <= y1 + 98) {
                    y1 += 105;
                }
                int x2 = x1 + 150 + 150;
                int y2 = y1 + 84 + 10;
                GuiButton btn = this.getSelectedButton(x, y);
                if (btn != null) {
                    String s = this.getButtonName(btn.displayString);
                    String[] lines = this.getTooltipLines(s);
                    if (lines == null) {
                        return;
                    }
                    this.drawGradientRect(x1, y1, x2, y2, -536870912, -536870912);
                    int i = 0;
                    while (i < lines.length) {
                        String line = lines[i];
                        this.fontRendererObj.func_175063_a(line, x1 + 5, y1 + 5 + i * 11, 0xDDDDDD);
                        ++i;
                    }
                }
            }
        } else {
            this.lastMouseX = x;
            this.lastMouseY = y;
            this.mouseStillTime = System.currentTimeMillis();
        }
    }

    private String[] getTooltipLines(String btnName) {
        String[] stringArray;
        if (btnName.equals("Clouds")) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "Clouds";
            stringArray2[1] = "  Default - as set by setting Graphics";
            stringArray2[2] = "  Fast - lower quality, faster";
            stringArray2[3] = "  Fancy - higher quality, slower";
            stringArray2[4] = "  OFF - no clouds, fastest";
            stringArray2[5] = "Fast clouds are rendered 2D.";
            stringArray = stringArray2;
            stringArray2[6] = "Fancy clouds are rendered 3D.";
        } else if (btnName.equals("Cloud Height")) {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "Cloud Height";
            stringArray3[1] = "  OFF - default height";
            stringArray = stringArray3;
            stringArray3[2] = "  100% - above world height limit";
        } else if (btnName.equals("Trees")) {
            String[] stringArray4 = new String[6];
            stringArray4[0] = "Trees";
            stringArray4[1] = "  Default - as set by setting Graphics";
            stringArray4[2] = "  Fast - lower quality, faster";
            stringArray4[3] = "  Fancy - higher quality, slower";
            stringArray4[4] = "Fast trees have opaque leaves.";
            stringArray = stringArray4;
            stringArray4[5] = "Fancy trees have transparent leaves.";
        } else if (btnName.equals("Grass")) {
            String[] stringArray5 = new String[6];
            stringArray5[0] = "Grass";
            stringArray5[1] = "  Default - as set by setting Graphics";
            stringArray5[2] = "  Fast - lower quality, faster";
            stringArray5[3] = "  Fancy - higher quality, slower";
            stringArray5[4] = "Fast grass uses default side texture.";
            stringArray = stringArray5;
            stringArray5[5] = "Fancy grass uses biome side texture.";
        } else if (btnName.equals("Dropped Items")) {
            String[] stringArray6 = new String[4];
            stringArray6[0] = "Dropped Items";
            stringArray6[1] = "  Default - as set by setting Graphics";
            stringArray6[2] = "  Fast - 2D dropped items, faster";
            stringArray = stringArray6;
            stringArray6[3] = "  Fancy - 3D dropped items, slower";
        } else if (btnName.equals("Water")) {
            String[] stringArray7 = new String[6];
            stringArray7[0] = "Water";
            stringArray7[1] = "  Default - as set by setting Graphics";
            stringArray7[2] = "  Fast  - lower quality, faster";
            stringArray7[3] = "  Fancy - higher quality, slower";
            stringArray7[4] = "Fast water (1 pass) has some visual artifacts";
            stringArray = stringArray7;
            stringArray7[5] = "Fancy water (2 pass) has no visual artifacts";
        } else if (btnName.equals("Rain & Snow")) {
            String[] stringArray8 = new String[7];
            stringArray8[0] = "Rain & Snow";
            stringArray8[1] = "  Default - as set by setting Graphics";
            stringArray8[2] = "  Fast  - light rain/snow, faster";
            stringArray8[3] = "  Fancy - heavy rain/snow, slower";
            stringArray8[4] = "  OFF - no rain/snow, fastest";
            stringArray8[5] = "When rain is OFF the splashes and rain sounds";
            stringArray = stringArray8;
            stringArray8[6] = "are still active.";
        } else if (btnName.equals("Sky")) {
            String[] stringArray9 = new String[4];
            stringArray9[0] = "Sky";
            stringArray9[1] = "  ON - sky is visible, slower";
            stringArray9[2] = "  OFF  - sky is not visible, faster";
            stringArray = stringArray9;
            stringArray9[3] = "When sky is OFF the moon and sun are still visible.";
        } else if (btnName.equals("Sun & Moon")) {
            String[] stringArray10 = new String[3];
            stringArray10[0] = "Sun & Moon";
            stringArray10[1] = "  ON - sun and moon are visible (default)";
            stringArray = stringArray10;
            stringArray10[2] = "  OFF  - sun and moon are not visible (faster)";
        } else if (btnName.equals("Stars")) {
            String[] stringArray11 = new String[3];
            stringArray11[0] = "Stars";
            stringArray11[1] = "  ON - stars are visible, slower";
            stringArray = stringArray11;
            stringArray11[2] = "  OFF  - stars are not visible, faster";
        } else if (btnName.equals("Depth Fog")) {
            String[] stringArray12 = new String[3];
            stringArray12[0] = "Depth Fog";
            stringArray12[1] = "  ON - fog moves closer at bedrock levels (default)";
            stringArray = stringArray12;
            stringArray12[2] = "  OFF - same fog at all levels";
        } else if (btnName.equals("Show Capes")) {
            String[] stringArray13 = new String[3];
            stringArray13[0] = "Show Capes";
            stringArray13[1] = "  ON - show player capes (default)";
            stringArray = stringArray13;
            stringArray13[2] = "  OFF - do not show player capes";
        } else if (btnName.equals("Held Item Tooltips")) {
            String[] stringArray14 = new String[3];
            stringArray14[0] = "Held item tooltips";
            stringArray14[1] = "  ON - show tooltips for held items (default)";
            stringArray = stringArray14;
            stringArray14[2] = "  OFF - do not show tooltips for held items";
        } else if (btnName.equals("Translucent Blocks")) {
            String[] stringArray15 = new String[6];
            stringArray15[0] = "Translucent Blocks";
            stringArray15[1] = "  Fancy - correct color blending (default)";
            stringArray15[2] = "  Fast - fast color blending (faster)";
            stringArray15[3] = "Controls the color blending of translucent blocks";
            stringArray15[4] = "with different color (stained glass, water, ice)";
            stringArray = stringArray15;
            stringArray15[5] = "when placed behind each other with air between them.";
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private String getButtonName(String displayString) {
        int pos = displayString.indexOf(58);
        return pos < 0 ? displayString : displayString.substring(0, pos);
    }

    private GuiButton getSelectedButton(int i, int j) {
        int k = 0;
        while (k < this.buttonList.size()) {
            boolean flag;
            GuiButton btn = (GuiButton)this.buttonList.get(k);
            int btnWidth = GuiVideoSettings.getButtonWidth(btn);
            int btnHeight = GuiVideoSettings.getButtonHeight(btn);
            boolean bl = flag = i >= btn.xPosition && j >= btn.yPosition && i < btn.xPosition + btnWidth && j < btn.yPosition + btnHeight;
            if (flag) {
                return btn;
            }
            ++k;
        }
        return null;
    }
}

