/*
 * Decompiled with CFR 0.152.
 */
package com.bit.module.all;

import com.bit.module.Category;
import com.bit.module.Module;
import com.bit.module.ModuleManager;
import com.bit.module.util.CombatUtil;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.utility.Render;
import com.bit.utility.Util;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;

public class Tracer
extends Module {
    public Tracer(String finder, Category category, String name, String description, String warning) {
        super(finder, category, name, description, warning);
        this.addOption("Keybind", String.valueOf(name) + "'s keybind", Interactable.TYPE.KEYBINDER, 0, null, false);
        this.addOption("Animals", "Show animals", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getDistanceColorOptions());
        this.addOption("Monsters", "Show monsters", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getDistanceColorOptions());
        this.addOption("Neutrals", "Show neutral mobs", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getDistanceColorOptions());
        this.addOption("Players", "Show players", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getDistanceColorOptions());
    }

    @Override
    public void render3D() {
        if (!this.active) {
            return;
        }
        boolean animals = Util.makeBoolean(this.getOptionValue("animals"));
        boolean monsters = Util.makeBoolean(this.getOptionValue("monsters"));
        boolean neutrals = Util.makeBoolean(this.getOptionValue("neutrals"));
        boolean players = Util.makeBoolean(this.getOptionValue("players"));
        int i = 0;
        while (i < this.mc.theWorld.loadedEntityList.size()) {
            EntityLivingBase e;
            Entity ent = (Entity)this.mc.theWorld.loadedEntityList.get(i);
            if (ent instanceof EntityLivingBase && !CombatUtil.isDisabledEntity(e = (EntityLivingBase)ent)) {
                boolean dist;
                float min = 1.0f;
                float max = 20.0f;
                float distTo = Math.min(Math.max(min, this.mc.thePlayer.getDistanceToEntity(e)), max);
                int close = -43691;
                int far = -11141291;
                Color c = new Color(-1);
                try {
                    c = new Color(Util.blendColor(far, close, (distTo - min) / (max - min)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                int r = c.getRed();
                int g = c.getGreen();
                int b = c.getBlue();
                int a = c.getAlpha();
                if (e instanceof EntityAnimal) {
                    if (animals) {
                        dist = Util.makeBoolean(this.getSubOptionValue("animals", "distance"));
                        if (!dist) {
                            r = Util.makeInteger(this.getSubOptionValue("animals", "red"));
                            g = Util.makeInteger(this.getSubOptionValue("animals", "green"));
                            b = Util.makeInteger(this.getSubOptionValue("animals", "blue"));
                        }
                        a = Util.makeInteger(this.getSubOptionValue("animals", "opacity"));
                        Render.tracer(this.mc.thePlayer, e, new Color(r, g, b, a).getRGB());
                    }
                } else if (e instanceof EntityMob || e instanceof EntityFlying || e instanceof EntitySlime) {
                    if (monsters) {
                        dist = Util.makeBoolean(this.getSubOptionValue("monsters", "distance"));
                        if (!dist) {
                            r = Util.makeInteger(this.getSubOptionValue("monsters", "red"));
                            g = Util.makeInteger(this.getSubOptionValue("monsters", "green"));
                            b = Util.makeInteger(this.getSubOptionValue("monsters", "blue"));
                        }
                        a = Util.makeInteger(this.getSubOptionValue("monsters", "opacity"));
                        Render.tracer(this.mc.thePlayer, e, new Color(r, g, b, a).getRGB());
                    }
                } else if (e instanceof EntityAmbientCreature || e instanceof EntityWaterMob || e instanceof EntityVillager) {
                    if (neutrals) {
                        dist = Util.makeBoolean(this.getSubOptionValue("neutrals", "distance"));
                        if (!dist) {
                            r = Util.makeInteger(this.getSubOptionValue("neutrals", "red"));
                            g = Util.makeInteger(this.getSubOptionValue("neutrals", "green"));
                            b = Util.makeInteger(this.getSubOptionValue("neutrals", "blue"));
                        }
                        a = Util.makeInteger(this.getSubOptionValue("neutrals", "opacity"));
                        Render.tracer(this.mc.thePlayer, e, new Color(r, g, b, a).getRGB());
                    }
                } else if (e instanceof EntityPlayer && players) {
                    dist = Util.makeBoolean(this.getSubOptionValue("players", "distance"));
                    if (!dist) {
                        r = Util.makeInteger(this.getSubOptionValue("players", "red"));
                        g = Util.makeInteger(this.getSubOptionValue("players", "green"));
                        b = Util.makeInteger(this.getSubOptionValue("players", "blue"));
                    }
                    a = Util.makeInteger(this.getSubOptionValue("players", "opacity"));
                    Render.tracer(this.mc.thePlayer, e, new Color(r, g, b, a).getRGB());
                }
            }
            ++i;
        }
    }
}

