/*
 * Decompiled with CFR 0.152.
 */
package com.bit.module.all;

import com.bit.module.Category;
import com.bit.module.Module;
import com.bit.module.ModuleManager;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.utility.Render;
import com.bit.utility.RenderUtil;
import com.bit.utility.Util;
import java.awt.Color;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class Trajectories
extends Module {
    private final int[] id = new int[]{261, 344, 368, 384, 346, 373, 332};
    private final float[] drag = new float[]{0.99f, 0.99f, 0.99f, 0.99f, 0.92f, 0.99f, 0.99f};
    private final float[] dragWater = new float[]{0.6f, 0.8f, 0.8f, 0.8f, 0.0f, 0.5f, 0.8f};
    private final float[] grav = new float[]{0.05f, 0.03f, 0.03f, 0.07f, 0.04f, 0.05f, 0.03f};
    private final float[] pitchOffset = new float[]{0.0f, 0.0f, 0.0f, -20.0f, 0.0f, -20.0f, 0.0f};
    private final float[] motionMult = new float[]{1.0f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f, 0.4f};
    private final float[] multiplier = new float[]{1.5f, 1.5f, 1.5f, 0.7f, 1.5f, 0.5f, 1.5f};
    private final String[] name = new String[]{"bow", "egg", "ender pearl", "exp bottle", "fishing rod", "potion", "snowball"};
    private final Class[] classes = new Class[]{EntityArrow.class, EntityEgg.class, EntityEnderPearl.class, EntityExpBottle.class, EntityFishHook.class, EntityPotion.class, EntitySnowball.class};

    public Trajectories(String finder, Category category, String name, String description, String warning) {
        super(finder, category, name, description, warning);
        this.addOption("Keybind", String.valueOf(name) + "'s keybind", Interactable.TYPE.KEYBINDER, 0, null, false);
        this.addOption("Prediction", "Show a held item trajectory prediction line", Interactable.TYPE.CHECKBOX, false, null, false);
        this.addOption("Projectiles", "Show in flight projectile trajectory prediction lines", Interactable.TYPE.CHECKBOX, false, null, false);
        this.addOption("Arrow Criticals", "Show all critical arrow trajectory prediction lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Other Players", "Show other players' held item trajectory prediction lines", Interactable.TYPE.CHECKBOX, false, null, false);
        this.addOption("Bow", "Show bow and arrow trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Egg", "Show egg trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Ender Pearl", "Show ender pearl trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Exp Bottle", "Show exp bottle trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Fishing Rod", "Show fishing rod trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Potion", "Show splash potion trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
        this.addOption("Snowball", "Show snowball trajectory lines", Interactable.TYPE.CHECKBOX, false, null, false, ModuleManager.getColorOptions());
    }

    @Override
    public void render3D() {
        if (!this.active) {
            return;
        }
        boolean prediction = Util.makeBoolean(this.getOptionValue("prediction"));
        boolean projectiles = Util.makeBoolean(this.getOptionValue("projectiles"));
        if (prediction) {
            this.predictionLine();
        }
        if (projectiles) {
            this.projectileLine();
        }
    }

    public void predictionLine() {
        EntityPlayerSP e = this.mc.thePlayer;
        ItemStack held = e.getCurrentEquippedItem();
        if (held == null) {
            return;
        }
        int i = Item.getIdFromItem(held.getItem());
        int index = -1;
        int a = 0;
        while (a < this.id.length) {
            if (this.id[a] == i) {
                index = a;
                break;
            }
            ++a;
        }
        if (index == -1) {
            return;
        }
        boolean on = Util.makeBoolean(this.getOptionValue(this.name[index]));
        if (!on) {
            return;
        }
        String colorOption = this.name[index];
        float arrowPow = 0.0f;
        if (held.getItem() instanceof ItemBow) {
            float pull = this.mc.thePlayer.getItemInUseCount();
            float var7 = (float)((int)((float)held.getMaxItemUseDuration() - pull)) / 20.0f;
            pull = var7 = (var7 * var7 + var7 * 2.0f) / 3.0f;
            if (pull >= 1.0f && this.mc.thePlayer.getItemInUseCount() > 0) {
                if (Util.makeBoolean(this.getOptionValue("arrow criticals"))) {
                    colorOption = "arrow criticals";
                }
                pull = 1.0f;
            }
            arrowPow = pull;
        }
        if (arrowPow == 0.0f) {
            arrowPow = 0.5f;
        }
        arrowPow = MathHelper.clamp_float(arrowPow, 0.0f, 1.0f);
        int r = Util.makeInteger(this.getSubOptionValue(colorOption, "red"));
        int g = Util.makeInteger(this.getSubOptionValue(colorOption, "green"));
        int b = Util.makeInteger(this.getSubOptionValue(colorOption, "blue"));
        int a2 = Util.makeInteger(this.getSubOptionValue(colorOption, "opacity"));
        int color = new Color(r, g, b, a2).getRGB();
        double[] pos = RenderUtil.entityWorldPos(e);
        double x = pos[0] - (double)(MathHelper.cos(this.mc.thePlayer.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        double y = pos[1] + (double)this.mc.thePlayer.getEyeHeight() - (double)0.1f;
        double z = pos[2] - (double)(MathHelper.sin(this.mc.thePlayer.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        double mx = -MathHelper.sin(this.mc.thePlayer.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.mc.thePlayer.rotationPitch / 180.0f * (float)Math.PI) * this.motionMult[index];
        double my = -MathHelper.sin((this.mc.thePlayer.rotationPitch + this.pitchOffset[index]) / 180.0f * (float)Math.PI) * this.motionMult[index];
        double mz = MathHelper.cos(this.mc.thePlayer.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.mc.thePlayer.rotationPitch / 180.0f * (float)Math.PI) * this.motionMult[index];
        float var9 = MathHelper.sqrt_double(mx * mx + my * my + mz * mz);
        mx /= (double)var9;
        my /= (double)var9;
        mz /= (double)var9;
        Render.renderTrail(x, y, z, mx *= (double)(this.multiplier[index] * (2.0f * arrowPow)), my *= (double)(this.multiplier[index] * (2.0f * arrowPow)), mz *= (double)(this.multiplier[index] * (2.0f * arrowPow)), this.drag[index], this.dragWater[index], this.grav[index], color, true);
    }

    public void projectileLine() {
        int i = 0;
        while (i < this.mc.theWorld.loadedEntityList.size()) {
            Entity e = (Entity)this.mc.theWorld.loadedEntityList.get(i);
            double x = e.posX;
            double y = e.posY;
            double z = e.posZ;
            double mx = e.motionX;
            double my = e.motionY;
            double mz = e.motionZ;
            int index = -1;
            int a = 0;
            while (a < this.classes.length) {
                if (this.classes[a].isInstance(e)) {
                    index = a;
                    break;
                }
                ++a;
            }
            if (index != -1) {
                String colorOption = this.name[index];
                if (e instanceof EntityArrow && ((EntityArrow)e).getIsCritical()) {
                    colorOption = "Arrow Criticals";
                }
                int r = Util.makeInteger(this.getSubOptionValue(colorOption, "red"));
                int g = Util.makeInteger(this.getSubOptionValue(colorOption, "green"));
                int b = Util.makeInteger(this.getSubOptionValue(colorOption, "blue"));
                int a2 = Util.makeInteger(this.getSubOptionValue(colorOption, "opacity"));
                int color = new Color(r, g, b, a2).getRGB();
                Render.renderTrail(x, y, z, mx, my, mz, this.drag[index], this.dragWater[index], this.grav[index], color, false);
            }
            ++i;
        }
    }
}

