/*
 * Decompiled with CFR 0.152.
 */
package com.bit.render;

import com.bit.Settings;
import com.bit.render.GuiGrabber;
import com.bit.render.ResourceManager;
import com.bit.render.Tooltip;
import com.bit.toolbar.Button;
import com.bit.toolbar.Component;
import com.bit.toolbar.Separator;
import com.bit.toolbar.dropdown.WindowModule;
import com.bit.toolbar.dropdown.WindowOptions;
import com.bit.toolbar.dropdown.WindowSubOptions;
import com.bit.utility.Draw;
import com.bit.utility.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.Display;

public class Gui {
    private final Minecraft mc;
    private static final float transitionSpeedBase = 2.0f;
    public List<Component> toolbarComponents = new ArrayList<Component>();
    public WindowModule window;
    public WindowOptions options;
    public WindowSubOptions subOptions;
    public Tooltip tooltip;
    public static float transitionSpeed = 2.0f;
    private float transparency;

    public Gui() {
        this.mc = Minecraft.getMinecraft();
        int i = 0;
        float x = Display.getWidth() / 2 - this.toolbarComponents.size() * 32;
        float y = 0.0f;
        this.toolbarComponents.add(new Separator(-1, ResourceManager.separator, x, y, 64.0f, 64.0f));
        x += 64.0f;
        i = 0;
        while (i < ResourceManager.hackIcons.length) {
            this.toolbarComponents.add(new Button(i, ResourceManager.hackIcons[i], x, y, 64.0f, 64.0f));
            x += 64.0f;
            ++i;
        }
        this.toolbarComponents.add(new Separator(-1, ResourceManager.separator, x, y, 64.0f, 64.0f));
        this.window = new WindowModule(null);
        this.options = new WindowOptions(this.window);
        this.subOptions = new WindowSubOptions(this.options);
        this.tooltip = new Tooltip();
    }

    public void update(int mouseX, int mouseY) {
        transitionSpeed = 2.0f;
        boolean i = false;
        float x = Display.getWidth() / 2 - this.toolbarComponents.size() * 32;
        float y = 0.0f;
        this.window.active = false;
        for (Component component : this.toolbarComponents) {
            component.update(mouseX, mouseY);
            component.translate(x, y);
            x += 64.0f;
        }
        this.tooltip.update(mouseX, mouseY);
        this.window.update(mouseX, mouseY);
        this.options.update(mouseX, mouseY);
        this.subOptions.update(mouseX, mouseY);
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        for (Component component : this.toolbarComponents) {
            component.mouseClicked(mouseX, mouseY, button);
        }
        this.window.mouseClicked(mouseX, mouseY, button);
        this.options.mouseClicked(mouseX, mouseY, button);
        this.subOptions.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
        for (Component component : this.toolbarComponents) {
            component.mouseReleased(mouseX, mouseY, button);
        }
        this.window.mouseReleased(mouseX, mouseY, button);
        this.options.mouseReleased(mouseX, mouseY, button);
        this.subOptions.mouseReleased(mouseX, mouseY, button);
    }

    public void keyboardPressed(int key) {
        this.window.keyboardPressed(key);
        this.options.keyboardPressed(key);
        this.subOptions.keyboardPressed(key);
        if (key == 1) {
            this.options.active = false;
            this.subOptions.active = false;
            this.mc.displayGuiScreen(null);
        }
    }

    public void keyboardReleased(int key) {
        this.window.keyboardReleased(key);
        this.options.keyboardReleased(key);
        this.subOptions.keyboardReleased(key);
    }

    public void render() {
        if (!this.mc.gameSettings.showDebugInfo) {
            Draw.activeMods();
        }
        this.transparency = !(this.mc.currentScreen instanceof GuiGrabber) ? (this.transparency += (0.0f - this.transparency) / 2.0f) : (this.transparency += (1.0f - this.transparency) / 2.0f);
        if ((double)this.transparency < 0.01) {
            return;
        }
        Draw.rect(0.0f, 0.0f, Display.getWidth(), Display.getHeight(), Util.colorAlpha(-1, this.transparency / 4.0f));
        Draw.rect(0.0f, 0.0f, Display.getWidth(), 64.0f, Util.colorAlpha(Settings.theme_bit_toolbar_fill, this.transparency * 0.6f));
        this.window.render(this.transparency);
        this.options.render(this.transparency);
        this.subOptions.render(this.transparency);
        for (Component component : this.toolbarComponents) {
            component.render(this.transparency);
        }
        this.tooltip.render(this.transparency);
    }
}

