/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar.dropdown;

import com.bit.Bit;
import com.bit.render.Gui;
import com.bit.toolbar.Positionable;
import com.bit.toolbar.dropdown.Window;

public abstract class Interactable
extends Positionable {
    public Window parent;
    public int id;
    public String help;
    public boolean enabled;
    public boolean active;
    public boolean hover;
    public TYPE type;
    public float hoverFade;
    public float activeFade;

    public Interactable(Window parent, TYPE type, int id, String help, float x, float y, float width, float height, float offsetX, float offsetY) {
        this.parent = parent;
        this.type = type;
        this.id = id;
        this.help = help;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.enabled = true;
    }

    public void update(int mouseX, int mouseY) {
        if (this.parent.active && this.parent.enabled && this.parent.boxFade > 0.1f) {
            this.hover = this.mouseOver(mouseX, mouseY);
            if (this.hover) {
                Bit.bit().gui.tooltip.text = this.help;
                this.hoverFade += (1.0f - this.hoverFade) / Gui.transitionSpeed;
            } else {
                this.hoverFade += (0.0f - this.hoverFade) / Gui.transitionSpeed;
            }
            this.activeFade += ((float)(this.active ? 1 : 0) - this.activeFade) / Gui.transitionSpeed;
        }
    }

    public void translate(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public boolean mouseOver(int mouseX, int mouseY) {
        return this.enabled && (float)mouseX > this.x && (float)mouseX < this.x + this.width && (float)mouseY > this.y && (float)mouseY < this.y + this.height;
    }

    public abstract void mouseClicked(int var1, int var2, int var3);

    public abstract void mouseReleased(int var1, int var2, int var3);

    public abstract void render(float var1);

    public static enum TYPE {
        BUTTON,
        CHECKBOX,
        SLIDER,
        KEYBINDER;

    }
}

