/*
 * Decompiled with CFR 0.152.
 */
package com.bit.toolbar.dropdown;

import com.bit.Settings;
import com.bit.render.Align;
import com.bit.toolbar.dropdown.Interactable;
import com.bit.toolbar.dropdown.Window;
import com.bit.utility.Draw;
import com.bit.utility.Util;

public class Slider
extends Interactable {
    public String text;
    public String alt;
    public float value;
    public float animValue;
    public boolean setting;

    public Slider(Window parent, Interactable.TYPE type, String text, int id, String help, float offsetX, float offsetY, float width, float height) {
        super(parent, type, id, help, parent.x, parent.y, width, height, offsetX, offsetY);
        this.text = text;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (this.mouseOver(mouseX, mouseY)) {
            this.parent.action(this, mouseX, mouseY, button);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int button) {
        this.setting = false;
    }

    @Override
    public void render(float fade) {
        this.active = this.setting;
        Draw.rect(this.x, this.y, this.x + this.width, this.y + this.height, Util.colorAlpha(Settings.theme_bit_dropdown_interactable_hover, fade / 5.0f * this.hoverFade));
        float padding = 1.0f;
        this.animValue += (this.value - this.animValue) / 2.0f;
        Draw.rect(this.x, this.y + padding, this.x + this.animValue, this.y + this.height - padding, Util.colorAlpha(Settings.theme_bit_dropdown_interactable_hover, fade / 3.0f));
        if (fade > 0.01f) {
            Draw.string(Settings.font_bit_dropdown_content, this.x + (this.height - (float)Settings.font_bit_dropdown_content.getHeight(this.text)), this.y + this.height / 2.0f, this.text, Util.colorAlpha(Settings.theme_bit_dropdown_content, fade), Align.LEFT, Align.CENTER);
            Draw.string(Settings.font_bit_dropdown_content, this.x + this.width - (this.height - (float)Settings.font_bit_dropdown_content.getHeight(this.alt)), this.y + this.height / 2.0f, this.alt, Util.colorAlpha(Settings.theme_bit_dropdown_content, fade), Align.RIGHT, Align.CENTER);
        }
    }
}

