/*
 * Decompiled with CFR 0.152.
 */
package com.bit.utility;

import com.bit.Bit;
import com.bit.module.Module;
import com.bit.module.ModuleManager;
import com.bit.module.ModuleOption;
import com.bit.module.ModuleSubOption;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Config {
    private static final File directory = new File("./" + Bit.bit().NAME + "/");
    private static final File modules = new File(directory + "/modules.properties");
    private static final File settings = new File(directory + "/settings.properties");

    public static void saveFiles() {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        Config.saveModules();
        Config.saveSettings();
    }

    public static void loadFiles() {
        if (!directory.exists()) {
            Config.saveFiles();
            return;
        }
        Config.loadModules();
        Config.loadSettings();
    }

    public static void saveModules() {
        if (!modules.exists()) {
            try {
                modules.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JSONObject obj = new JSONObject();
        JSONArray moduleList = new JSONArray();
        for (Module m : ModuleManager.list()) {
            JSONObject module = new JSONObject();
            module.put("name", m.finder);
            module.put("active", m.active);
            JSONArray options = new JSONArray();
            for (ModuleOption mo : m.options) {
                JSONObject option = new JSONObject();
                option.put("name", mo.name);
                option.put("value", mo.value);
                if (mo.subOptions == null) {
                    options.add(option);
                    continue;
                }
                JSONArray subOptions = new JSONArray();
                for (ModuleSubOption mso : mo.subOptions) {
                    JSONObject subOption = new JSONObject();
                    subOption.put("name", mso.name);
                    subOption.put("value", mso.value);
                    subOptions.add(subOption);
                }
                option.put("options", subOptions);
                options.add(option);
            }
            module.put("options", options);
            moduleList.add(module);
        }
        obj.put("modules", moduleList);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(obj.toJSONString());
        String pretty = gson.toJson(je);
        try {
            modules.delete();
            modules.createNewFile();
            FileWriter file = new FileWriter(modules.getAbsolutePath());
            file.write(pretty);
            file.flush();
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadModules() {
        JSONParser parser = new JSONParser();
        try {
            Object file = parser.parse(new FileReader(modules.getAbsolutePath()));
            JSONObject obj = (JSONObject)file;
            JSONArray moduleList = (JSONArray)obj.get("modules");
            for (JSONObject module : moduleList) {
                String name = (String)module.get("name");
                boolean active = (Boolean)module.get("active");
                Module m = ModuleManager.get(name);
                if (!ModuleManager.isBlackListed(m)) {
                    m.active = active;
                    if (active) {
                        ModuleManager.enable(m);
                    } else {
                        ModuleManager.disable(m);
                    }
                }
                JSONArray options = (JSONArray)module.get("options");
                for (JSONObject option : options) {
                    String oName = (String)option.get("name");
                    Object oValue = option.get("value");
                    ModuleOption mO = m.options.get(m.getOption(oName));
                    mO.value = oValue;
                    JSONArray subOptions = (JSONArray)option.get("options");
                    if (subOptions == null) continue;
                    for (JSONObject subOption : subOptions) {
                        String soName = (String)subOption.get("name");
                        Object soValue = subOption.get("value");
                        ModuleSubOption mSO = mO.subOptions.get(m.getSubOption(oName, soName));
                        mSO.value = soValue;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Config.saveModules();
        }
    }

    public static void saveSettings() {
    }

    public static void loadSettings() {
    }
}

