/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.PlayerSelector;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CommandSpreadPlayers
extends CommandBase {
    @Override
    public String getCommandName() {
        return "spreadplayers";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.spreadplayers.usage";
    }

    @Override
    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 6) {
            throw new WrongUsageException("commands.spreadplayers.usage", new Object[0]);
        }
        int var3 = 0;
        BlockPos var4 = sender.getPosition();
        double var10000 = var4.getX();
        int var17 = var3 + 1;
        double var5 = CommandSpreadPlayers.func_175761_b(var10000, args[var3], true);
        double var7 = CommandSpreadPlayers.func_175761_b(var4.getZ(), args[var17++], true);
        double var9 = CommandSpreadPlayers.parseDouble(args[var17++], 0.0);
        double var11 = CommandSpreadPlayers.parseDouble(args[var17++], var9 + 1.0);
        boolean var13 = CommandSpreadPlayers.parseBoolean(args[var17++]);
        ArrayList var14 = Lists.newArrayList();
        while (var17 < args.length) {
            String var15;
            if (PlayerSelector.hasArguments(var15 = args[var17++])) {
                List var16 = PlayerSelector.func_179656_b(sender, var15, Entity.class);
                if (var16.size() == 0) {
                    throw new EntityNotFoundException();
                }
                var14.addAll(var16);
                continue;
            }
            EntityPlayerMP var18 = MinecraftServer.getServer().getConfigurationManager().getPlayerByUsername(var15);
            if (var18 == null) {
                throw new PlayerNotFoundException();
            }
            var14.add(var18);
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_ENTITIES, var14.size());
        if (var14.isEmpty()) {
            throw new EntityNotFoundException();
        }
        sender.addChatMessage(new ChatComponentTranslation("commands.spreadplayers.spreading." + (var13 ? "teams" : "players"), var14.size(), var11, var5, var7, var9));
        this.func_110669_a(sender, var14, new Position(var5, var7), var9, var11, ((Entity)var14.get((int)0)).worldObj, var13);
    }

    private void func_110669_a(ICommandSender p_110669_1_, List p_110669_2_, Position p_110669_3_, double p_110669_4_, double p_110669_6_, World worldIn, boolean p_110669_9_) throws CommandException {
        Random var10 = new Random();
        double var11 = p_110669_3_.field_111101_a - p_110669_6_;
        double var13 = p_110669_3_.field_111100_b - p_110669_6_;
        double var15 = p_110669_3_.field_111101_a + p_110669_6_;
        double var17 = p_110669_3_.field_111100_b + p_110669_6_;
        Position[] var19 = this.func_110670_a(var10, p_110669_9_ ? this.func_110667_a(p_110669_2_) : p_110669_2_.size(), var11, var13, var15, var17);
        int var20 = this.func_110668_a(p_110669_3_, p_110669_4_, worldIn, var10, var11, var13, var15, var17, var19, p_110669_9_);
        double var21 = this.func_110671_a(p_110669_2_, worldIn, var19, p_110669_9_);
        CommandSpreadPlayers.notifyOperators(p_110669_1_, (ICommand)this, "commands.spreadplayers.success." + (p_110669_9_ ? "teams" : "players"), var19.length, p_110669_3_.field_111101_a, p_110669_3_.field_111100_b);
        if (var19.length > 1) {
            p_110669_1_.addChatMessage(new ChatComponentTranslation("commands.spreadplayers.info." + (p_110669_9_ ? "teams" : "players"), String.format("%.2f", var21), var20));
        }
    }

    private int func_110667_a(List p_110667_1_) {
        HashSet var2 = Sets.newHashSet();
        for (Entity var4 : p_110667_1_) {
            if (var4 instanceof EntityPlayer) {
                var2.add(((EntityPlayer)var4).getTeam());
                continue;
            }
            var2.add(null);
        }
        return var2.size();
    }

    private int func_110668_a(Position p_110668_1_, double p_110668_2_, World worldIn, Random p_110668_5_, double p_110668_6_, double p_110668_8_, double p_110668_10_, double p_110668_12_, Position[] p_110668_14_, boolean p_110668_15_) throws CommandException {
        boolean var16 = true;
        double var18 = 3.4028234663852886E38;
        int var17 = 0;
        while (var17 < 10000 && var16) {
            Position var23;
            int var22;
            var16 = false;
            var18 = 3.4028234663852886E38;
            int var20 = 0;
            while (var20 < p_110668_14_.length) {
                Position var21 = p_110668_14_[var20];
                var22 = 0;
                var23 = new Position();
                int var24 = 0;
                while (var24 < p_110668_14_.length) {
                    if (var20 != var24) {
                        Position var25 = p_110668_14_[var24];
                        double var26 = var21.func_111099_a(var25);
                        var18 = Math.min(var26, var18);
                        if (var26 < p_110668_2_) {
                            ++var22;
                            var23.field_111101_a += var25.field_111101_a - var21.field_111101_a;
                            var23.field_111100_b += var25.field_111100_b - var21.field_111100_b;
                        }
                    }
                    ++var24;
                }
                if (var22 > 0) {
                    var23.field_111101_a /= (double)var22;
                    var23.field_111100_b /= (double)var22;
                    double var30 = var23.func_111096_b();
                    if (var30 > 0.0) {
                        var23.func_111095_a();
                        var21.func_111094_b(var23);
                    } else {
                        var21.func_111097_a(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                    }
                    var16 = true;
                }
                if (var21.func_111093_a(p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_)) {
                    var16 = true;
                }
                ++var20;
            }
            if (!var16) {
                Position[] var28 = p_110668_14_;
                int var29 = p_110668_14_.length;
                var22 = 0;
                while (var22 < var29) {
                    var23 = var28[var22];
                    if (!var23.func_111098_b(worldIn)) {
                        var23.func_111097_a(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                        var16 = true;
                    }
                    ++var22;
                }
            }
            ++var17;
        }
        if (var17 >= 10000) {
            throw new CommandException("commands.spreadplayers.failure." + (p_110668_15_ ? "teams" : "players"), p_110668_14_.length, p_110668_1_.field_111101_a, p_110668_1_.field_111100_b, String.format("%.2f", var18));
        }
        return var17;
    }

    private double func_110671_a(List p_110671_1_, World worldIn, Position[] p_110671_3_, boolean p_110671_4_) {
        double var5 = 0.0;
        int var7 = 0;
        HashMap var8 = Maps.newHashMap();
        int var9 = 0;
        while (var9 < p_110671_1_.size()) {
            Position var11;
            Entity var10 = (Entity)p_110671_1_.get(var9);
            if (p_110671_4_) {
                Team var12;
                Team team = var12 = var10 instanceof EntityPlayer ? ((EntityPlayer)var10).getTeam() : null;
                if (!var8.containsKey(var12)) {
                    var8.put(var12, p_110671_3_[var7++]);
                }
                var11 = (Position)var8.get(var12);
            } else {
                var11 = p_110671_3_[var7++];
            }
            var10.setPositionAndUpdate((float)MathHelper.floor_double(var11.field_111101_a) + 0.5f, var11.func_111092_a(worldIn), (double)MathHelper.floor_double(var11.field_111100_b) + 0.5);
            double var17 = Double.MAX_VALUE;
            int var14 = 0;
            while (var14 < p_110671_3_.length) {
                if (var11 != p_110671_3_[var14]) {
                    double var15 = var11.func_111099_a(p_110671_3_[var14]);
                    var17 = Math.min(var15, var17);
                }
                ++var14;
            }
            var5 += var17;
            ++var9;
        }
        return var5 /= (double)p_110671_1_.size();
    }

    private Position[] func_110670_a(Random p_110670_1_, int p_110670_2_, double p_110670_3_, double p_110670_5_, double p_110670_7_, double p_110670_9_) {
        Position[] var11 = new Position[p_110670_2_];
        int var12 = 0;
        while (var12 < var11.length) {
            Position var13 = new Position();
            var13.func_111097_a(p_110670_1_, p_110670_3_, p_110670_5_, p_110670_7_, p_110670_9_);
            var11[var12] = var13;
            ++var12;
        }
        return var11;
    }

    static class Position {
        double field_111101_a;
        double field_111100_b;

        Position() {
        }

        Position(double p_i1358_1_, double p_i1358_3_) {
            this.field_111101_a = p_i1358_1_;
            this.field_111100_b = p_i1358_3_;
        }

        double func_111099_a(Position p_111099_1_) {
            double var2 = this.field_111101_a - p_111099_1_.field_111101_a;
            double var4 = this.field_111100_b - p_111099_1_.field_111100_b;
            return Math.sqrt(var2 * var2 + var4 * var4);
        }

        void func_111095_a() {
            double var1 = this.func_111096_b();
            this.field_111101_a /= var1;
            this.field_111100_b /= var1;
        }

        float func_111096_b() {
            return MathHelper.sqrt_double(this.field_111101_a * this.field_111101_a + this.field_111100_b * this.field_111100_b);
        }

        public void func_111094_b(Position p_111094_1_) {
            this.field_111101_a -= p_111094_1_.field_111101_a;
            this.field_111100_b -= p_111094_1_.field_111100_b;
        }

        public boolean func_111093_a(double p_111093_1_, double p_111093_3_, double p_111093_5_, double p_111093_7_) {
            boolean var9 = false;
            if (this.field_111101_a < p_111093_1_) {
                this.field_111101_a = p_111093_1_;
                var9 = true;
            } else if (this.field_111101_a > p_111093_5_) {
                this.field_111101_a = p_111093_5_;
                var9 = true;
            }
            if (this.field_111100_b < p_111093_3_) {
                this.field_111100_b = p_111093_3_;
                var9 = true;
            } else if (this.field_111100_b > p_111093_7_) {
                this.field_111100_b = p_111093_7_;
                var9 = true;
            }
            return var9;
        }

        public int func_111092_a(World worldIn) {
            BlockPos var2 = new BlockPos(this.field_111101_a, 256.0, this.field_111100_b);
            do {
                if (var2.getY() > 0) continue;
                return 257;
            } while (worldIn.getBlockState(var2 = var2.offsetDown()).getBlock().getMaterial() == Material.air);
            return var2.getY() + 1;
        }

        public boolean func_111098_b(World worldIn) {
            Material var3;
            BlockPos var2 = new BlockPos(this.field_111101_a, 256.0, this.field_111100_b);
            do {
                if (var2.getY() > 0) continue;
                return false;
            } while ((var3 = worldIn.getBlockState(var2 = var2.offsetDown()).getBlock().getMaterial()) == Material.air);
            return !var3.isLiquid() && var3 != Material.fire;
        }

        public void func_111097_a(Random p_111097_1_, double p_111097_2_, double p_111097_4_, double p_111097_6_, double p_111097_8_) {
            this.field_111101_a = MathHelper.getRandomDoubleInRange(p_111097_1_, p_111097_2_, p_111097_6_);
            this.field_111100_b = MathHelper.getRandomDoubleInRange(p_111097_1_, p_111097_4_, p_111097_8_);
        }
    }
}

