/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.init.Blocks;
import net.minecraft.src.Config;
import net.minecraft.src.ConnectedProperties;
import net.minecraft.src.RenderEnv;
import net.minecraft.src.ResourceUtils;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    private static final int Y_NEG_DOWN = 0;
    private static final int Y_POS_UP = 1;
    private static final int Z_NEG_NORTH = 2;
    private static final int Z_POS_SOUTH = 3;
    private static final int X_NEG_WEST = 4;
    private static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final int[] ctmIndexes;
    public static final IBlockState AIR_DEFAULT_STATE;
    private static TextureAtlasSprite emptySprite;

    static {
        int[] nArray = new int[64];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[16] = 12;
        nArray[17] = 13;
        nArray[18] = 14;
        nArray[19] = 15;
        nArray[20] = 16;
        nArray[21] = 17;
        nArray[22] = 18;
        nArray[23] = 19;
        nArray[24] = 20;
        nArray[25] = 21;
        nArray[26] = 22;
        nArray[27] = 23;
        nArray[32] = 24;
        nArray[33] = 25;
        nArray[34] = 26;
        nArray[35] = 27;
        nArray[36] = 28;
        nArray[37] = 29;
        nArray[38] = 30;
        nArray[39] = 31;
        nArray[40] = 32;
        nArray[41] = 33;
        nArray[42] = 34;
        nArray[43] = 35;
        nArray[48] = 36;
        nArray[49] = 37;
        nArray[50] = 38;
        nArray[51] = 39;
        nArray[52] = 40;
        nArray[53] = 41;
        nArray[54] = 42;
        nArray[55] = 43;
        nArray[56] = 44;
        nArray[57] = 45;
        nArray[58] = 46;
        ctmIndexes = nArray;
        AIR_DEFAULT_STATE = Blocks.air.getDefaultState();
        emptySprite = null;
    }

    public static synchronized BakedQuad getConnectedTexture(IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, BakedQuad quad, RenderEnv renderEnv) {
        IBlockState side;
        TextureAtlasSprite spriteIn = quad.getSprite();
        if (spriteIn == null) {
            return quad;
        }
        Block block = blockState.getBlock();
        if (block instanceof BlockPane && spriteIn.getIconName().startsWith("minecraft:blocks/glass_pane_top") && (side = blockAccess.getBlockState(blockPos.offset(quad.getFace()))) == blockState) {
            return ConnectedTextures.getQuad(emptySprite, block, blockState, quad);
        }
        EnumFacing side1 = quad.getFace();
        TextureAtlasSprite sprite = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side1, spriteIn, renderEnv);
        return sprite == spriteIn ? quad : ConnectedTextures.getQuad(sprite, block, blockState, quad);
    }

    private static BakedQuad getQuad(TextureAtlasSprite sprite, Block block, IBlockState blockState, BakedQuad quadIn) {
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex >= 0 && spriteIndex < spriteQuadMaps.length) {
            BakedQuad quad;
            IdentityHashMap quadMap = spriteQuadMaps[spriteIndex];
            if (quadMap == null) {
                quadMap = new IdentityHashMap(1);
                ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap;
            }
            if ((quad = (BakedQuad)quadMap.get(quadIn)) == null) {
                quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
                ((Map)quadMap).put(quadIn, quad);
            }
            return quad;
        }
        return quadIn;
    }

    private static BakedQuad makeSpriteQuad(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] data = (int[])quad.func_178209_a().clone();
        TextureAtlasSprite spriteFrom = quad.getSprite();
        int bq = 0;
        while (bq < 4) {
            ConnectedTextures.fixVertex(data, bq, spriteFrom, sprite);
            ++bq;
        }
        BakedQuad var5 = new BakedQuad(data, quad.func_178211_c(), quad.getFace(), sprite);
        return var5;
    }

    private static void fixVertex(int[] data, int vertex, TextureAtlasSprite spriteFrom, TextureAtlasSprite spriteTo) {
        int pos = 7 * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.getInterpolatedU(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.getInterpolatedV(sv16));
    }

    private static TextureAtlasSprite getConnectedTextureMultiPass(IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, EnumFacing side, TextureAtlasSprite icon, RenderEnv renderEnv) {
        TextureAtlasSprite newIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, icon, true, renderEnv);
        if (!multipass) {
            return newIcon;
        }
        if (newIcon == icon) {
            return newIcon;
        }
        TextureAtlasSprite mpIcon = newIcon;
        int i = 0;
        while (i < 3) {
            TextureAtlasSprite newMpIcon = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpIcon, false, renderEnv);
            if (newMpIcon == mpIcon) break;
            mpIcon = newMpIcon;
            ++i;
        }
        return mpIcon;
    }

    public static TextureAtlasSprite getConnectedTextureSingle(IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, EnumFacing facing, TextureAtlasSprite icon, boolean checkBlocks, RenderEnv renderEnv) {
        ConnectedProperties cp;
        int i;
        int side;
        int metadata;
        ConnectedProperties[] cps;
        int blockId;
        Block block = blockState.getBlock();
        if (tileProperties != null && (blockId = icon.getIndexInMap()) >= 0 && blockId < tileProperties.length && (cps = tileProperties[blockId]) != null) {
            metadata = renderEnv.getMetadata();
            side = ConnectedTextures.getSide(facing);
            i = 0;
            while (i < cps.length) {
                TextureAtlasSprite newIcon1;
                int newIcon;
                cp = cps[i];
                if (cp != null && cp.matchesBlock(newIcon = renderEnv.getBlockId()) && (newIcon1 = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv)) != null) {
                    return newIcon1;
                }
                ++i;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            metadata = renderEnv.getMetadata();
            side = ConnectedTextures.getSide(facing);
            i = 0;
            while (i < cps.length) {
                TextureAtlasSprite var16;
                cp = cps[i];
                if (cp != null && cp.matchesIcon(icon) && (var16 = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv)) != null) {
                    return var16;
                }
                ++i;
            }
        }
        return icon;
    }

    private static int getSide(EnumFacing facing) {
        if (facing == null) {
            return -1;
        }
        switch (NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[facing.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return -1;
    }

    private static EnumFacing getFacing(int side) {
        switch (side) {
            case 0: {
                return EnumFacing.DOWN;
            }
            case 1: {
                return EnumFacing.UP;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.SOUTH;
            }
            case 4: {
                return EnumFacing.WEST;
            }
            case 5: {
                return EnumFacing.EAST;
            }
        }
        return EnumFacing.UP;
    }

    private static TextureAtlasSprite getConnectedTexture(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int side, TextureAtlasSprite icon, int metadata, RenderEnv renderEnv) {
        int y = blockPos.getY();
        if (y >= cp.minHeight && y <= cp.maxHeight) {
            if (cp.biomes != null) {
                BiomeGenBase vertAxis = blockAccess.getBiomeGenForCoords(blockPos);
                boolean metadataCheck = false;
                int block = 0;
                while (block < cp.biomes.length) {
                    BiomeGenBase mds = cp.biomes[block];
                    if (vertAxis == mds) {
                        metadataCheck = true;
                        break;
                    }
                    ++block;
                }
                if (!metadataCheck) {
                    return null;
                }
            }
            int var15 = 0;
            int var16 = metadata;
            Block var17 = blockState.getBlock();
            if (var17 instanceof BlockRotatedPillar) {
                var15 = ConnectedTextures.getWoodAxis(side, metadata);
                var16 = metadata & 3;
            }
            if (var17 instanceof BlockQuartz) {
                var15 = ConnectedTextures.getQuartzAxis(side, metadata);
                if (var16 > 2) {
                    var16 = 2;
                }
            }
            if (side >= 0 && cp.faces != 63) {
                int var18 = side;
                if (var15 != 0) {
                    var18 = ConnectedTextures.fixSideByAxis(side, var15);
                }
                if ((1 << var18 & cp.faces) == 0) {
                    return null;
                }
            }
            if (cp.metadatas != null) {
                int[] var19 = cp.metadatas;
                boolean metadataFound = false;
                int i = 0;
                while (i < var19.length) {
                    if (var19[i] == var16) {
                        metadataFound = true;
                        break;
                    }
                    ++i;
                }
                if (!metadataFound) {
                    return null;
                }
            }
            switch (cp.method) {
                case 1: {
                    return ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, side, icon, metadata, renderEnv);
                }
                case 2: {
                    return ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, var15, side, icon, metadata);
                }
                case 3: {
                    return ConnectedTextures.getConnectedTextureTop(cp, blockAccess, blockState, blockPos, var15, side, icon, metadata);
                }
                case 4: {
                    return ConnectedTextures.getConnectedTextureRandom(cp, blockPos, side);
                }
                case 5: {
                    return ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
                }
                case 6: {
                    return ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, var15, side, icon, metadata);
                }
                case 7: {
                    return ConnectedTextures.getConnectedTextureFixed(cp);
                }
                case 8: {
                    return ConnectedTextures.getConnectedTextureHorizontalVertical(cp, blockAccess, blockState, blockPos, var15, side, icon, metadata);
                }
                case 9: {
                    return ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, blockAccess, blockState, blockPos, var15, side, icon, metadata);
                }
            }
            return null;
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    default: {
                        return side;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: 
                }
                return 0;
            }
        }
        return side;
    }

    private static int getWoodAxis(int side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private static int getQuartzAxis(int side, int metadata) {
        switch (metadata) {
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    private static TextureAtlasSprite getConnectedTextureRandom(ConnectedProperties cp, BlockPos blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            int i = 0;
            while (i < sumWeights.length) {
                if (randWeight < sumWeights[i]) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return cp.tileIcons[index];
    }

    private static TextureAtlasSprite getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static TextureAtlasSprite getConnectedTextureRepeat(ConnectedProperties cp, BlockPos blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.getX();
        int y = blockPos.getY();
        int z = blockPos.getZ();
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = z;
                break;
            }
            case 1: {
                nx = x;
                ny = z;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.tileIcons[index];
    }

    private static TextureAtlasSprite getConnectedTextureCtm(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int side, TextureAtlasSprite icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return cp.tileIcons[index];
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp.tileIcons[index];
        }
        switch (side) {
            case 0: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetNorth(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetNorth(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetSouth(), side, icon, metadata);
                borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetSouth(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetSouth(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetSouth(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetNorth(), side, icon, metadata);
                borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetNorth(), side, icon, metadata);
                break;
            }
            case 2: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetDown(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetDown(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetUp(), side, icon, metadata);
                borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetUp(), side, icon, metadata);
                break;
            }
            case 3: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetDown(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetDown(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast().offsetUp(), side, icon, metadata);
                borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest().offsetUp(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown().offsetSouth(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown().offsetNorth(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp().offsetSouth(), side, icon, metadata);
                borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp().offsetNorth(), side, icon, metadata);
                break;
            }
            case 5: {
                borders[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown().offsetNorth(), side, icon, metadata);
                borders[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown().offsetSouth(), side, icon, metadata);
                borders[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp().offsetNorth(), side, icon, metadata);
                boolean bl = borders[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp().offsetSouth(), side, icon, metadata);
            }
        }
        if (index == 13 && borders[0]) {
            index = 4;
        } else if (index == 15 && borders[1]) {
            index = 5;
        } else if (index == 37 && borders[2]) {
            index = 16;
        } else if (index == 39 && borders[3]) {
            index = 17;
        } else if (index == 14 && borders[0] && borders[1]) {
            index = 7;
        } else if (index == 25 && borders[0] && borders[2]) {
            index = 6;
        } else if (index == 27 && borders[3] && borders[1]) {
            index = 19;
        } else if (index == 38 && borders[3] && borders[2]) {
            index = 18;
        } else if (index == 14 && !borders[0] && borders[1]) {
            index = 31;
        } else if (index == 25 && borders[0] && !borders[2]) {
            index = 30;
        } else if (index == 27 && !borders[3] && borders[1]) {
            index = 41;
        } else if (index == 38 && borders[3] && !borders[2]) {
            index = 40;
        } else if (index == 14 && borders[0] && !borders[1]) {
            index = 29;
        } else if (index == 25 && !borders[0] && borders[2]) {
            index = 28;
        } else if (index == 27 && borders[3] && !borders[1]) {
            index = 43;
        } else if (index == 38 && !borders[3] && borders[2]) {
            index = 42;
        } else if (index == 26 && borders[0] && borders[1] && borders[2] && borders[3]) {
            index = 46;
        } else if (index == 26 && !borders[0] && borders[1] && borders[2] && borders[3]) {
            index = 9;
        } else if (index == 26 && borders[0] && !borders[1] && borders[2] && borders[3]) {
            index = 21;
        } else if (index == 26 && borders[0] && borders[1] && !borders[2] && borders[3]) {
            index = 8;
        } else if (index == 26 && borders[0] && borders[1] && borders[2] && !borders[3]) {
            index = 20;
        } else if (index == 26 && borders[0] && borders[1] && !borders[2] && !borders[3]) {
            index = 11;
        } else if (index == 26 && !borders[0] && !borders[1] && borders[2] && borders[3]) {
            index = 22;
        } else if (index == 26 && !borders[0] && borders[1] && !borders[2] && borders[3]) {
            index = 23;
        } else if (index == 26 && borders[0] && !borders[1] && borders[2] && !borders[3]) {
            index = 10;
        } else if (index == 26 && borders[0] && !borders[1] && !borders[2] && borders[3]) {
            index = 34;
        } else if (index == 26 && !borders[0] && borders[1] && borders[2] && !borders[3]) {
            index = 35;
        } else if (index == 26 && borders[0] && !borders[1] && !borders[2] && !borders[3]) {
            index = 32;
        } else if (index == 26 && !borders[0] && borders[1] && !borders[2] && !borders[3]) {
            index = 33;
        } else if (index == 26 && !borders[0] && !borders[1] && borders[2] && !borders[3]) {
            index = 44;
        } else if (index == 26 && !borders[0] && !borders[1] && !borders[2] && borders[3]) {
            index = 45;
        }
        return cp.tileIcons[index];
    }

    private static boolean isNeighbour(ConnectedProperties cp, IBlockAccess iblockaccess, IBlockState blockState, BlockPos blockPos, int side, TextureAtlasSprite icon, int metadata) {
        IBlockState neighbourState = iblockaccess.getBlockState(blockPos);
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            TextureAtlasSprite neighbourIcon = ConnectedTextures.getNeighbourIcon(iblockaccess, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        return cp.connect == 3 ? (neighbourState == null ? false : (neighbourState == AIR_DEFAULT_STATE ? false : neighbourState.getBlock().getMaterial() == blockState.getBlock().getMaterial())) : false;
    }

    private static TextureAtlasSprite getNeighbourIcon(IBlockAccess iblockaccess, BlockPos blockPos, IBlockState neighbourState, int side) {
        neighbourState = neighbourState.getBlock().getActualState(neighbourState, iblockaccess, blockPos);
        IBakedModel model = Minecraft.getMinecraft().getBlockRendererDispatcher().func_175023_a().func_178125_b(neighbourState);
        if (model == null) {
            return null;
        }
        EnumFacing facing = ConnectedTextures.getFacing(side);
        List quads = model.func_177551_a(facing);
        if (quads.size() > 0) {
            BakedQuad var10 = (BakedQuad)quads.get(0);
            return var10.getSprite();
        }
        List quadsGeneral = model.func_177550_a();
        int i = 0;
        while (i < quadsGeneral.size()) {
            BakedQuad quad = (BakedQuad)quadsGeneral.get(i);
            if (quad.getFace() == facing) {
                return quad.getSprite();
            }
            ++i;
        }
        return null;
    }

    private static TextureAtlasSprite getConnectedTextureHorizontal(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int vertAxis, int side, TextureAtlasSprite icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: 
                    case 1: {
                        return null;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
                        break;
                    }
                    case 2: 
                    case 3: {
                        return null;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                        break block0;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        return null;
                    }
                }
            }
        }
        boolean index = true;
        int index1 = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index1];
    }

    private static TextureAtlasSprite getConnectedTextureVertical(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int vertAxis, int side, TextureAtlasSprite icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetDown(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetNorth(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetWest(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
            }
        }
        boolean index = true;
        int index1 = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index1];
    }

    private static TextureAtlasSprite getConnectedTextureHorizontalVertical(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int vertAxis, int side, TextureAtlasSprite icon, int metadata) {
        TextureAtlasSprite[] tileIcons = cp.tileIcons;
        TextureAtlasSprite iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        TextureAtlasSprite iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        return iconV == tileIcons[0] ? tileIcons[4] : (iconV == tileIcons[1] ? tileIcons[5] : (iconV == tileIcons[2] ? tileIcons[6] : iconV));
    }

    private static TextureAtlasSprite getConnectedTextureVerticalHorizontal(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int vertAxis, int side, TextureAtlasSprite icon, int metadata) {
        TextureAtlasSprite[] tileIcons = cp.tileIcons;
        TextureAtlasSprite iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        TextureAtlasSprite iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        return iconH == tileIcons[0] ? tileIcons[4] : (iconH == tileIcons[1] ? tileIcons[5] : (iconH == tileIcons[2] ? tileIcons[6] : iconH));
    }

    private static TextureAtlasSprite getConnectedTextureTop(ConnectedProperties cp, IBlockAccess blockAccess, IBlockState blockState, BlockPos blockPos, int vertAxis, int side, TextureAtlasSprite icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetUp(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetSouth(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.offsetEast(), side, icon, metadata);
            }
        }
        return top ? cp.tileIcons[0] : null;
    }

    public static void updateIcons(TextureMap textureMap) {
        blockProperties = null;
        tileProperties = null;
        if (Config.isConnectedTextures()) {
            IResourcePack[] rps = Config.getResourcePacks();
            int locEmpty = rps.length - 1;
            while (locEmpty >= 0) {
                IResourcePack rp = rps[locEmpty];
                ConnectedTextures.updateIcons(textureMap, rp);
                --locEmpty;
            }
            ConnectedTextures.updateIcons(textureMap, Config.getDefaultResourcePack());
            ResourceLocation var4 = new ResourceLocation("mcpatcher/ctm/default/empty");
            emptySprite = textureMap.func_174942_a(var4);
            spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        }
    }

    private static void updateIconEmpty(TextureMap textureMap) {
    }

    public static void updateIcons(TextureMap textureMap, IResourcePack rp) {
        Object[] names = ConnectedTextures.collectFiles(rp, "mcpatcher/ctm/", ".properties");
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        int i = 0;
        while (i < names.length) {
            Object name = names[i];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                ResourceLocation e = new ResourceLocation((String)name);
                InputStream in = rp.getInputStream(e);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                } else {
                    Properties props = new Properties();
                    props.load(in);
                    ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                    if (cp.isValid((String)name)) {
                        cp.updateIcons(textureMap);
                        ConnectedTextures.addToTileList(cp, tileList);
                        ConnectedTextures.addToBlockList(cp, blockList);
                    }
                }
            }
            catch (FileNotFoundException var11) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
            }
            catch (IOException var12) {
                var12.printStackTrace();
            }
            ++i;
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            int i = 0;
            while (i < propsArr.length) {
                ConnectedProperties[] props = propsArr[i];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
                ++i;
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] matchIconSet;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        int props = 0;
        while (props < tileProperties.length) {
            matchIconSet = tileProperties[props];
            if (matchIconSet != null) {
                propList.addAll(Arrays.asList(matchIconSet));
            }
            ++props;
        }
        props = 0;
        while (props < blockProperties.length) {
            matchIconSet = blockProperties[props];
            if (matchIconSet != null) {
                propList.addAll(Arrays.asList(matchIconSet));
            }
            ++props;
        }
        ConnectedProperties[] var6 = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<TextureAtlasSprite> var7 = new HashSet<TextureAtlasSprite>();
        HashSet<TextureAtlasSprite> tileIconSet = new HashSet<TextureAtlasSprite>();
        int i = 0;
        while (i < var6.length) {
            ConnectedProperties cp = var6[i];
            if (cp.matchTileIcons != null) {
                var7.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons != null) {
                tileIconSet.addAll(Arrays.asList(cp.tileIcons));
            }
            ++i;
        }
        var7.retainAll(tileIconSet);
        return !var7.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        int i = 0;
        while (i < list.size()) {
            List subList = (List)list.get(i);
            if (subList != null) {
                ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
                propArr[i] = subArr;
            }
            ++i;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons != null) {
            int i = 0;
            while (i < cp.matchTileIcons.length) {
                TextureAtlasSprite icon = cp.matchTileIcons[i];
                if (!(icon instanceof TextureAtlasSprite)) {
                    Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.getIconName());
                } else {
                    int tileId = icon.getIndexInMap();
                    if (tileId < 0) {
                        Config.warn("Invalid tile ID: " + tileId + ", icon: " + icon.getIconName());
                    } else {
                        ConnectedTextures.addToList(cp, tileList, tileId);
                    }
                }
                ++i;
            }
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks != null) {
            int i = 0;
            while (i < cp.matchBlocks.length) {
                int blockId = cp.matchBlocks[i];
                if (blockId < 0) {
                    Config.warn("Invalid block ID: " + blockId);
                } else {
                    ConnectedTextures.addToList(cp, blockList, blockId);
                }
                ++i;
            }
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    private static String[] collectFiles(IResourcePack rp, String prefix, String suffix) {
        if (rp instanceof DefaultResourcePack) {
            return ConnectedTextures.collectFilesDefault(rp);
        }
        if (!(rp instanceof AbstractResourcePack)) {
            return new String[0];
        }
        AbstractResourcePack arp = (AbstractResourcePack)rp;
        File tpFile = ResourceUtils.getResourcePackFile(arp);
        return tpFile == null ? new String[]{} : (tpFile.isDirectory() ? ConnectedTextures.collectFilesFolder(tpFile, "", prefix, suffix) : (tpFile.isFile() ? ConnectedTextures.collectFilesZIP(tpFile, prefix, suffix) : new String[]{}));
    }

    private static String[] collectFilesDefault(IResourcePack rp) {
        ArrayList<String> list = new ArrayList<String>();
        String[] names = ConnectedTextures.getDefaultCtmPaths();
        int nameArr = 0;
        while (nameArr < names.length) {
            String name = names[nameArr];
            ResourceLocation loc = new ResourceLocation(name);
            if (rp.resourceExists(loc)) {
                list.add(name);
            }
            ++nameArr;
        }
        String[] var6 = list.toArray(new String[list.size()]);
        return var6;
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String defPath = "mcpatcher/ctm/default/";
        if (Config.isFromDefaultResourcePack(new ResourceLocation("textures/blocks/glass.png"))) {
            list.add(String.valueOf(defPath) + "glass.properties");
            list.add(String.valueOf(defPath) + "glasspane.properties");
        }
        if (Config.isFromDefaultResourcePack(new ResourceLocation("textures/blocks/bookshelf.png"))) {
            list.add(String.valueOf(defPath) + "bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new ResourceLocation("textures/blocks/sandstone_normal.png"))) {
            list.add(String.valueOf(defPath) + "sandstone.properties");
        }
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        int paths = 0;
        while (paths < colors.length) {
            String color = colors[paths];
            if (Config.isFromDefaultResourcePack(new ResourceLocation("textures/blocks/glass_" + color + ".png"))) {
                list.add(String.valueOf(defPath) + paths + "_glass_" + color + "/glass_" + color + ".properties");
                list.add(String.valueOf(defPath) + paths + "_glass_" + color + "/glass_pane_" + color + ".properties");
            }
            ++paths;
        }
        String[] var5 = list.toArray(new String[list.size()]);
        return var5;
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        int names = 0;
        while (names < files.length) {
            String dirPath;
            File file = files[names];
            if (file.isFile()) {
                dirPath = String.valueOf(basePath) + file.getName();
                if (dirPath.startsWith(prefixAssets) && (dirPath = dirPath.substring(prefixAssets.length())).startsWith(prefix) && dirPath.endsWith(suffix)) {
                    list.add(dirPath);
                }
            } else if (file.isDirectory()) {
                dirPath = String.valueOf(basePath) + file.getName() + "/";
                String[] names1 = ConnectedTextures.collectFilesFolder(file, dirPath, prefix, suffix);
                int n = 0;
                while (n < names1.length) {
                    String name = names1[n];
                    list.add(name);
                    ++n;
                }
            }
            ++names;
        }
        String[] var13 = list.toArray(new String[list.size()]);
        return var13;
    }

    private static String[] collectFilesZIP(File tpFile, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile e = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = e.entries();
            while (en.hasMoreElements()) {
                ZipEntry names = en.nextElement();
                String name = names.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
            }
            e.close();
            String[] names1 = list.toArray(new String[list.size()]);
            return names1;
        }
        catch (IOException var9) {
            var9.printStackTrace();
            return new String[0];
        }
    }

    public static int getPaneTextureIndex(boolean linkP, boolean linkN, boolean linkYp, boolean linkYn) {
        return linkN && linkP ? (linkYp ? (linkYn ? 34 : 50) : (linkYn ? 18 : 2)) : (linkN && !linkP ? (linkYp ? (linkYn ? 35 : 51) : (linkYn ? 19 : 3)) : (!linkN && linkP ? (linkYp ? (linkYn ? 33 : 49) : (linkYn ? 17 : 1)) : (linkYp ? (linkYn ? 32 : 48) : (linkYn ? 16 : 0))));
    }

    public static int getReversePaneTextureIndex(int texNum) {
        int col = texNum % 16;
        return col == 1 ? texNum + 2 : (col == 3 ? texNum - 2 : texNum);
    }

    public static TextureAtlasSprite getCtmTexture(ConnectedProperties cp, int ctmIndex, TextureAtlasSprite icon) {
        if (cp.method != 1) {
            return icon;
        }
        if (ctmIndex >= 0 && ctmIndex < ctmIndexes.length) {
            int index = ctmIndexes[ctmIndex];
            TextureAtlasSprite[] ctmIcons = cp.tileIcons;
            return index >= 0 && index < ctmIcons.length ? ctmIcons[index] : icon;
        }
        return icon;
    }

    static class NamelessClass24397949 {
        static final int[] $SwitchMap$net$minecraft$util$EnumFacing = new int[EnumFacing.values().length];

        static {
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.NORTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                NamelessClass24397949.$SwitchMap$net$minecraft$util$EnumFacing[EnumFacing.SOUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        NamelessClass24397949() {
        }
    }
}

