/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class GuiSubtitleOverlay
extends Gui
implements ISoundEventListener {
    private final Minecraft client;
    private final List<Subtitle> subtitles = Lists.newArrayList();
    private boolean enabled;

    public GuiSubtitleOverlay(Minecraft clientIn) {
        this.client = clientIn;
    }

    public void renderSubtitles(ScaledResolution resolution) {
        if (!this.enabled && this.client.gameSettings.showSubtitles) {
            this.client.getSoundHandler().addListener(this);
            this.enabled = true;
        } else if (this.enabled && !this.client.gameSettings.showSubtitles) {
            this.client.getSoundHandler().removeListener(this);
            this.enabled = false;
        }
        if (this.enabled && !this.subtitles.isEmpty()) {
            GlStateManager.pushMatrix();
            GlStateManager.enableBlend();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            Vec3d vec3d = new Vec3d(this.client.thePlayer.posX, this.client.thePlayer.posY + (double)this.client.thePlayer.getEyeHeight(), this.client.thePlayer.posZ);
            Vec3d vec3d1 = new Vec3d(0.0, 0.0, -1.0).rotatePitch(-this.client.thePlayer.rotationPitch * ((float)Math.PI / 180)).rotateYaw(-this.client.thePlayer.rotationYaw * ((float)Math.PI / 180));
            Vec3d vec3d2 = new Vec3d(0.0, 1.0, 0.0).rotatePitch(-this.client.thePlayer.rotationPitch * ((float)Math.PI / 180)).rotateYaw(-this.client.thePlayer.rotationYaw * ((float)Math.PI / 180));
            Vec3d vec3d3 = vec3d1.crossProduct(vec3d2);
            int i = 0;
            int j = 0;
            Iterator<Subtitle> iterator = this.subtitles.iterator();
            while (iterator.hasNext()) {
                Subtitle guisubtitleoverlay$subtitle = iterator.next();
                if (guisubtitleoverlay$subtitle.getStartTime() + 3000L <= Minecraft.getSystemTime()) {
                    iterator.remove();
                    continue;
                }
                j = Math.max(j, this.client.fontRendererObj.getStringWidth(guisubtitleoverlay$subtitle.getString()));
            }
            j = j + this.client.fontRendererObj.getStringWidth("<") + this.client.fontRendererObj.getStringWidth(" ") + this.client.fontRendererObj.getStringWidth(">") + this.client.fontRendererObj.getStringWidth(" ");
            for (Subtitle guisubtitleoverlay$subtitle1 : this.subtitles) {
                int k = 255;
                String s = guisubtitleoverlay$subtitle1.getString();
                Vec3d vec3d4 = guisubtitleoverlay$subtitle1.getLocation().subtract(vec3d).normalize();
                double d0 = -vec3d3.dotProduct(vec3d4);
                double d1 = -vec3d1.dotProduct(vec3d4);
                boolean flag = d1 > 0.5;
                int l = j / 2;
                int i1 = this.client.fontRendererObj.FONT_HEIGHT;
                int j1 = i1 / 2;
                float f = 1.0f;
                int k1 = this.client.fontRendererObj.getStringWidth(s);
                int l1 = MathHelper.floor_double(MathHelper.denormalizeClamp(255.0, 75.0, (float)(Minecraft.getSystemTime() - guisubtitleoverlay$subtitle1.getStartTime()) / 3000.0f));
                int i2 = l1 << 16 | l1 << 8 | l1;
                GlStateManager.pushMatrix();
                GlStateManager.translate((float)resolution.getScaledWidth() - (float)l * 1.0f - 2.0f, (float)(resolution.getScaledHeight() - 30) - (float)(i * (i1 + 1)) * 1.0f, 0.0f);
                GlStateManager.scale(1.0f, 1.0f, 1.0f);
                GuiSubtitleOverlay.drawRect(-l - 1, -j1 - 1, l + 1, j1 + 1, -872415232);
                GlStateManager.enableBlend();
                if (!flag) {
                    if (d0 > 0.0) {
                        this.client.fontRendererObj.drawString(">", l - this.client.fontRendererObj.getStringWidth(">"), -j1, i2 + -16777216);
                    } else if (d0 < 0.0) {
                        this.client.fontRendererObj.drawString("<", -l, -j1, i2 + -16777216);
                    }
                }
                this.client.fontRendererObj.drawString(s, -k1 / 2, -j1, i2 + -16777216);
                GlStateManager.popMatrix();
                ++i;
            }
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
    }

    @Override
    public void soundPlay(ISound soundIn, SoundEventAccessor accessor) {
        if (accessor.getSubtitle() != null) {
            String s = accessor.getSubtitle().getFormattedText();
            if (!this.subtitles.isEmpty()) {
                for (Subtitle guisubtitleoverlay$subtitle : this.subtitles) {
                    if (!guisubtitleoverlay$subtitle.getString().equals(s)) continue;
                    guisubtitleoverlay$subtitle.refresh(new Vec3d(soundIn.getXPosF(), soundIn.getYPosF(), soundIn.getZPosF()));
                    return;
                }
            }
            this.subtitles.add(new Subtitle(s, new Vec3d(soundIn.getXPosF(), soundIn.getYPosF(), soundIn.getZPosF())));
        }
    }

    public class Subtitle {
        private final String subtitle;
        private long startTime;
        private Vec3d location;

        public Subtitle(String subtitleIn, Vec3d locationIn) {
            this.subtitle = subtitleIn;
            this.location = locationIn;
            this.startTime = Minecraft.getSystemTime();
        }

        public String getString() {
            return this.subtitle;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public Vec3d getLocation() {
            return this.location;
        }

        public void refresh(Vec3d locationIn) {
            this.location = locationIn;
            this.startTime = Minecraft.getSystemTime();
        }
    }
}

