/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandSpreadPlayers
extends CommandBase {
    @Override
    public String getCommandName() {
        return "spreadplayers";
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 2;
    }

    @Override
    public String getCommandUsage(ICommandSender sender) {
        return "commands.spreadplayers.usage";
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 6) {
            throw new WrongUsageException("commands.spreadplayers.usage", new Object[0]);
        }
        int i = 0;
        BlockPos blockpos = sender.getPosition();
        double d0 = CommandSpreadPlayers.parseDouble(blockpos.getX(), args[i++], true);
        double d1 = CommandSpreadPlayers.parseDouble(blockpos.getZ(), args[i++], true);
        double d2 = CommandSpreadPlayers.parseDouble(args[i++], 0.0);
        double d3 = CommandSpreadPlayers.parseDouble(args[i++], d2 + 1.0);
        boolean flag = CommandSpreadPlayers.parseBoolean(args[i++]);
        ArrayList list = Lists.newArrayList();
        while (i < args.length) {
            String s;
            if (EntitySelector.hasArguments(s = args[i++])) {
                List<Entity> list1 = EntitySelector.matchEntities(sender, s, Entity.class);
                if (list1.isEmpty()) {
                    throw new EntityNotFoundException();
                }
                list.addAll(list1);
                continue;
            }
            EntityPlayerMP entityplayer = server.getPlayerList().getPlayerByUsername(s);
            if (entityplayer == null) {
                throw new PlayerNotFoundException();
            }
            list.add(entityplayer);
        }
        sender.setCommandStat(CommandResultStats.Type.AFFECTED_ENTITIES, list.size());
        if (list.isEmpty()) {
            throw new EntityNotFoundException();
        }
        sender.addChatMessage(new TextComponentTranslation("commands.spreadplayers.spreading." + (flag ? "teams" : "players"), list.size(), d3, d0, d1, d2));
        this.spread(sender, list, new Position(d0, d1), d2, d3, ((Entity)list.get((int)0)).worldObj, flag);
    }

    private void spread(ICommandSender sender, List<Entity> p_110669_2_, Position p_110669_3_, double spreadDistance, double maxRange, World worldIn, boolean respectTeams) throws CommandException {
        Random random = new Random();
        double d0 = p_110669_3_.x - maxRange;
        double d1 = p_110669_3_.z - maxRange;
        double d2 = p_110669_3_.x + maxRange;
        double d3 = p_110669_3_.z + maxRange;
        Position[] acommandspreadplayers$position = this.createInitialPositions(random, respectTeams ? this.getNumberOfTeams(p_110669_2_) : p_110669_2_.size(), d0, d1, d2, d3);
        int i = this.spreadPositions(p_110669_3_, spreadDistance, worldIn, random, d0, d1, d2, d3, acommandspreadplayers$position, respectTeams);
        double d4 = this.setPlayerPositions(p_110669_2_, worldIn, acommandspreadplayers$position, respectTeams);
        CommandSpreadPlayers.notifyCommandListener(sender, (ICommand)this, "commands.spreadplayers.success." + (respectTeams ? "teams" : "players"), acommandspreadplayers$position.length, p_110669_3_.x, p_110669_3_.z);
        if (acommandspreadplayers$position.length > 1) {
            sender.addChatMessage(new TextComponentTranslation("commands.spreadplayers.info." + (respectTeams ? "teams" : "players"), String.format("%.2f", d4), i));
        }
    }

    private int getNumberOfTeams(List<Entity> p_110667_1_) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : p_110667_1_) {
            if (entity instanceof EntityPlayer) {
                set.add(((EntityPlayer)entity).getTeam());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private int spreadPositions(Position p_110668_1_, double p_110668_2_, World worldIn, Random p_110668_5_, double p_110668_6_, double p_110668_8_, double p_110668_10_, double p_110668_12_, Position[] p_110668_14_, boolean p_110668_15_) throws CommandException {
        boolean flag = true;
        double d0 = 3.4028234663852886E38;
        int i = 0;
        while (i < 10000 && flag) {
            flag = false;
            d0 = 3.4028234663852886E38;
            int j = 0;
            while (j < p_110668_14_.length) {
                Position commandspreadplayers$position = p_110668_14_[j];
                int k = 0;
                Position commandspreadplayers$position1 = new Position();
                int l = 0;
                while (l < p_110668_14_.length) {
                    if (j != l) {
                        Position commandspreadplayers$position2 = p_110668_14_[l];
                        double d1 = commandspreadplayers$position.dist(commandspreadplayers$position2);
                        d0 = Math.min(d1, d0);
                        if (d1 < p_110668_2_) {
                            ++k;
                            commandspreadplayers$position1.x += commandspreadplayers$position2.x - commandspreadplayers$position.x;
                            commandspreadplayers$position1.z += commandspreadplayers$position2.z - commandspreadplayers$position.z;
                        }
                    }
                    ++l;
                }
                if (k > 0) {
                    commandspreadplayers$position1.x /= (double)k;
                    commandspreadplayers$position1.z /= (double)k;
                    double d2 = commandspreadplayers$position1.getLength();
                    if (d2 > 0.0) {
                        commandspreadplayers$position1.normalize();
                        commandspreadplayers$position.moveAway(commandspreadplayers$position1);
                    } else {
                        commandspreadplayers$position.randomize(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                    }
                    flag = true;
                }
                if (commandspreadplayers$position.clamp(p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_)) {
                    flag = true;
                }
                ++j;
            }
            if (!flag) {
                Position[] positionArray = p_110668_14_;
                int n = p_110668_14_.length;
                int n2 = 0;
                while (n2 < n) {
                    Position commandspreadplayers$position3 = positionArray[n2];
                    if (!commandspreadplayers$position3.isSafe(worldIn)) {
                        commandspreadplayers$position3.randomize(p_110668_5_, p_110668_6_, p_110668_8_, p_110668_10_, p_110668_12_);
                        flag = true;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (i >= 10000) {
            throw new CommandException("commands.spreadplayers.failure." + (p_110668_15_ ? "teams" : "players"), p_110668_14_.length, p_110668_1_.x, p_110668_1_.z, String.format("%.2f", d0));
        }
        return i;
    }

    private double setPlayerPositions(List<Entity> p_110671_1_, World worldIn, Position[] p_110671_3_, boolean p_110671_4_) {
        double d0 = 0.0;
        int i = 0;
        HashMap map = Maps.newHashMap();
        int j = 0;
        while (j < p_110671_1_.size()) {
            Position commandspreadplayers$position;
            Entity entity = p_110671_1_.get(j);
            if (p_110671_4_) {
                Team team;
                Team team2 = team = entity instanceof EntityPlayer ? ((EntityPlayer)entity).getTeam() : null;
                if (!map.containsKey(team)) {
                    map.put(team, p_110671_3_[i++]);
                }
                commandspreadplayers$position = (Position)map.get(team);
            } else {
                commandspreadplayers$position = p_110671_3_[i++];
            }
            entity.setPositionAndUpdate((float)MathHelper.floor_double(commandspreadplayers$position.x) + 0.5f, commandspreadplayers$position.getSpawnY(worldIn), (double)MathHelper.floor_double(commandspreadplayers$position.z) + 0.5);
            double d2 = Double.MAX_VALUE;
            Position[] positionArray = p_110671_3_;
            int n = p_110671_3_.length;
            int n2 = 0;
            while (n2 < n) {
                Position commandspreadplayers$position1 = positionArray[n2];
                if (commandspreadplayers$position != commandspreadplayers$position1) {
                    double d1 = commandspreadplayers$position.dist(commandspreadplayers$position1);
                    d2 = Math.min(d1, d2);
                }
                ++n2;
            }
            d0 += d2;
            ++j;
        }
        return d0 /= (double)p_110671_1_.size();
    }

    private Position[] createInitialPositions(Random p_110670_1_, int p_110670_2_, double p_110670_3_, double p_110670_5_, double p_110670_7_, double p_110670_9_) {
        Position[] acommandspreadplayers$position = new Position[p_110670_2_];
        int i = 0;
        while (i < acommandspreadplayers$position.length) {
            Position commandspreadplayers$position = new Position();
            commandspreadplayers$position.randomize(p_110670_1_, p_110670_3_, p_110670_5_, p_110670_7_, p_110670_9_);
            acommandspreadplayers$position[i] = commandspreadplayers$position;
            ++i;
        }
        return acommandspreadplayers$position;
    }

    @Override
    public List<String> getTabCompletionOptions(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return args.length >= 1 && args.length <= 2 ? CommandSpreadPlayers.getTabCompletionCoordinateXZ(args, 0, pos) : Collections.emptyList();
    }

    static class Position {
        double x;
        double z;

        Position() {
        }

        Position(double xIn, double zIn) {
            this.x = xIn;
            this.z = zIn;
        }

        double dist(Position p_111099_1_) {
            double d0 = this.x - p_111099_1_.x;
            double d1 = this.z - p_111099_1_.z;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void normalize() {
            double d0 = this.getLength();
            this.x /= d0;
            this.z /= d0;
        }

        float getLength() {
            return MathHelper.sqrt_double(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position p_111094_1_) {
            this.x -= p_111094_1_.x;
            this.z -= p_111094_1_.z;
        }

        public boolean clamp(double p_111093_1_, double p_111093_3_, double p_111093_5_, double p_111093_7_) {
            boolean flag = false;
            if (this.x < p_111093_1_) {
                this.x = p_111093_1_;
                flag = true;
            } else if (this.x > p_111093_5_) {
                this.x = p_111093_5_;
                flag = true;
            }
            if (this.z < p_111093_3_) {
                this.z = p_111093_3_;
                flag = true;
            } else if (this.z > p_111093_7_) {
                this.z = p_111093_7_;
                flag = true;
            }
            return flag;
        }

        public int getSpawnY(World worldIn) {
            BlockPos blockpos = new BlockPos(this.x, 256.0, this.z);
            while (blockpos.getY() > 0) {
                if (worldIn.getBlockState(blockpos = blockpos.down()).getMaterial() == Material.AIR) continue;
                return blockpos.getY() + 1;
            }
            return 257;
        }

        public boolean isSafe(World worldIn) {
            BlockPos blockpos = new BlockPos(this.x, 256.0, this.z);
            while (blockpos.getY() > 0) {
                Material material = worldIn.getBlockState(blockpos = blockpos.down()).getMaterial();
                if (material == Material.AIR) continue;
                return !material.isLiquid() && material != Material.FIRE;
            }
            return false;
        }

        public void randomize(Random rand, double p_111097_2_, double p_111097_4_, double p_111097_6_, double p_111097_8_) {
            this.x = MathHelper.getRandomDoubleInRange(rand, p_111097_2_, p_111097_6_);
            this.z = MathHelper.getRandomDoubleInRange(rand, p_111097_4_, p_111097_8_);
        }
    }
}

