/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.creativetab;

import java.util.List;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class CreativeTabs {
    public static final CreativeTabs[] CREATIVE_TAB_ARRAY = new CreativeTabs[12];
    public static final CreativeTabs BUILDING_BLOCKS = new CreativeTabs(0, "buildingBlocks"){

        @Override
        public Item getTabIconItem() {
            return Item.getItemFromBlock(Blocks.BRICK_BLOCK);
        }
    };
    public static final CreativeTabs DECORATIONS = new CreativeTabs(1, "decorations"){

        @Override
        public Item getTabIconItem() {
            return Item.getItemFromBlock(Blocks.DOUBLE_PLANT);
        }

        @Override
        public int getIconItemDamage() {
            return BlockDoublePlant.EnumPlantType.PAEONIA.getMeta();
        }
    };
    public static final CreativeTabs REDSTONE = new CreativeTabs(2, "redstone"){

        @Override
        public Item getTabIconItem() {
            return Items.REDSTONE;
        }
    };
    public static final CreativeTabs TRANSPORTATION = new CreativeTabs(3, "transportation"){

        @Override
        public Item getTabIconItem() {
            return Item.getItemFromBlock(Blocks.GOLDEN_RAIL);
        }
    };
    public static final CreativeTabs MISC = new CreativeTabs(4, "misc"){

        @Override
        public Item getTabIconItem() {
            return Items.LAVA_BUCKET;
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ALL);
    public static final CreativeTabs SEARCH = new CreativeTabs(5, "search"){

        @Override
        public Item getTabIconItem() {
            return Items.COMPASS;
        }
    }.setBackgroundImageName("item_search.png");
    public static final CreativeTabs FOOD = new CreativeTabs(6, "food"){

        @Override
        public Item getTabIconItem() {
            return Items.APPLE;
        }
    };
    public static final CreativeTabs TOOLS = new CreativeTabs(7, "tools"){

        @Override
        public Item getTabIconItem() {
            return Items.IRON_AXE;
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.DIGGER, EnumEnchantmentType.FISHING_ROD, EnumEnchantmentType.BREAKABLE);
    public static final CreativeTabs COMBAT = new CreativeTabs(8, "combat"){

        @Override
        public Item getTabIconItem() {
            return Items.GOLDEN_SWORD;
        }
    }.setRelevantEnchantmentTypes(EnumEnchantmentType.ARMOR, EnumEnchantmentType.ARMOR_FEET, EnumEnchantmentType.ARMOR_HEAD, EnumEnchantmentType.ARMOR_LEGS, EnumEnchantmentType.ARMOR_CHEST, EnumEnchantmentType.BOW, EnumEnchantmentType.WEAPON);
    public static final CreativeTabs BREWING = new CreativeTabs(9, "brewing"){

        @Override
        public Item getTabIconItem() {
            return Items.POTIONITEM;
        }
    };
    public static final CreativeTabs MATERIALS = new CreativeTabs(10, "materials"){

        @Override
        public Item getTabIconItem() {
            return Items.STICK;
        }
    };
    public static final CreativeTabs INVENTORY = new CreativeTabs(11, "inventory"){

        @Override
        public Item getTabIconItem() {
            return Item.getItemFromBlock(Blocks.CHEST);
        }
    }.setBackgroundImageName("inventory.png").setNoScrollbar().setNoTitle();
    private final int tabIndex;
    private final String tabLabel;
    private String theTexture = "items.png";
    private boolean hasScrollbar = true;
    private boolean drawTitle = true;
    private EnumEnchantmentType[] enchantmentTypes;
    private ItemStack iconItemStack;

    public CreativeTabs(int index, String label) {
        this.tabIndex = index;
        this.tabLabel = label;
        CreativeTabs.CREATIVE_TAB_ARRAY[index] = this;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public String getTabLabel() {
        return this.tabLabel;
    }

    public String getTranslatedTabLabel() {
        return "itemGroup." + this.getTabLabel();
    }

    public ItemStack getIconItemStack() {
        if (this.iconItemStack == null) {
            this.iconItemStack = new ItemStack(this.getTabIconItem(), 1, this.getIconItemDamage());
        }
        return this.iconItemStack;
    }

    public abstract Item getTabIconItem();

    public int getIconItemDamage() {
        return 0;
    }

    public String getBackgroundImageName() {
        return this.theTexture;
    }

    public CreativeTabs setBackgroundImageName(String texture) {
        this.theTexture = texture;
        return this;
    }

    public boolean drawInForegroundOfTab() {
        return this.drawTitle;
    }

    public CreativeTabs setNoTitle() {
        this.drawTitle = false;
        return this;
    }

    public boolean shouldHidePlayerInventory() {
        return this.hasScrollbar;
    }

    public CreativeTabs setNoScrollbar() {
        this.hasScrollbar = false;
        return this;
    }

    public int getTabColumn() {
        return this.tabIndex % 6;
    }

    public boolean isTabInFirstRow() {
        return this.tabIndex < 6;
    }

    public EnumEnchantmentType[] getRelevantEnchantmentTypes() {
        return this.enchantmentTypes;
    }

    public CreativeTabs setRelevantEnchantmentTypes(EnumEnchantmentType ... types) {
        this.enchantmentTypes = types;
        return this;
    }

    public boolean hasRelevantEnchantmentType(EnumEnchantmentType enchantmentType) {
        if (this.enchantmentTypes == null) {
            return false;
        }
        EnumEnchantmentType[] enumEnchantmentTypeArray = this.enchantmentTypes;
        int n = this.enchantmentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EnumEnchantmentType enumenchantmenttype = enumEnchantmentTypeArray[n2];
            if (enumenchantmenttype == enchantmentType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void displayAllRelevantItems(List<ItemStack> p_78018_1_) {
        for (Item item : Item.REGISTRY) {
            if (item == null || item.getCreativeTab() != this) continue;
            item.getSubItems(item, this, p_78018_1_);
        }
        if (this.getRelevantEnchantmentTypes() != null) {
            this.addEnchantmentBooksToList(p_78018_1_, this.getRelevantEnchantmentTypes());
        }
    }

    public void addEnchantmentBooksToList(List<ItemStack> itemList, EnumEnchantmentType ... enchantmentType) {
        for (Enchantment enchantment : Enchantment.REGISTRY) {
            if (enchantment == null || enchantment.type == null) continue;
            boolean flag = false;
            int i = 0;
            while (i < enchantmentType.length && !flag) {
                if (enchantment.type == enchantmentType[i]) {
                    flag = true;
                }
                ++i;
            }
            if (!flag) continue;
            itemList.add(Items.ENCHANTED_BOOK.getEnchantedItemStack(new EnchantmentData(enchantment, enchantment.getMaxLevel())));
        }
    }
}

