/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.base.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityItem
extends Entity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DataParameter<Optional<ItemStack>> ITEM = EntityDataManager.createKey(EntityItem.class, DataSerializers.OPTIONAL_ITEM_STACK);
    private int age;
    private int delayBeforeCanPickup;
    private int health = 5;
    private String thrower;
    private String owner;
    public float hoverStart = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World worldIn, double x, double y, double z) {
        super(worldIn);
        this.setSize(0.25f, 0.25f);
        this.setPosition(x, y, z);
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motionY = 0.2f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    public EntityItem(World worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn, x, y, z);
        this.setEntityItemStack(stack);
    }

    @Override
    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityItem(World worldIn) {
        super(worldIn);
        this.setSize(0.25f, 0.25f);
        this.setEntityItemStack(new ItemStack(Blocks.AIR, 0));
    }

    @Override
    protected void entityInit() {
        this.getDataManager().register(ITEM, Optional.absent());
    }

    @Override
    public void onUpdate() {
        if (this.getEntityItem() == null) {
            this.setDead();
        } else {
            boolean flag;
            super.onUpdate();
            if (this.delayBeforeCanPickup > 0 && this.delayBeforeCanPickup != Short.MAX_VALUE) {
                --this.delayBeforeCanPickup;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            if (!this.func_189652_ae()) {
                this.motionY -= (double)0.04f;
            }
            this.noClip = this.pushOutOfBlocks(this.posX, (this.getEntityBoundingBox().minY + this.getEntityBoundingBox().maxY) / 2.0, this.posZ);
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            boolean bl = flag = (int)this.prevPosX != (int)this.posX || (int)this.prevPosY != (int)this.posY || (int)this.prevPosZ != (int)this.posZ;
            if (flag || this.ticksExisted % 25 == 0) {
                if (this.worldObj.getBlockState(new BlockPos(this)).getMaterial() == Material.LAVA) {
                    this.motionY = 0.2f;
                    this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
                    this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
                    this.playSound(SoundEvents.ENTITY_GENERIC_BURN, 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
                }
                if (!this.worldObj.isRemote) {
                    this.searchForOtherItemsNearby();
                }
            }
            float f = 0.98f;
            if (this.onGround) {
                f = this.worldObj.getBlockState((BlockPos)new BlockPos((int)MathHelper.floor_double((double)this.posX), (int)(MathHelper.floor_double((double)this.getEntityBoundingBox().minY) - 1), (int)MathHelper.floor_double((double)this.posZ))).getBlock().slipperiness * 0.98f;
            }
            this.motionX *= (double)f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)f;
            if (this.onGround) {
                this.motionY *= -0.5;
            }
            if (this.age != Short.MIN_VALUE) {
                ++this.age;
            }
            this.handleWaterMovement();
            if (!this.worldObj.isRemote && this.age >= 6000) {
                this.setDead();
            }
        }
    }

    private void searchForOtherItemsNearby() {
        for (EntityItem entityitem : this.worldObj.getEntitiesWithinAABB(EntityItem.class, this.getEntityBoundingBox().expand(0.5, 0.0, 0.5))) {
            this.combineItems(entityitem);
        }
    }

    private boolean combineItems(EntityItem other) {
        if (other == this) {
            return false;
        }
        if (other.isEntityAlive() && this.isEntityAlive()) {
            ItemStack itemstack = this.getEntityItem();
            ItemStack itemstack1 = other.getEntityItem();
            if (this.delayBeforeCanPickup != Short.MAX_VALUE && other.delayBeforeCanPickup != Short.MAX_VALUE) {
                if (this.age != Short.MIN_VALUE && other.age != Short.MIN_VALUE) {
                    if (itemstack1.getItem() != itemstack.getItem()) {
                        return false;
                    }
                    if (itemstack1.hasTagCompound() ^ itemstack.hasTagCompound()) {
                        return false;
                    }
                    if (itemstack1.hasTagCompound() && !itemstack1.getTagCompound().equals(itemstack.getTagCompound())) {
                        return false;
                    }
                    if (itemstack1.getItem() == null) {
                        return false;
                    }
                    if (itemstack1.getItem().getHasSubtypes() && itemstack1.getMetadata() != itemstack.getMetadata()) {
                        return false;
                    }
                    if (itemstack1.stackSize < itemstack.stackSize) {
                        return other.combineItems(this);
                    }
                    if (itemstack1.stackSize + itemstack.stackSize > itemstack1.getMaxStackSize()) {
                        return false;
                    }
                    itemstack1.stackSize += itemstack.stackSize;
                    other.delayBeforeCanPickup = Math.max(other.delayBeforeCanPickup, this.delayBeforeCanPickup);
                    other.age = Math.min(other.age, this.age);
                    other.setEntityItemStack(itemstack1);
                    this.setDead();
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void setAgeToCreativeDespawnTime() {
        this.age = 4800;
    }

    @Override
    public boolean handleWaterMovement() {
        if (this.worldObj.handleMaterialAcceleration(this.getEntityBoundingBox(), Material.WATER, this)) {
            if (!this.inWater && !this.firstUpdate) {
                this.resetHeight();
            }
            this.inWater = true;
        } else {
            this.inWater = false;
        }
        return this.inWater;
    }

    @Override
    protected void dealFireDamage(int amount) {
        this.attackEntityFrom(DamageSource.inFire, amount);
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (this.isEntityInvulnerable(source)) {
            return false;
        }
        if (this.getEntityItem() != null && this.getEntityItem().getItem() == Items.NETHER_STAR && source.isExplosion()) {
            return false;
        }
        this.setBeenAttacked();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.setDead();
        }
        return false;
    }

    public static void func_189742_a(DataFixer p_189742_0_) {
        p_189742_0_.registerWalker(FixTypes.ENTITY, new ItemStackData("Item", new String[]{"Item"}));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.setShort("Health", (short)this.health);
        compound.setShort("Age", (short)this.age);
        compound.setShort("PickupDelay", (short)this.delayBeforeCanPickup);
        if (this.getThrower() != null) {
            compound.setString("Thrower", this.thrower);
        }
        if (this.getOwner() != null) {
            compound.setString("Owner", this.owner);
        }
        if (this.getEntityItem() != null) {
            compound.setTag("Item", this.getEntityItem().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.health = compound.getShort("Health");
        this.age = compound.getShort("Age");
        if (compound.hasKey("PickupDelay")) {
            this.delayBeforeCanPickup = compound.getShort("PickupDelay");
        }
        if (compound.hasKey("Owner")) {
            this.owner = compound.getString("Owner");
        }
        if (compound.hasKey("Thrower")) {
            this.thrower = compound.getString("Thrower");
        }
        NBTTagCompound nbttagcompound = compound.getCompoundTag("Item");
        this.setEntityItemStack(ItemStack.loadItemStackFromNBT(nbttagcompound));
        if (this.getEntityItem() == null) {
            this.setDead();
        }
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer entityIn) {
        if (!this.worldObj.isRemote) {
            ItemStack itemstack = this.getEntityItem();
            int i = itemstack.stackSize;
            if (this.delayBeforeCanPickup == 0 && (this.owner == null || 6000 - this.age <= 200 || this.owner.equals(entityIn.getName())) && entityIn.inventory.addItemStackToInventory(itemstack)) {
                EntityPlayer entityplayer;
                if (itemstack.getItem() == Item.getItemFromBlock(Blocks.LOG)) {
                    entityIn.addStat(AchievementList.MINE_WOOD);
                }
                if (itemstack.getItem() == Item.getItemFromBlock(Blocks.LOG2)) {
                    entityIn.addStat(AchievementList.MINE_WOOD);
                }
                if (itemstack.getItem() == Items.LEATHER) {
                    entityIn.addStat(AchievementList.KILL_COW);
                }
                if (itemstack.getItem() == Items.DIAMOND) {
                    entityIn.addStat(AchievementList.DIAMONDS);
                }
                if (itemstack.getItem() == Items.BLAZE_ROD) {
                    entityIn.addStat(AchievementList.BLAZE_ROD);
                }
                if (itemstack.getItem() == Items.DIAMOND && this.getThrower() != null && (entityplayer = this.worldObj.getPlayerEntityByName(this.getThrower())) != null && entityplayer != entityIn) {
                    entityplayer.addStat(AchievementList.DIAMONDS_TO_YOU);
                }
                if (!this.isSilent()) {
                    this.worldObj.playSound(null, entityIn.posX, entityIn.posY, entityIn.posZ, SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                entityIn.onItemPickup(this, i);
                if (itemstack.stackSize <= 0) {
                    this.setDead();
                }
                entityIn.addStat(StatList.getObjectsPickedUpStats(itemstack.getItem()), i);
            }
        }
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getCustomNameTag() : I18n.translateToLocal("item." + this.getEntityItem().getUnlocalizedName());
    }

    @Override
    public boolean canBeAttackedWithItem() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(int dimensionIn) {
        Entity entity = super.changeDimension(dimensionIn);
        if (!this.worldObj.isRemote && entity instanceof EntityItem) {
            ((EntityItem)entity).searchForOtherItemsNearby();
        }
        return entity;
    }

    public ItemStack getEntityItem() {
        ItemStack itemstack = (ItemStack)this.getDataManager().get(ITEM).orNull();
        if (itemstack == null) {
            if (this.worldObj != null) {
                LOGGER.error("Item entity {} has no item?!", new Object[]{this.getEntityId()});
            }
            return new ItemStack(Blocks.STONE);
        }
        return itemstack;
    }

    public void setEntityItemStack(@Nullable ItemStack stack) {
        this.getDataManager().set(ITEM, Optional.fromNullable((Object)stack));
        this.getDataManager().setDirty(ITEM);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getThrower() {
        return this.thrower;
    }

    public void setThrower(String thrower) {
        this.thrower = thrower;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickupDelay() {
        this.delayBeforeCanPickup = 10;
    }

    public void setNoPickupDelay() {
        this.delayBeforeCanPickup = 0;
    }

    public void setInfinitePickupDelay() {
        this.delayBeforeCanPickup = Short.MAX_VALUE;
    }

    public void setPickupDelay(int ticks) {
        this.delayBeforeCanPickup = ticks;
    }

    public boolean cannotPickup() {
        return this.delayBeforeCanPickup > 0;
    }

    public void setNoDespawn() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setInfinitePickupDelay();
        this.age = 5999;
    }
}

