/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class InventoryPlayer
implements IInventory {
    public final ItemStack[] mainInventory = new ItemStack[36];
    public final ItemStack[] armorInventory = new ItemStack[4];
    public final ItemStack[] offHandInventory = new ItemStack[1];
    private final ItemStack[][] allInventories = new ItemStack[][]{this.mainInventory, this.armorInventory, this.offHandInventory};
    public int currentItem;
    public EntityPlayer player;
    private ItemStack itemStack;
    public boolean inventoryChanged;

    public InventoryPlayer(EntityPlayer playerIn) {
        this.player = playerIn;
    }

    @Nullable
    public ItemStack getCurrentItem() {
        return InventoryPlayer.isHotbar(this.currentItem) ? this.mainInventory[this.currentItem] : null;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private boolean canMergeStacks(@Nullable ItemStack stack1, ItemStack stack2) {
        return stack1 != null && this.stackEqualExact(stack1, stack2) && stack1.isStackable() && stack1.stackSize < stack1.getMaxStackSize() && stack1.stackSize < this.getInventoryStackLimit();
    }

    private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.getItem() == stack2.getItem() && (!stack1.getHasSubtypes() || stack1.getMetadata() == stack2.getMetadata()) && ItemStack.areItemStackTagsEqual(stack1, stack2);
    }

    public int getFirstEmptyStack() {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] == null) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPickedItemStack(ItemStack stack) {
        int i = this.getSlotFor(stack);
        if (InventoryPlayer.isHotbar(i)) {
            this.currentItem = i;
        } else if (i == -1) {
            int j;
            this.currentItem = this.getBestHotbarSlot();
            if (this.mainInventory[this.currentItem] != null && (j = this.getFirstEmptyStack()) != -1) {
                this.mainInventory[j] = this.mainInventory[this.currentItem];
            }
            this.mainInventory[this.currentItem] = stack;
        } else {
            this.pickItem(i);
        }
    }

    public void pickItem(int index) {
        this.currentItem = this.getBestHotbarSlot();
        ItemStack itemstack = this.mainInventory[this.currentItem];
        this.mainInventory[this.currentItem] = this.mainInventory[index];
        this.mainInventory[index] = itemstack;
    }

    public static boolean isHotbar(int index) {
        return index >= 0 && index < 9;
    }

    public int getSlotFor(ItemStack stack) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null && this.stackEqualExact(stack, this.mainInventory[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getBestHotbarSlot() {
        int i = 0;
        while (i < 9) {
            int j = (this.currentItem + i) % 9;
            if (this.mainInventory[j] == null) {
                return j;
            }
            ++i;
        }
        int k = 0;
        while (k < 9) {
            int l = (this.currentItem + k) % 9;
            if (!this.mainInventory[l].isItemEnchanted()) {
                return l;
            }
            ++k;
        }
        return this.currentItem;
    }

    public void changeCurrentItem(int direction) {
        if (direction > 0) {
            direction = 1;
        }
        if (direction < 0) {
            direction = -1;
        }
        this.currentItem -= direction;
        while (this.currentItem < 0) {
            this.currentItem += 9;
        }
        while (this.currentItem >= 9) {
            this.currentItem -= 9;
        }
    }

    public int clearMatchingItems(@Nullable Item itemIn, int metadataIn, int removeCount, @Nullable NBTTagCompound itemNBT) {
        int i = 0;
        int j = 0;
        while (j < this.getSizeInventory()) {
            ItemStack itemstack = this.getStackInSlot(j);
            if (!(itemstack == null || itemIn != null && itemstack.getItem() != itemIn || metadataIn > -1 && itemstack.getMetadata() != metadataIn || itemNBT != null && !NBTUtil.areNBTEquals(itemNBT, itemstack.getTagCompound(), true))) {
                int k = removeCount <= 0 ? itemstack.stackSize : Math.min(removeCount - i, itemstack.stackSize);
                i += k;
                if (removeCount != 0) {
                    itemstack.stackSize -= k;
                    if (itemstack.stackSize == 0) {
                        this.setInventorySlotContents(j, null);
                    }
                    if (removeCount > 0 && i >= removeCount) {
                        return i;
                    }
                }
            }
            ++j;
        }
        if (this.itemStack != null) {
            if (itemIn != null && this.itemStack.getItem() != itemIn) {
                return i;
            }
            if (metadataIn > -1 && this.itemStack.getMetadata() != metadataIn) {
                return i;
            }
            if (itemNBT != null && !NBTUtil.areNBTEquals(itemNBT, this.itemStack.getTagCompound(), true)) {
                return i;
            }
            int l = removeCount <= 0 ? this.itemStack.stackSize : Math.min(removeCount - i, this.itemStack.stackSize);
            i += l;
            if (removeCount != 0) {
                this.itemStack.stackSize -= l;
                if (this.itemStack.stackSize == 0) {
                    this.itemStack = null;
                }
                if (removeCount > 0 && i >= removeCount) {
                    return i;
                }
            }
        }
        return i;
    }

    private int storePartialItemStack(ItemStack itemStackIn) {
        Item item = itemStackIn.getItem();
        int i = itemStackIn.stackSize;
        int j = this.storeItemStack(itemStackIn);
        if (j == -1) {
            j = this.getFirstEmptyStack();
        }
        if (j == -1) {
            return i;
        }
        ItemStack itemstack = this.getStackInSlot(j);
        if (itemstack == null) {
            itemstack = new ItemStack(item, 0, itemStackIn.getMetadata());
            if (itemStackIn.hasTagCompound()) {
                itemstack.setTagCompound(itemStackIn.getTagCompound().copy());
            }
            this.setInventorySlotContents(j, itemstack);
        }
        int k = i;
        if (i > itemstack.getMaxStackSize() - itemstack.stackSize) {
            k = itemstack.getMaxStackSize() - itemstack.stackSize;
        }
        if (k > this.getInventoryStackLimit() - itemstack.stackSize) {
            k = this.getInventoryStackLimit() - itemstack.stackSize;
        }
        if (k == 0) {
            return i;
        }
        itemstack.stackSize += k;
        itemstack.animationsToGo = 5;
        return i -= k;
    }

    private int storeItemStack(ItemStack itemStackIn) {
        if (this.canMergeStacks(this.getStackInSlot(this.currentItem), itemStackIn)) {
            return this.currentItem;
        }
        if (this.canMergeStacks(this.getStackInSlot(40), itemStackIn)) {
            return 40;
        }
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.canMergeStacks(this.mainInventory[i], itemStackIn)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void decrementAnimations() {
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] != null) {
                    aitemstack[i].updateAnimation(this.player.worldObj, this.player, i, this.currentItem == i);
                }
                ++i;
            }
            ++n2;
        }
    }

    public boolean addItemStackToInventory(final @Nullable ItemStack itemStackIn) {
        if (itemStackIn != null && itemStackIn.stackSize != 0 && itemStackIn.getItem() != null) {
            int i;
            block10: {
                block8: {
                    block9: {
                        if (!itemStackIn.isItemDamaged()) break block8;
                        int j = this.getFirstEmptyStack();
                        if (j < 0) break block9;
                        this.mainInventory[j] = ItemStack.copyItemStack(itemStackIn);
                        this.mainInventory[j].animationsToGo = 5;
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    if (this.player.capabilities.isCreativeMode) {
                        itemStackIn.stackSize = 0;
                        return true;
                    }
                    return false;
                }
                try {
                    do {
                        i = itemStackIn.stackSize;
                        itemStackIn.stackSize = this.storePartialItemStack(itemStackIn);
                    } while (itemStackIn.stackSize > 0 && itemStackIn.stackSize < i);
                    if (itemStackIn.stackSize != i || !this.player.capabilities.isCreativeMode) break block10;
                    itemStackIn.stackSize = 0;
                    return true;
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.makeCrashReport(throwable, "Adding item to inventory");
                    CrashReportCategory crashreportcategory = crashreport.makeCategory("Item being added");
                    crashreportcategory.addCrashSection("Item ID", Item.getIdFromItem(itemStackIn.getItem()));
                    crashreportcategory.addCrashSection("Item data", itemStackIn.getMetadata());
                    crashreportcategory.addCrashSectionCallable("Item name", new ICrashReportDetail<String>(){

                        @Override
                        public String call() throws Exception {
                            return itemStackIn.getDisplayName();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
            }
            return itemStackIn.stackSize < i;
        }
        return false;
    }

    @Override
    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        return aitemstack != null && aitemstack[index] != null ? ItemStackHelper.getAndSplit(aitemstack, index, count) : null;
    }

    public void deleteStack(ItemStack stack) {
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] == stack) {
                    aitemstack[i] = null;
                    break;
                }
                ++i;
            }
            ++n2;
        }
    }

    @Override
    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        if (aitemstack != null && aitemstack[index] != null) {
            void itemstack = aitemstack[index];
            aitemstack[index] = null;
            return itemstack;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        if (aitemstack != null) {
            aitemstack[index] = stack;
        }
    }

    public float getStrVsBlock(IBlockState state) {
        float f = 1.0f;
        if (this.mainInventory[this.currentItem] != null) {
            f *= this.mainInventory[this.currentItem].getStrVsBlock(state);
        }
        return f;
    }

    public NBTTagList writeToNBT(NBTTagList nbtTagListIn) {
        int i = 0;
        while (i < this.mainInventory.length) {
            if (this.mainInventory[i] != null) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.setByte("Slot", (byte)i);
                this.mainInventory[i].writeToNBT(nbttagcompound);
                nbtTagListIn.appendTag(nbttagcompound);
            }
            ++i;
        }
        int j = 0;
        while (j < this.armorInventory.length) {
            if (this.armorInventory[j] != null) {
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.setByte("Slot", (byte)(j + 100));
                this.armorInventory[j].writeToNBT(nbttagcompound1);
                nbtTagListIn.appendTag(nbttagcompound1);
            }
            ++j;
        }
        int k = 0;
        while (k < this.offHandInventory.length) {
            if (this.offHandInventory[k] != null) {
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.setByte("Slot", (byte)(k + 150));
                this.offHandInventory[k].writeToNBT(nbttagcompound2);
                nbtTagListIn.appendTag(nbttagcompound2);
            }
            ++k;
        }
        return nbtTagListIn;
    }

    public void readFromNBT(NBTTagList nbtTagListIn) {
        Arrays.fill(this.mainInventory, null);
        Arrays.fill(this.armorInventory, null);
        Arrays.fill(this.offHandInventory, null);
        int i = 0;
        while (i < nbtTagListIn.tagCount()) {
            NBTTagCompound nbttagcompound = nbtTagListIn.getCompoundTagAt(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.loadItemStackFromNBT(nbttagcompound);
            if (itemstack != null) {
                if (j >= 0 && j < this.mainInventory.length) {
                    this.mainInventory[j] = itemstack;
                } else if (j >= 100 && j < this.armorInventory.length + 100) {
                    this.armorInventory[j - 100] = itemstack;
                } else if (j >= 150 && j < this.offHandInventory.length + 150) {
                    this.offHandInventory[j - 150] = itemstack;
                }
            }
            ++i;
        }
    }

    @Override
    public int getSizeInventory() {
        return this.mainInventory.length + this.armorInventory.length + this.offHandInventory.length;
    }

    @Override
    @Nullable
    public ItemStack getStackInSlot(int index) {
        ItemStack[] aitemstack = null;
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack1 = itemStackArray[n2];
            if (index < aitemstack1.length) {
                aitemstack = aitemstack1;
                break;
            }
            index -= aitemstack1.length;
            ++n2;
        }
        return aitemstack == null ? null : aitemstack[index];
    }

    @Override
    public String getName() {
        return "container.inventory";
    }

    @Override
    public boolean hasCustomName() {
        return false;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean canHarvestBlock(IBlockState state) {
        if (state.getMaterial().isToolNotRequired()) {
            return true;
        }
        ItemStack itemstack = this.getStackInSlot(this.currentItem);
        return itemstack != null ? itemstack.canHarvestBlock(state) : false;
    }

    public ItemStack armorItemInSlot(int slotIn) {
        return this.armorInventory[slotIn];
    }

    public void damageArmor(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        int i = 0;
        while (i < this.armorInventory.length) {
            if (this.armorInventory[i] != null && this.armorInventory[i].getItem() instanceof ItemArmor) {
                this.armorInventory[i].damageItem((int)damage, this.player);
                if (this.armorInventory[i].stackSize == 0) {
                    this.armorInventory[i] = null;
                }
            }
            ++i;
        }
    }

    public void dropAllItems() {
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                if (aitemstack[i] != null) {
                    this.player.dropItem(aitemstack[i], true, false);
                    aitemstack[i] = null;
                }
                ++i;
            }
            ++n2;
        }
    }

    @Override
    public void markDirty() {
        this.inventoryChanged = true;
    }

    public void setItemStack(@Nullable ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
    }

    @Nullable
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.player.isDead ? false : player.getDistanceSqToEntity(this.player) <= 64.0;
    }

    public boolean hasItemStack(ItemStack itemStackIn) {
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack;
            ItemStack[] itemStackArray2 = aitemstack = itemStackArray[n2];
            int n3 = aitemstack.length;
            int n4 = 0;
            while (n4 < n3) {
                ItemStack itemstack = itemStackArray2[n4];
                if (itemstack != null && itemstack.isItemEqual(itemStackIn)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void copyInventory(InventoryPlayer playerInventory) {
        int i = 0;
        while (i < this.getSizeInventory()) {
            this.setInventorySlotContents(i, playerInventory.getStackInSlot(i));
            ++i;
        }
        this.currentItem = playerInventory.currentItem;
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        ItemStack[][] itemStackArray = this.allInventories;
        int n = this.allInventories.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack[] aitemstack = itemStackArray[n2];
            int i = 0;
            while (i < aitemstack.length) {
                aitemstack[i] = null;
                ++i;
            }
            ++n2;
        }
    }
}

