/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemMonsterPlacer
extends Item {
    public ItemMonsterPlacer() {
        this.setCreativeTab(CreativeTabs.MISC);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        String s = I18n.translateToLocal(String.valueOf(this.getUnlocalizedName()) + ".name").trim();
        String s1 = ItemMonsterPlacer.getEntityIdFromItem(stack);
        if (s1 != null) {
            s = String.valueOf(s) + " " + I18n.translateToLocal("entity." + s1 + ".name");
        }
        return s;
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Entity entity;
        TileEntity tileentity;
        if (worldIn.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.canPlayerEdit(pos.offset(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.getBlockState(pos);
        if (iblockstate.getBlock() == Blocks.MOB_SPAWNER && (tileentity = worldIn.getTileEntity(pos)) instanceof TileEntityMobSpawner) {
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileentity).getSpawnerBaseLogic();
            mobspawnerbaselogic.setEntityName(ItemMonsterPlacer.getEntityIdFromItem(stack));
            tileentity.markDirty();
            worldIn.notifyBlockUpdate(pos, iblockstate, iblockstate, 3);
            if (!playerIn.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
            return EnumActionResult.SUCCESS;
        }
        pos = pos.offset(facing);
        double d0 = 0.0;
        if (facing == EnumFacing.UP && iblockstate instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = ItemMonsterPlacer.spawnCreature(worldIn, ItemMonsterPlacer.getEntityIdFromItem(stack), (double)pos.getX() + 0.5, (double)pos.getY() + d0, (double)pos.getZ() + 0.5)) != null) {
            if (entity instanceof EntityLivingBase && stack.hasDisplayName()) {
                entity.setCustomNameTag(stack.getDisplayName());
            }
            ItemMonsterPlacer.applyItemEntityDataToEntity(worldIn, playerIn, stack, entity);
            if (!playerIn.capabilities.isCreativeMode) {
                --stack.stackSize;
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.getMinecraftServer();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.getTagCompound()) != null && nbttagcompound.hasKey("EntityTag", 10)) {
            if (!(entityWorld.isRemote || !targetEntity.ignoreItemEntityData() || player != null && minecraftserver.getPlayerList().canSendCommands(player.getGameProfile()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.getUniqueID();
            nbttagcompound1.merge(nbttagcompound.getCompoundTag("EntityTag"));
            targetEntity.setUniqueId(uuid);
            targetEntity.readFromNBT(nbttagcompound1);
        }
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.isRemote) {
            return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
        }
        RayTraceResult raytraceresult = this.rayTrace(worldIn, playerIn, true);
        if (raytraceresult != null && raytraceresult.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.getBlockPos();
            if (!(worldIn.getBlockState(blockpos).getBlock() instanceof BlockLiquid)) {
                return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
            }
            if (worldIn.isBlockModifiable(playerIn, blockpos) && playerIn.canPlayerEdit(blockpos, raytraceresult.sideHit, itemStackIn)) {
                Entity entity = ItemMonsterPlacer.spawnCreature(worldIn, ItemMonsterPlacer.getEntityIdFromItem(itemStackIn), (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5);
                if (entity == null) {
                    return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
                }
                if (entity instanceof EntityLivingBase && itemStackIn.hasDisplayName()) {
                    entity.setCustomNameTag(itemStackIn.getDisplayName());
                }
                ItemMonsterPlacer.applyItemEntityDataToEntity(worldIn, playerIn, itemStackIn, entity);
                if (!playerIn.capabilities.isCreativeMode) {
                    --itemStackIn.stackSize;
                }
                playerIn.addStat(StatList.getObjectUseStats(this));
                return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStackIn);
            }
            return new ActionResult<ItemStack>(EnumActionResult.FAIL, itemStackIn);
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, itemStackIn);
    }

    @Nullable
    public static Entity spawnCreature(World worldIn, @Nullable String entityID, double x, double y, double z) {
        if (entityID != null && EntityList.ENTITY_EGGS.containsKey(entityID)) {
            Entity entity = null;
            int i = 0;
            while (i < 1) {
                entity = EntityList.createEntityByIDFromName(entityID, worldIn);
                if (entity instanceof EntityLivingBase) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    entity.setLocationAndAngles(x, y, z, MathHelper.wrapDegrees(worldIn.rand.nextFloat() * 360.0f), 0.0f);
                    entityliving.rotationYawHead = entityliving.rotationYaw;
                    entityliving.renderYawOffset = entityliving.rotationYaw;
                    entityliving.onInitialSpawn(worldIn.getDifficultyForLocation(new BlockPos(entityliving)), null);
                    worldIn.spawnEntityInWorld(entity);
                    entityliving.playLivingSound();
                }
                ++i;
            }
            return entity;
        }
        return null;
    }

    @Override
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (EntityList.EntityEggInfo entitylist$entityegginfo : EntityList.ENTITY_EGGS.values()) {
            ItemStack itemstack = new ItemStack(itemIn, 1);
            ItemMonsterPlacer.applyEntityIdToItemStack(itemstack, entitylist$entityegginfo.spawnedID);
            subItems.add(itemstack);
        }
    }

    public static void applyEntityIdToItemStack(ItemStack stack, String entityId) {
        NBTTagCompound nbttagcompound = stack.hasTagCompound() ? stack.getTagCompound() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.setString("id", entityId);
        nbttagcompound.setTag("EntityTag", nbttagcompound1);
        stack.setTagCompound(nbttagcompound);
    }

    @Nullable
    public static String getEntityIdFromItem(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.getTagCompound();
        if (nbttagcompound == null) {
            return null;
        }
        if (!nbttagcompound.hasKey("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.getCompoundTag("EntityTag");
        return !nbttagcompound1.hasKey("id", 8) ? null : nbttagcompound1.getString("id");
    }
}

