/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.World;

public class ShieldRecipes {
    public void addRecipes(CraftingManager manager) {
        manager.addRecipe(new ItemStack(Items.SHIELD), "WoW", "WWW", " W ", Character.valueOf('W'), Blocks.PLANKS, Character.valueOf('o'), Items.IRON_INGOT);
        manager.addRecipe(new Decoration());
    }

    static class Decoration
    implements IRecipe {
        private Decoration() {
        }

        @Override
        public boolean matches(InventoryCrafting inv, World worldIn) {
            ItemStack itemstack = null;
            ItemStack itemstack1 = null;
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack2 = inv.getStackInSlot(i);
                if (itemstack2 != null) {
                    if (itemstack2.getItem() == Items.BANNER) {
                        if (itemstack1 != null) {
                            return false;
                        }
                        itemstack1 = itemstack2;
                    } else {
                        if (itemstack2.getItem() != Items.SHIELD) {
                            return false;
                        }
                        if (itemstack != null) {
                            return false;
                        }
                        if (itemstack2.getSubCompound("BlockEntityTag", false) != null) {
                            return false;
                        }
                        itemstack = itemstack2;
                    }
                }
                ++i;
            }
            return itemstack != null && itemstack1 != null;
        }

        @Override
        @Nullable
        public ItemStack getCraftingResult(InventoryCrafting inv) {
            EnumDyeColor enumdyecolor;
            NBTTagCompound nbttagcompound;
            ItemStack itemstack = null;
            int i = 0;
            while (i < inv.getSizeInventory()) {
                ItemStack itemstack1 = inv.getStackInSlot(i);
                if (itemstack1 != null && itemstack1.getItem() == Items.BANNER) {
                    itemstack = itemstack1;
                }
                ++i;
            }
            ItemStack itemstack2 = new ItemStack(Items.SHIELD, 1, 0);
            if (itemstack.hasTagCompound()) {
                nbttagcompound = itemstack.getTagCompound().copy();
                enumdyecolor = EnumDyeColor.byDyeDamage(TileEntityBanner.getBaseColor(itemstack));
            } else {
                nbttagcompound = new NBTTagCompound();
                enumdyecolor = EnumDyeColor.byDyeDamage(itemstack.getItemDamage());
            }
            itemstack2.setTagCompound(nbttagcompound);
            TileEntityBanner.addBaseColorTag(itemstack2, enumdyecolor);
            return itemstack2;
        }

        @Override
        public int getRecipeSize() {
            return 2;
        }

        @Override
        @Nullable
        public ItemStack getRecipeOutput() {
            return null;
        }

        @Override
        public ItemStack[] getRemainingItems(InventoryCrafting inv) {
            ItemStack[] aitemstack = new ItemStack[inv.getSizeInventory()];
            int i = 0;
            while (i < aitemstack.length) {
                ItemStack itemstack = inv.getStackInSlot(i);
                if (itemstack != null && itemstack.getItem().hasContainerItem()) {
                    aitemstack[i] = new ItemStack(itemstack.getItem().getContainerItem());
                }
                ++i;
            }
            return aitemstack;
        }
    }
}

