/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackDataLists;

public class TileEntityDispenser
extends TileEntityLockableLoot
implements IInventory {
    private static final Random RNG = new Random();
    private ItemStack[] stacks = new ItemStack[9];
    protected String customName;

    @Override
    public int getSizeInventory() {
        return 9;
    }

    @Override
    @Nullable
    public ItemStack getStackInSlot(int index) {
        this.fillWithLoot(null);
        return this.stacks[index];
    }

    @Override
    @Nullable
    public ItemStack decrStackSize(int index, int count) {
        this.fillWithLoot(null);
        ItemStack itemstack = ItemStackHelper.getAndSplit(this.stacks, index, count);
        if (itemstack != null) {
            this.markDirty();
        }
        return itemstack;
    }

    @Override
    @Nullable
    public ItemStack removeStackFromSlot(int index) {
        this.fillWithLoot(null);
        return ItemStackHelper.getAndRemove(this.stacks, index);
    }

    public int getDispenseSlot() {
        this.fillWithLoot(null);
        int i = -1;
        int j = 1;
        int k = 0;
        while (k < this.stacks.length) {
            if (this.stacks[k] != null && RNG.nextInt(j++) == 0) {
                i = k;
            }
            ++k;
        }
        return i;
    }

    @Override
    public void setInventorySlotContents(int index, @Nullable ItemStack stack) {
        this.fillWithLoot(null);
        this.stacks[index] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public int addItemStack(ItemStack stack) {
        int i = 0;
        while (i < this.stacks.length) {
            if (this.stacks[i] == null || this.stacks[i].getItem() == null) {
                this.setInventorySlotContents(i, stack);
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.customName : "container.dispenser";
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public boolean hasCustomName() {
        return this.customName != null;
    }

    public static void func_189678_a(DataFixer p_189678_0_) {
        p_189678_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackDataLists("Trap", new String[]{"Items"}));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (!this.checkLootAndRead(compound)) {
            NBTTagList nbttaglist = compound.getTagList("Items", 10);
            this.stacks = new ItemStack[this.getSizeInventory()];
            int i = 0;
            while (i < nbttaglist.tagCount()) {
                NBTTagCompound nbttagcompound = nbttaglist.getCompoundTagAt(i);
                int j = nbttagcompound.getByte("Slot") & 0xFF;
                if (j >= 0 && j < this.stacks.length) {
                    this.stacks[j] = ItemStack.loadItemStackFromNBT(nbttagcompound);
                }
                ++i;
            }
        }
        if (compound.hasKey("CustomName", 8)) {
            this.customName = compound.getString("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.checkLootAndWrite(p_189515_1_)) {
            NBTTagList nbttaglist = new NBTTagList();
            int i = 0;
            while (i < this.stacks.length) {
                if (this.stacks[i] != null) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.setByte("Slot", (byte)i);
                    this.stacks[i].writeToNBT(nbttagcompound);
                    nbttaglist.appendTag(nbttagcompound);
                }
                ++i;
            }
            p_189515_1_.setTag("Items", nbttaglist);
        }
        if (this.hasCustomName()) {
            p_189515_1_.setString("CustomName", this.customName);
        }
        return p_189515_1_;
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.pos) != this ? false : player.getDistanceSq((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    @Override
    public void openInventory(EntityPlayer player) {
    }

    @Override
    public void closeInventory(EntityPlayer player) {
    }

    @Override
    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    @Override
    public String getGuiID() {
        return "minecraft:dispenser";
    }

    @Override
    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.fillWithLoot(playerIn);
        return new ContainerDispenser(playerInventory, this);
    }

    @Override
    public int getField(int id) {
        return 0;
    }

    @Override
    public void setField(int id, int value) {
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.fillWithLoot(null);
        int i = 0;
        while (i < this.stacks.length) {
            this.stacks[i] = null;
            ++i;
        }
    }
}

