/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.math.MathHelper;

public class IntIdentityHashBiMap<K>
implements IObjectIntIterable<K>,
Iterable<K> {
    private static final Object EMPTY = null;
    private K[] keys;
    private int[] values;
    private K[] byId;
    private int nextFreeIndex;
    private int mapSize;

    public IntIdentityHashBiMap(int initialCapacity) {
        initialCapacity = (int)((float)initialCapacity / 0.8f);
        this.keys = new Object[initialCapacity];
        this.values = new int[initialCapacity];
        this.byId = new Object[initialCapacity];
    }

    public int getId(K p_186815_1_) {
        return this.getValue(this.getIndex(p_186815_1_, this.hashObject(p_186815_1_)));
    }

    @Nullable
    public K get(int idIn) {
        return idIn >= 0 && idIn < this.byId.length ? (K)this.byId[idIn] : null;
    }

    private int getValue(int p_186805_1_) {
        return p_186805_1_ == -1 ? -1 : this.values[p_186805_1_];
    }

    public int add(K objectIn) {
        int i = this.nextId();
        this.put(objectIn, i);
        return i;
    }

    private int nextId() {
        while (this.nextFreeIndex < this.byId.length && this.byId[this.nextFreeIndex] != null) {
            ++this.nextFreeIndex;
        }
        return this.nextFreeIndex;
    }

    private void grow(int capacity) {
        K[] ak = this.keys;
        int[] aint = this.values;
        this.keys = new Object[capacity];
        this.values = new int[capacity];
        this.byId = new Object[capacity];
        this.nextFreeIndex = 0;
        this.mapSize = 0;
        int i = 0;
        while (i < ak.length) {
            if (ak[i] != null) {
                this.put(ak[i], aint[i]);
            }
            ++i;
        }
    }

    public void put(K objectIn, int intKey) {
        int i = Math.max(intKey, this.mapSize + 1);
        if ((float)i >= (float)this.keys.length * 0.8f) {
            int j = this.keys.length << 1;
            while (j < intKey) {
                j <<= 1;
            }
            this.grow(j);
        }
        int k = this.findEmpty(this.hashObject(objectIn));
        this.keys[k] = objectIn;
        this.values[k] = intKey;
        this.byId[intKey] = objectIn;
        ++this.mapSize;
        if (intKey == this.nextFreeIndex) {
            ++this.nextFreeIndex;
        }
    }

    private int hashObject(K obectIn) {
        return (MathHelper.getHash(System.identityHashCode(obectIn)) & Integer.MAX_VALUE) % this.keys.length;
    }

    private int getIndex(K objectIn, int p_186816_2_) {
        int i = p_186816_2_;
        while (i < this.keys.length) {
            if (this.keys[i] == objectIn) {
                return i;
            }
            if (this.keys[i] == EMPTY) {
                return -1;
            }
            ++i;
        }
        int j = 0;
        while (j < p_186816_2_) {
            if (this.keys[j] == objectIn) {
                return j;
            }
            if (this.keys[j] == EMPTY) {
                return -1;
            }
            ++j;
        }
        return -1;
    }

    private int findEmpty(int p_186806_1_) {
        int i = p_186806_1_;
        while (i < this.keys.length) {
            if (this.keys[i] == EMPTY) {
                return i;
            }
            ++i;
        }
        int j = 0;
        while (j < p_186806_1_) {
            if (this.keys[j] == EMPTY) {
                return j;
            }
            ++j;
        }
        throw new RuntimeException("Overflowed :(");
    }

    @Override
    public Iterator<K> iterator() {
        return Iterators.filter((Iterator)Iterators.forArray((Object[])this.byId), (Predicate)Predicates.notNull());
    }

    public void clear() {
        Arrays.fill(this.keys, null);
        Arrays.fill(this.byId, null);
        this.nextFreeIndex = 0;
        this.mapSize = 0;
    }

    public int size() {
        return this.mapSize;
    }
}

