/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.GuiManagerDisplayScreen;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tk.wurst_client.WurstClient;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.ModManager;

public class WurstButtonUI
extends AbstractComponentUI<Button> {
    private final WurstTheme theme;
    private long lastMS;
    private Button describedButton;
    private Button rightButton;

    WurstButtonUI(WurstTheme theme) {
        super(Button.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(0, 0, 0, 0);
    }

    @Override
    protected void renderComponent(Button button) {
        this.translateComponent(button, false);
        Rectangle area = button.getArea();
        area.width = button.getParent().getWidth() - 4;
        Point mouse = RenderUtil.calculateMouseLocation();
        Container parent = button.getParent();
        while (parent != null) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
            parent = parent.getParent();
        }
        Point rawMouse = RenderUtil.calculateMouseLocation();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        RenderUtil.setColor(button.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)1.0);
        GL11.glVertex2d((double)area.width, (double)1.0);
        GL11.glVertex2d((double)area.width, (double)(area.height - 1));
        GL11.glVertex2d((double)0.0, (double)(area.height - 1));
        GL11.glEnd();
        RenderUtil.boxShadow(0.0, 1.0, area.width, area.height - 1);
        if (area.contains(mouse) && Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.3f : 0.2f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)area.width, (double)1.0);
            GL11.glVertex2d((double)area.width, (double)(area.height - 1));
            GL11.glVertex2d((double)0.0, (double)(area.height - 1));
            GL11.glEnd();
        }
        String text = button.getText();
        FontRenderer fontRenderer = this.theme.getFontRenderer();
        fontRenderer.drawString(text, (area.width - fontRenderer.getStringWidth(text)) / 2, (area.height - fontRenderer.FONT_HEIGHT) / 2 - 1, RenderUtil.toRGBA(button.getForegroundColor()));
        this.translateComponent(button, true);
        if (button.getDescription() == null) {
            return;
        }
        if (area.contains(mouse) && this.describedButton != button) {
            this.lastMS = 0L;
            this.describedButton = button;
        }
        if (this.lastMS == 0L && this.describedButton != null && this.isCorrectButton(button, this.describedButton)) {
            this.lastMS = System.currentTimeMillis();
            this.rightButton = button;
            return;
        }
        if (System.currentTimeMillis() < this.lastMS + 500L) {
            return;
        }
        if (this.describedButton != null && this.rightButton == button && Minecraft.getMinecraft().currentScreen instanceof GuiManagerDisplayScreen) {
            int lineWidth;
            String[] lines = this.describedButton.getDescription().split("\n");
            int textWidth = 0;
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                lineWidth = this.theme.getFontRenderer().getStringWidth(line);
                if (lineWidth > textWidth) {
                    textWidth = lineWidth;
                }
                ++n2;
            }
            int textHeight = (this.theme.getFontRenderer().FONT_HEIGHT + 2) * lines.length;
            Rectangle dArea = this.describedButton.getArea();
            dArea.width = this.describedButton.getParent().getWidth() - 4;
            Frame[] frameArray = WurstClient.INSTANCE.gui.getFrames();
            lineWidth = frameArray.length;
            int n3 = 0;
            while (n3 < lineWidth) {
                Frame frame = frameArray[n3];
                if (frame.getTitle().equalsIgnoreCase(button.getMod().getCategory().name())) {
                    WurstClient.INSTANCE.gui.bringForward(frame);
                }
                ++n3;
            }
            int scale = Minecraft.getMinecraft().gameSettings.guiScale;
            if (scale == 0) {
                scale = 1000;
            }
            int scaleFactor = 0;
            while (scaleFactor < scale && Minecraft.getMinecraft().displayWidth / (scaleFactor + 1) >= 320 && Minecraft.getMinecraft().displayHeight / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }
            if (rawMouse.x + 8 + textWidth > Minecraft.getMinecraft().displayWidth / scaleFactor) {
                rawMouse.x -= textWidth + 16;
            }
            if (rawMouse.y - 5 + textHeight > Minecraft.getMinecraft().displayHeight / scaleFactor) {
                rawMouse.y -= textHeight - 8;
            }
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)0.1875f, (float)0.1875f, (float)0.1875f, (float)0.75f);
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + textWidth + 11), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + textWidth + 11), (double)(rawMouse.y - 5 + textHeight));
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y - 5 + textHeight));
            GL11.glEnd();
            RenderUtil.boxShadow(rawMouse.x + 6, rawMouse.y - 5, rawMouse.x + textWidth + 11, rawMouse.y - 5 + textHeight);
            int i = 0;
            while (i < lines.length) {
                this.theme.getFontRenderer().drawString(lines[i], rawMouse.x + 8, rawMouse.y - 5 + (this.theme.getFontRenderer().FONT_HEIGHT + 2) * i, RenderUtil.toRGBA(Color.WHITE));
                ++i;
            }
        }
        if (!area.contains(mouse) && this.describedButton == button) {
            this.lastMS = 0L;
            this.describedButton = null;
            this.rightButton = null;
        }
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private boolean isCorrectButton(Button button, Button dButton) {
        if (button.getMod() == null || dButton.getMod() == null) {
            return false;
        }
        Mod.Category buttonCategory = button.getMod().getCategory();
        if (buttonCategory != dButton.getMod().getCategory()) {
            return false;
        }
        Field[] fields = ModManager.class.getFields();
        try {
            int i = fields.length - 1;
            while (i > -1) {
                Mod mod;
                Field field = fields[i];
                if (field.getName().endsWith("Mod") && (mod = (Mod)field.get(WurstClient.INSTANCE.mods)).getCategory() == buttonCategory) {
                    return mod == button.getMod();
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected Dimension getDefaultComponentSize(Button component) {
        return new Dimension(this.theme.getFontRenderer().getStringWidth(component.getText()) + 4, this.theme.getFontRenderer().FONT_HEIGHT + 4);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Button component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), component.getHeight())};
    }

    @Override
    protected void handleComponentInteraction(Button component, Point location, int button) {
        if (location.x <= component.getWidth() && location.y <= component.getHeight() && button == 0) {
            component.press();
        }
    }
}

