/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.ai;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.WurstClient;

public class PathUtils {
    private static PlayerCapabilities playerCaps;

    public static boolean isSafe(BlockPos pos) {
        boolean alwaysSafe;
        Material material = PathUtils.getMaterial(pos);
        int id = PathUtils.getID(pos);
        boolean bl = alwaysSafe = !material.blocksMovement() && id != 132;
        if (PathUtils.isCreative()) {
            return alwaysSafe;
        }
        Material materialBelow = PathUtils.getMaterial(pos.add(0, -1, 0));
        return alwaysSafe && material != Material.LAVA && materialBelow != Material.CACTUS && material != Material.FIRE;
    }

    public static boolean isSolid(BlockPos pos) {
        return Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock().getMaterial(Minecraft.getMinecraft().theWorld.getBlockState(pos)).blocksMovement() || PathUtils.getMaterial(pos) == Material.WATER && WurstClient.INSTANCE.mods.jesusMod.isEnabled();
    }

    public static boolean isFallable(BlockPos pos) {
        int i = -1;
        while (i >= (PathUtils.isNoFall() ? -256 : -3)) {
            if (PathUtils.isSolid(pos.add(0, i, 0))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isClimbable(BlockPos pos) {
        return !(!PathUtils.isSolid(pos.add(0, -1, 0)) && !WurstClient.INSTANCE.mods.spiderMod.isEnabled() && PathUtils.getID(pos) != 65 && !PathUtils.isFlyable(pos) || !PathUtils.isSolid(pos.add(0, 0, -1)) && !PathUtils.isSolid(pos.add(0, 0, 1)) && !PathUtils.isSolid(pos.add(1, 0, 0)) && !PathUtils.isSolid(pos.add(-1, 0, 0)));
    }

    public static boolean isNoFall() {
        return WurstClient.INSTANCE.mods.noFallMod.isEnabled() || PathUtils.isCreative();
    }

    public static boolean isCreative() {
        if (playerCaps == null) {
            playerCaps = Minecraft.getMinecraft().thePlayer.capabilities;
        }
        return PathUtils.playerCaps.isCreativeMode;
    }

    public static boolean isFlyable(BlockPos pos) {
        if (playerCaps == null) {
            playerCaps = Minecraft.getMinecraft().thePlayer.capabilities;
        }
        return WurstClient.INSTANCE.mods.flightMod.isEnabled() || PathUtils.playerCaps.isFlying || !WurstClient.INSTANCE.mods.noSlowdownMod.isEnabled() && PathUtils.getMaterial(pos) == Material.WATER;
    }

    public static int getCost(BlockPos current, BlockPos next) {
        Material nextMaterial = PathUtils.getMaterial(next);
        if (nextMaterial == Material.WATER) {
            if (WurstClient.INSTANCE.mods.noSlowdownMod.isEnabled()) {
                return 1;
            }
            if (WurstClient.INSTANCE.mods.antiKnockbackMod.isEnabled()) {
                return 2;
            }
            return 3;
        }
        if (nextMaterial == Material.LAVA) {
            return 5;
        }
        return 1;
    }

    private static Material getMaterial(BlockPos pos) {
        return Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock().getMaterial(Minecraft.getMinecraft().theWorld.getBlockState(pos));
    }

    private static int getID(BlockPos pos) {
        return Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock());
    }
}

