/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(description="Lists all keybinds.", name="binds", syntax={"[<page>]"}, help="Commands/binds")
public class BindsCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            this.execute(new String[]{"1"});
            return;
        }
        int pages = (int)Math.ceil((double)BindsCmd.wurst.keybinds.size() / 8.0);
        if (MiscUtils.isInteger(args[0])) {
            int page = Integer.valueOf(args[0]);
            if (page > pages || page == 0) {
                this.syntaxError("Invalid page: " + page);
                return;
            }
            BindsCmd.wurst.chat.message("Current keybinds: " + Integer.toString(BindsCmd.wurst.keybinds.size()));
            BindsCmd.wurst.chat.message("Keybind list (page " + page + "/" + pages + "):");
            Iterator itr = BindsCmd.wurst.keybinds.entrySet().iterator();
            int i = 0;
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (i >= (page - 1) * 8 && i < (page - 1) * 8 + 8) {
                    ((TreeSet)entry.getValue()).forEach(cmd -> BindsCmd.wurst.chat.message(String.valueOf((String)entry.getKey()) + ": " + cmd));
                }
                ++i;
            }
        } else {
            this.syntaxError("Not a number: \"" + args[0] + "\"");
        }
    }
}

