/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import tk.wurst_client.WurstClient;
import tk.wurst_client.commands.AddAltCmd;
import tk.wurst_client.commands.AnnoyCmd;
import tk.wurst_client.commands.AuthorCmd;
import tk.wurst_client.commands.BindsCmd;
import tk.wurst_client.commands.BlinkCmd;
import tk.wurst_client.commands.ClearCmd;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.commands.CopyItemCmd;
import tk.wurst_client.commands.DamageCmd;
import tk.wurst_client.commands.DropCmd;
import tk.wurst_client.commands.EnchantCmd;
import tk.wurst_client.commands.FeaturesCmd;
import tk.wurst_client.commands.FollowCmd;
import tk.wurst_client.commands.FriendsCmd;
import tk.wurst_client.commands.GetPosCmd;
import tk.wurst_client.commands.GhostHandCmd;
import tk.wurst_client.commands.GiveCmd;
import tk.wurst_client.commands.GmCmd;
import tk.wurst_client.commands.GoToCmd;
import tk.wurst_client.commands.HelpCmd;
import tk.wurst_client.commands.InvseeCmd;
import tk.wurst_client.commands.IpCmd;
import tk.wurst_client.commands.JumpCmd;
import tk.wurst_client.commands.LeaveCmd;
import tk.wurst_client.commands.ModifyCmd;
import tk.wurst_client.commands.NothingCmd;
import tk.wurst_client.commands.NukerCmd;
import tk.wurst_client.commands.PathCmd;
import tk.wurst_client.commands.PotionCmd;
import tk.wurst_client.commands.ProtectCmd;
import tk.wurst_client.commands.RenameCmd;
import tk.wurst_client.commands.RepairCmd;
import tk.wurst_client.commands.RvCmd;
import tk.wurst_client.commands.SayCmd;
import tk.wurst_client.commands.SearchCmd;
import tk.wurst_client.commands.SetCheckboxCmd;
import tk.wurst_client.commands.SetModeCmd;
import tk.wurst_client.commands.SetSliderCmd;
import tk.wurst_client.commands.SpammerCmd;
import tk.wurst_client.commands.SvCmd;
import tk.wurst_client.commands.TCmd;
import tk.wurst_client.commands.TacoCmd;
import tk.wurst_client.commands.ThrowCmd;
import tk.wurst_client.commands.TpCmd;
import tk.wurst_client.commands.VClipCmd;
import tk.wurst_client.commands.WmsCmd;
import tk.wurst_client.commands.XRayCmd;
import tk.wurst_client.events.ChatOutputEvent;
import tk.wurst_client.events.listeners.ChatOutputListener;

public class CmdManager
implements ChatOutputListener {
    private final TreeMap<String, Cmd> cmds = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    });
    public final AddAltCmd addAltCmd = new AddAltCmd();
    public final AnnoyCmd annoyCmd = new AnnoyCmd();
    public final AuthorCmd authorCmd = new AuthorCmd();
    public final BindsCmd bindsCmd = new BindsCmd();
    public final BlinkCmd blinkCmd = new BlinkCmd();
    public final ClearCmd clearCmd = new ClearCmd();
    public final CopyItemCmd copyitemCmd = new CopyItemCmd();
    public final DamageCmd damageCmd = new DamageCmd();
    public final DropCmd dropCmd = new DropCmd();
    public final EnchantCmd enchantCmd = new EnchantCmd();
    public final FeaturesCmd featuresCmd = new FeaturesCmd();
    public final FollowCmd followCmd = new FollowCmd();
    public final FriendsCmd friendsCmd = new FriendsCmd();
    public final GetPosCmd getPosCmd = new GetPosCmd();
    public final GhostHandCmd ghostHandCmd = new GhostHandCmd();
    public final GiveCmd giveCmd = new GiveCmd();
    public final GmCmd gmCmd = new GmCmd();
    public final GoToCmd goToCmd = new GoToCmd();
    public final HelpCmd HhelpCmd = new HelpCmd();
    public final InvseeCmd invseeCmd = new InvseeCmd();
    public final IpCmd ipCmd = new IpCmd();
    public final JumpCmd jumpCmd = new JumpCmd();
    public final LeaveCmd leaveCmd = new LeaveCmd();
    public final ModifyCmd modifyCmd = new ModifyCmd();
    public final NothingCmd nothingCmd = new NothingCmd();
    public final NukerCmd nukerCmd = new NukerCmd();
    public final PathCmd pathCmd = new PathCmd();
    public final PotionCmd potionCmd = new PotionCmd();
    public final ProtectCmd protectCmd = new ProtectCmd();
    public final RenameCmd renameCmd = new RenameCmd();
    public final RepairCmd repairCmd = new RepairCmd();
    public final RvCmd rvCmd = new RvCmd();
    public final SvCmd svCmd = new SvCmd();
    public final SayCmd sayCmd = new SayCmd();
    public final SearchCmd searchCmd = new SearchCmd();
    public final SetCheckboxCmd setCheckboxCmd = new SetCheckboxCmd();
    public final SetModeCmd setModeCmd = new SetModeCmd();
    public final SetSliderCmd setSliderCmd = new SetSliderCmd();
    public final SpammerCmd spammerCmd = new SpammerCmd();
    public final TacoCmd tacoCmd = new TacoCmd();
    public final TCmd tCmd = new TCmd();
    public final ThrowCmd throwCmd = new ThrowCmd();
    public final TpCmd tpCmd = new TpCmd();
    public final VClipCmd vClipCmd = new VClipCmd();
    public final WmsCmd wmsCmd = new WmsCmd();
    public final XRayCmd xRayCmd = new XRayCmd();

    public CmdManager() {
        try {
            Field[] fieldArray = CmdManager.class.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field.getName().endsWith("Cmd")) {
                    Cmd cmd = (Cmd)field.get(this);
                    this.cmds.put(cmd.getCmdName(), cmd);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSentMessage(ChatOutputEvent event) {
        block15: {
            String commandName;
            String message;
            block16: {
                message = event.getMessage();
                if (!message.startsWith(".")) break block15;
                event.cancel();
                String input = message.substring(1);
                commandName = input.split(" ")[0];
                String[] args = input.contains(" ") ? input.substring(input.indexOf(" ") + 1).split(" ") : new String[]{};
                Cmd cmd = this.getCommandByName(commandName);
                if (cmd == null) break block16;
                try {
                    cmd.execute(args);
                }
                catch (Cmd.SyntaxError e) {
                    if (e.getMessage() != null) {
                        WurstClient.INSTANCE.chat.message("\u00a74Syntax error:\u00a7r " + e.getMessage());
                    } else {
                        WurstClient.INSTANCE.chat.message("\u00a74Syntax error!\u00a7r");
                    }
                    cmd.printSyntax();
                }
                catch (Cmd.Error e) {
                    WurstClient.INSTANCE.chat.error(e.getMessage());
                }
                catch (Throwable e) {
                    CrashReport crashReport = CrashReport.makeCrashReport(e, "Running Wurst command");
                    CrashReportCategory crashReportCategory = crashReport.makeCategory("Affected command");
                    crashReportCategory.addCrashSectionCallable("Command input", new ICrashReportDetail<String>(){

                        @Override
                        public String call() throws Exception {
                            return message;
                        }
                    });
                    throw new ReportedException(crashReport);
                }
            }
            switch (message) {
                case "...": 
                case ".legit": {
                    TextComponentString link = new TextComponentString("more info");
                    link.getStyle().setColor(TextFormatting.AQUA).setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.wurst-client.tk/wiki/Commands/say/"));
                    WurstClient.INSTANCE.chat.component(new TextComponentString("Try using .say (").appendSibling(link).appendText(")"));
                    break;
                }
                default: {
                    WurstClient.INSTANCE.chat.error("\"." + commandName + "\" is not a valid command.");
                }
            }
        }
    }

    public Cmd getCommandByName(String name) {
        return this.cmds.get(name);
    }

    public Collection<Cmd> getAllCommands() {
        return this.cmds.values();
    }

    public int countCommands() {
        return this.cmds.size();
    }
}

