/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.events.ChatOutputEvent;

@Cmd.Info(description="Enchants items with everything.", name="enchant", syntax={"[all]"}, help="Commands/enchant")
public class EnchantCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (!EnchantCmd.mc.thePlayer.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        if (args.length == 0) {
            ItemStack currentItem = EnchantCmd.mc.thePlayer.inventory.getCurrentItem();
            if (currentItem == null) {
                this.error("There is no item in your hand.");
            }
            for (Enchantment enchantment : Enchantment.REGISTRY) {
                try {
                    if (enchantment == Enchantments.SILK_TOUCH) continue;
                    currentItem.addEnchantment(enchantment, 127);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (args[0].equals("all")) {
            int items = 0;
            int i = 0;
            while (i < 40) {
                ItemStack currentItem = EnchantCmd.mc.thePlayer.inventory.getStackInSlot(i);
                if (currentItem != null) {
                    ++items;
                    for (Enchantment enchantment : Enchantment.REGISTRY) {
                        try {
                            if (enchantment == Enchantments.SILK_TOUCH) continue;
                            currentItem.addEnchantment(enchantment, 127);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
            if (items == 1) {
                EnchantCmd.wurst.chat.message("Enchanted 1 item.");
            } else {
                EnchantCmd.wurst.chat.message("Enchanted " + items + " items.");
            }
        } else {
            this.syntaxError();
        }
    }

    @Override
    public String getPrimaryAction() {
        return "Enchant Current Item";
    }

    @Override
    public void doPrimaryAction() {
        EnchantCmd.wurst.commands.onSentMessage(new ChatOutputEvent(".enchant", true));
    }
}

