/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.util.ResourceLocation;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(description="Gives you an item with custom NBT data. Requires creative mode.", name="give", syntax={"(<item_name>|<item_id>) [<amount>] [<metadata>] [<nbt>]", "template <template_id> [<amount>]", "templates"}, help="Commands/give")
public class GiveCmd
extends Cmd {
    private ItemTemplate[] templates = new ItemTemplate[]{new ItemTemplate("Knockback Stick", Items.STICK, "{ench:[{id:19, lvl:12}], display:{Name:\u00a76Knockback Stick},HideFlags:63}"), new ItemTemplate("One Hit Sword", Items.DIAMOND_SWORD, "{AttributeModifiers:[{AttributeName:generic.attackDamage,Name:generic.attackDamage, Amount:2147483647,Operation:0, UUIDMost:246216, UUIDLeast:24636}], display:{Name:\u00a76One Hitter}, Unbreakable:1,HideFlags:63}"), new ItemTemplate("Super Bow", Items.BOW, "{ench:[{id:48, lvl:32767}, {id:49, lvl:5}, {id:50, lvl:1},{id:51, lvl:1}], display:{Name:\u00a76Super Bow}, HideFlags:63}"), new ItemTemplate("Super Thorns Chestplate", Items.DIAMOND_CHESTPLATE, "{ench:[{id:7, lvl:32767},{id:0, lvl:32767}], AttributeModifiers:[{AttributeName:generic.maxHealth, Name:generic.maxHealth,Amount:200, Operation:0, UUIDMost:43631, UUIDLeast:2641}], display:{Name:\u00a76Super Thorns Chestplate}, HideFlags:63,Unbreakable:1}"), new ItemTemplate("Super Potion", Items.POTIONITEM, "{CustomPotionEffects: [{Id:11, Amplifier:127, Duration:2147483647},{Id:10, Amplifier:127, Duration:2147483647},{Id:23, Amplifier:127, Duration:2147483647},{Id:16, Amplifier:0, Duration:2147483647},{Id:8, Amplifier:3, Duration:2147483647},{Id:1, Amplifier:5, Duration:2147483647},{Id:5, Amplifier:127, Duration:2147483647}],display:{Name:\u00a76Super Potion}, HideFlags:63}"), new ItemTemplate("Griefer Potion", Items.POTIONITEM, "{CustomPotionEffects:[{Id:3, Amplifier:127, Duration:2147483647}], display:{Name:\u00a76Griefer Potion}, HideFlags:63}")};

    private int parseAmount(Item item, String input) throws Cmd.Error {
        int amount;
        if (!MiscUtils.isInteger(input)) {
            this.syntaxError("Amount must be a number.");
        }
        if ((amount = Integer.valueOf(input).intValue()) < 1) {
            this.error("Amount must be 1 or more.");
        }
        if (amount > item.getItemStackLimit()) {
            this.error("Amount is larger than the maximum stack size.");
        }
        return amount;
    }

    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length < 1) {
            this.syntaxError();
        }
        if (!GiveCmd.mc.thePlayer.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        if (args[0].equalsIgnoreCase("templates")) {
            GiveCmd.wurst.chat.message("\u00a7cItem templates:");
            int i = 0;
            while (i < this.templates.length) {
                ItemTemplate template = this.templates[i];
                GiveCmd.wurst.chat.message("\u00a7c" + (i + 1) + "\u00a7c: \u00a76" + template.name);
                ++i;
            }
            return;
        }
        Item item = null;
        int amount = 1;
        int metadata = 0;
        String nbt = null;
        if (args[0].equalsIgnoreCase("template")) {
            int id;
            if (args.length < 2 || args.length > 3) {
                this.syntaxError();
            }
            if (!MiscUtils.isInteger(args[1])) {
                this.syntaxError("Template ID must be a number.");
            }
            if ((id = Integer.valueOf(args[1]).intValue()) < 1 || id > this.templates.length) {
                this.error("Template ID is out of range.");
            }
            ItemTemplate template = this.templates[id - 1];
            item = template.item;
            nbt = template.tag;
            if (args.length == 3) {
                amount = this.parseAmount(item, args[2]);
            }
        } else {
            item = Item.REGISTRY.getObject(new ResourceLocation(args[0]));
            if (item == null && MiscUtils.isInteger(args[0])) {
                item = Item.getItemById(Integer.parseInt(args[0]));
            }
            if (item == null) {
                this.error("Item \"" + args[0] + "\" could not be found.");
            }
            if (args.length >= 2) {
                amount = this.parseAmount(item, args[1]);
            }
            if (args.length >= 3) {
                if (!MiscUtils.isInteger(args[2])) {
                    this.syntaxError("Metadata must be a number.");
                }
                metadata = Integer.valueOf(args[2]);
            }
            if (args.length >= 4) {
                nbt = args[3];
                int i = 4;
                while (i < args.length) {
                    nbt = String.valueOf(nbt) + " " + args[i];
                    ++i;
                }
            }
        }
        ItemStack stack = new ItemStack(item, amount, metadata);
        if (nbt != null) {
            try {
                stack.setTagCompound(JsonToNBT.getTagFromJson(nbt));
            }
            catch (NBTException e) {
                this.syntaxError("NBT data is invalid.");
            }
        }
        int i = 0;
        while (i < 9) {
            if (GiveCmd.mc.thePlayer.inventory.getStackInSlot(i) == null) {
                GiveCmd.mc.thePlayer.connection.sendPacket(new CPacketCreativeInventoryAction(36 + i, stack));
                GiveCmd.wurst.chat.message("Item" + (amount > 1 ? "s" : "") + " created.");
                return;
            }
            ++i;
        }
        this.error("Please clear a slot of your hotbar.");
    }

    private static class ItemTemplate {
        public Item item;
        public String name;
        public String tag;

        public ItemTemplate(String name, Item item, String tag) {
            this.name = name;
            this.item = item;
            this.tag = tag;
        }
    }
}

