/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(description="Shows the command list or the help for a command.", name="help", syntax={"[<page>]", "[<command>]"}, help="Commands/help")
public class HelpCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length == 0) {
            this.execute(new String[]{"1"});
            return;
        }
        int pages = (int)Math.ceil((double)HelpCmd.wurst.commands.countCommands() / 8.0);
        if (MiscUtils.isInteger(args[0])) {
            int page = Integer.valueOf(args[0]);
            if (page > pages || page < 1) {
                this.syntaxError("Invalid page: " + page);
            }
            HelpCmd.wurst.chat.message("Available commands: " + HelpCmd.wurst.commands.countCommands());
            HelpCmd.wurst.chat.message("Command list (page " + page + "/" + pages + "):");
            Iterator<Cmd> itr = HelpCmd.wurst.commands.getAllCommands().iterator();
            int i = 0;
            while (itr.hasNext()) {
                Cmd cmd = itr.next();
                if (i >= (page - 1) * 8 && i < (page - 1) * 8 + 8) {
                    HelpCmd.wurst.chat.message(cmd.getCmdName());
                }
                ++i;
            }
        } else {
            Cmd cmd = HelpCmd.wurst.commands.getCommandByName(args[0]);
            if (cmd != null) {
                HelpCmd.wurst.chat.message("Available help for ." + args[0] + ":");
                cmd.printHelp();
                cmd.printSyntax();
            } else {
                this.error("Command \"" + args[0] + "\" could not be found.");
            }
        }
    }
}

