/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(description="Modifies items in creative mode.", name="modify", syntax={"add <nbt>", "remove <nbt_path>", "set <nbt>", "metadata <value>"}, help="Commands/modify")
public class ModifyCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        ItemStack item;
        EntityPlayerSP player = ModifyCmd.mc.thePlayer;
        if (!player.capabilities.isCreativeMode) {
            this.error("Creative mode only.");
        }
        if (args.length < 1) {
            this.syntaxError();
        }
        if ((item = player.inventory.getCurrentItem()) == null) {
            this.error("You need an item in your hand.");
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (args.length < 2) {
                this.syntaxError();
            }
            String v = "";
            int i = 1;
            while (i < args.length) {
                v = String.valueOf(v) + args[i] + " ";
                ++i;
            }
            if (!item.hasTagCompound()) {
                item.setTagCompound(new NBTTagCompound());
            }
            try {
                NBTTagCompound value = JsonToNBT.getTagFromJson(v);
                item.getTagCompound().merge(value);
            }
            catch (NBTException e) {
                e.printStackTrace();
                this.error("NBT data is invalid.");
            }
        } else if (args[0].equalsIgnoreCase("set")) {
            if (args.length < 2) {
                this.syntaxError();
            }
            String v = "";
            int i = 1;
            while (i < args.length) {
                v = String.valueOf(v) + args[i] + " ";
                ++i;
            }
            try {
                NBTTagCompound value = JsonToNBT.getTagFromJson(v);
                item.setTagCompound(value);
            }
            catch (NBTException e) {
                e.printStackTrace();
                this.error("NBT data is invalid.");
            }
        } else if (args[0].equalsIgnoreCase("remove")) {
            NBTPath path;
            if (args.length != 2) {
                this.syntaxError();
            }
            if ((path = this.parseNBTPath(item.getTagCompound(), args[1])) == null) {
                this.error("The path does not exist.");
            }
            path.base.removeTag(path.key);
        } else if (args[0].equalsIgnoreCase("metadata")) {
            if (args.length != 2) {
                this.syntaxError();
            }
            if (!MiscUtils.isInteger(args[1])) {
                this.syntaxError("Value must be a number.");
            }
            item.setItemDamage(Integer.parseInt(args[1]));
        } else {
            this.syntaxError();
        }
        player.connection.sendPacket(new CPacketCreativeInventoryAction(36 + player.inventory.currentItem, item));
        ModifyCmd.wurst.chat.message("Item modified.");
    }

    private NBTPath parseNBTPath(NBTTagCompound tag, String path) {
        String[] parts = path.split("\\.");
        NBTTagCompound base = tag;
        if (base == null) {
            return null;
        }
        int i = 0;
        while (i < parts.length - 1) {
            String part = parts[i];
            if (!base.hasKey(part) || !(base.getTag(part) instanceof NBTTagCompound)) {
                return null;
            }
            base = base.getCompoundTag(part);
            ++i;
        }
        if (!base.hasKey(parts[parts.length - 1])) {
            return null;
        }
        return new NBTPath(base, parts[parts.length - 1]);
    }

    private static class NBTPath {
        public NBTTagCompound base;
        public String key;

        public NBTPath(NBTTagCompound base, String key) {
            this.base = base;
            this.key = key;
        }
    }
}

