/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.CheckboxSetting;
import tk.wurst_client.navigator.settings.NavigatorSetting;

@Cmd.Info(description="Changes a checkbox setting of a feature. Allows you\nto toggle checkboxes through keybinds.", name="setcheckbox", syntax={"<feature> <checkbox_setting> (on|off|toggle)"}, help="Commands/setcheckbox")
public class SetCheckboxCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 3) {
            this.syntaxError();
        }
        NavigatorItem feature = null;
        String featureName = args[0];
        Iterator<NavigatorItem> itr = SetCheckboxCmd.wurst.navigator.iterator();
        while (itr.hasNext()) {
            NavigatorItem item = itr.next();
            if (!featureName.equalsIgnoreCase(item.getName())) continue;
            feature = item;
            break;
        }
        if (feature == null) {
            this.error("A feature named \"" + featureName + "\" could not be found.");
        }
        NavigatorSetting setting = null;
        String settingName = args[1].replace("_", " ");
        for (NavigatorSetting featureSetting : feature.getSettings()) {
            if (!featureSetting.getName().equalsIgnoreCase(settingName)) continue;
            setting = featureSetting;
            break;
        }
        if (setting == null) {
            this.error("A setting named \"" + settingName + "\" could not be found in " + feature.getName() + ".");
        }
        if (!(setting instanceof CheckboxSetting)) {
            this.error(String.valueOf(feature.getName()) + " " + setting.getName() + " is not a checkbox setting.");
        }
        CheckboxSetting checkboxSetting = (CheckboxSetting)setting;
        String valueName = args[2];
        if (valueName.equalsIgnoreCase("on")) {
            checkboxSetting.setChecked(true);
        } else if (valueName.equalsIgnoreCase("off")) {
            checkboxSetting.setChecked(false);
        } else if (valueName.equalsIgnoreCase("toggle")) {
            checkboxSetting.toggle();
        } else {
            this.syntaxError();
        }
    }
}

