/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.util.Iterator;
import tk.wurst_client.commands.Cmd;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.NavigatorSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.utils.MiscUtils;

@Cmd.Info(description="Changes a slider setting of a feature. Allows you to\nmove sliders through keybinds.", name="setslider", syntax={"<feature> <slider_setting> (<value>|more|less)"}, help="Commands/setslider")
public class SetSliderCmd
extends Cmd {
    @Override
    public void execute(String[] args) throws Cmd.Error {
        if (args.length != 3) {
            this.syntaxError();
        }
        NavigatorItem feature = null;
        String featureName = args[0];
        Iterator<NavigatorItem> itr = SetSliderCmd.wurst.navigator.iterator();
        while (itr.hasNext()) {
            NavigatorItem item = itr.next();
            if (!featureName.equalsIgnoreCase(item.getName())) continue;
            feature = item;
            break;
        }
        if (feature == null) {
            this.error("A feature named \"" + featureName + "\" could not be found.");
        }
        NavigatorSetting setting = null;
        String settingName = args[1].replace("_", " ");
        for (NavigatorSetting featureSetting : feature.getSettings()) {
            if (!featureSetting.getName().equalsIgnoreCase(settingName)) continue;
            setting = featureSetting;
            break;
        }
        if (setting == null) {
            this.error("A setting named \"" + settingName + "\" could not be found in " + feature.getName() + ".");
        }
        if (!(setting instanceof SliderSetting)) {
            this.error(String.valueOf(feature.getName()) + " " + setting.getName() + " is not a slider setting.");
        }
        SliderSetting sliderSetting = (SliderSetting)setting;
        String valueName = args[2];
        if (valueName.equalsIgnoreCase("more")) {
            sliderSetting.increaseValue();
        } else if (valueName.equalsIgnoreCase("less")) {
            sliderSetting.decreaseValue();
        } else {
            if (!MiscUtils.isDouble(valueName)) {
                this.syntaxError("Value must be a number.");
            }
            double value = Double.parseDouble(valueName);
            sliderSetting.setValue(value);
        }
    }
}

