/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.events;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import tk.wurst_client.events.Event;
import tk.wurst_client.events.listeners.ChatInputListener;
import tk.wurst_client.events.listeners.ChatOutputListener;
import tk.wurst_client.events.listeners.DeathListener;
import tk.wurst_client.events.listeners.GUIRenderListener;
import tk.wurst_client.events.listeners.LeftClickListener;
import tk.wurst_client.events.listeners.PacketInputListener;
import tk.wurst_client.events.listeners.PacketOutputListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.events.listeners.UpdateListener;

public final class EventManager {
    private final HashMap<Class<? extends EventListener>, ArrayList<? extends EventListener>> listenerMap = new HashMap();

    public EventManager() {
        this.listenerMap.put(ChatInputListener.class, new ArrayList());
        this.listenerMap.put(ChatOutputListener.class, new ArrayList());
        this.listenerMap.put(DeathListener.class, new ArrayList());
        this.listenerMap.put(GUIRenderListener.class, new ArrayList());
        this.listenerMap.put(LeftClickListener.class, new ArrayList());
        this.listenerMap.put(PacketInputListener.class, new ArrayList());
        this.listenerMap.put(PacketOutputListener.class, new ArrayList());
        this.listenerMap.put(RenderListener.class, new ArrayList());
        this.listenerMap.put(UpdateListener.class, new ArrayList());
    }

    public <T extends Event> void fire(T event) {
        try {
            ((Event)event).fire(this.listenerMap.get(((Event)event).getListenerType()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            CrashReport crashReport = CrashReport.makeCrashReport(e, "Firing Wurst event");
            CrashReportCategory crashreportcategory = crashReport.makeCategory("Affected event");
            crashreportcategory.addCrashSectionCallable("Event class", () -> event.getClass().getName());
            throw new ReportedException(crashReport);
        }
    }

    public <T extends EventListener> void add(Class<T> type, T listener) {
        try {
            this.listenerMap.get(type).add(listener);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CrashReport crashReport = CrashReport.makeCrashReport(e, "Adding Wurst event listener");
            CrashReportCategory crashreportcategory = crashReport.makeCategory("Affected listener");
            crashreportcategory.addCrashSectionCallable("Listener type", () -> type.getName());
            crashreportcategory.addCrashSectionCallable("Listener class", () -> listener.getClass().getName());
            throw new ReportedException(crashReport);
        }
    }

    public <T extends EventListener> void remove(Class<T> type, T listener) {
        try {
            this.listenerMap.get(type).remove(listener);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CrashReport crashReport = CrashReport.makeCrashReport(e, "Removing Wurst event listener");
            CrashReportCategory crashreportcategory = crashReport.makeCategory("Affected listener");
            crashreportcategory.addCrashSectionCallable("Listener type", () -> type.getName());
            crashreportcategory.addCrashSectionCallable("Listener class", () -> listener.getClass().getName());
            throw new ReportedException(crashReport);
        }
    }
}

