/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.multiplayer;

import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;

public class GuiCleanUp
extends GuiScreen {
    private GuiMultiplayer prevMenu;
    private boolean removeAll;
    private String[] toolTips = new String[]{"", "Start the Clean Up with the settings\nyou specified above.\nIt might look like the game is not\nreacting for a couple of seconds.", "Servers that clearly don't exist.", "Servers that run a different Minecraft\nversion than you.", "All servers that failed the last ping.\nMake sure that the last ping is complete\nbefore you do this. That means: Go back,\npress the refresh button and wait until\nall servers are done refreshing.", "All servers where the name starts with \"Grief me\"\nUseful for removing servers found by ServerFinder.", "This will completely clear your server\nlist. \u00a7cUse with caution!\u00a7r", "Renames your servers to \"Grief me #1\",\n\"Grief me #2\", etc."};

    public GuiCleanUp(GuiMultiplayer prevMultiplayerMenu) {
        this.prevMenu = prevMultiplayerMenu;
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 168 + 12, "Cancel"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 144 + 12, "Clean Up"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 - 24 + 12, "Unknown Hosts: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupUnknown)));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 100, this.height / 4 + 0 + 12, "Outdated Servers: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupOutdated)));
        this.buttonList.add(new GuiButton(4, this.width / 2 - 100, this.height / 4 + 24 + 12, "Failed Ping: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupFailed)));
        this.buttonList.add(new GuiButton(5, this.width / 2 - 100, this.height / 4 + 48 + 12, "\"Grief me\" Servers: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupGriefMe)));
        this.buttonList.add(new GuiButton(6, this.width / 2 - 100, this.height / 4 + 72 + 12, "\u00a7cRemove all Servers: " + this.yesOrNo(this.removeAll)));
        this.buttonList.add(new GuiButton(7, this.width / 2 - 100, this.height / 4 + 96 + 12, "Rename all Servers: " + this.yesOrNo(WurstClient.INSTANCE.options.cleanupRename)));
        WurstClient.INSTANCE.analytics.trackPageView("/multiplayer/clean-up", "Clean Up");
    }

    private String yesOrNo(boolean bool) {
        return bool ? "Yes" : "No";
    }

    private String removeOrKeep(boolean bool) {
        return bool ? "Remove" : "Keep";
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                this.mc.displayGuiScreen(this.prevMenu);
            } else if (clickedButton.id == 1) {
                ServerData server;
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "start");
                if (this.removeAll) {
                    this.prevMenu.savedServerList.clearServerList();
                    this.prevMenu.savedServerList.saveServerList();
                    this.prevMenu.serverListSelector.setSelectedSlotIndex(-1);
                    this.prevMenu.serverListSelector.updateOnlineServers(this.prevMenu.savedServerList);
                    this.mc.displayGuiScreen(this.prevMenu);
                    return;
                }
                int i = this.prevMenu.savedServerList.countServers() - 1;
                while (i >= 0) {
                    server = this.prevMenu.savedServerList.getServerData(i);
                    if (WurstClient.INSTANCE.options.cleanupUnknown && server.serverMOTD.equals((Object)((Object)TextFormatting.DARK_RED) + "Can't resolve hostname") || WurstClient.INSTANCE.options.cleanupOutdated && server.version != 210 || WurstClient.INSTANCE.options.cleanupFailed && server.pingToServer != -2L && server.pingToServer < 0L || WurstClient.INSTANCE.options.cleanupGriefMe && server.serverName.startsWith("Grief me")) {
                        this.prevMenu.savedServerList.removeServerData(i);
                        this.prevMenu.savedServerList.saveServerList();
                        this.prevMenu.serverListSelector.setSelectedSlotIndex(-1);
                        this.prevMenu.serverListSelector.updateOnlineServers(this.prevMenu.savedServerList);
                    }
                    --i;
                }
                if (WurstClient.INSTANCE.options.cleanupRename) {
                    i = 0;
                    while (i < this.prevMenu.savedServerList.countServers()) {
                        server = this.prevMenu.savedServerList.getServerData(i);
                        server.serverName = "Grief me #" + (i + 1);
                        this.prevMenu.savedServerList.saveServerList();
                        this.prevMenu.serverListSelector.setSelectedSlotIndex(-1);
                        this.prevMenu.serverListSelector.updateOnlineServers(this.prevMenu.savedServerList);
                        ++i;
                    }
                }
                this.mc.displayGuiScreen(this.prevMenu);
            } else if (clickedButton.id == 2) {
                WurstClient.INSTANCE.options.cleanupUnknown = !WurstClient.INSTANCE.options.cleanupUnknown;
                clickedButton.displayString = "Unknown Hosts: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupUnknown);
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "unknown host", this.removeOrKeep(WurstClient.INSTANCE.options.cleanupUnknown));
            } else if (clickedButton.id == 3) {
                WurstClient.INSTANCE.options.cleanupOutdated = !WurstClient.INSTANCE.options.cleanupOutdated;
                clickedButton.displayString = "Outdated Servers: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupOutdated);
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "outdated servers", this.removeOrKeep(WurstClient.INSTANCE.options.cleanupOutdated));
            } else if (clickedButton.id == 4) {
                WurstClient.INSTANCE.options.cleanupFailed = !WurstClient.INSTANCE.options.cleanupFailed;
                clickedButton.displayString = "Failed Ping: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupFailed);
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "failed ping", this.removeOrKeep(WurstClient.INSTANCE.options.cleanupFailed));
            } else if (clickedButton.id == 5) {
                WurstClient.INSTANCE.options.cleanupGriefMe = !WurstClient.INSTANCE.options.cleanupGriefMe;
                WurstClient.INSTANCE.files.saveOptions();
                clickedButton.displayString = "\"Grief Me\" Servers: " + this.removeOrKeep(WurstClient.INSTANCE.options.cleanupGriefMe);
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "grief me", this.removeOrKeep(WurstClient.INSTANCE.options.cleanupGriefMe));
            } else if (clickedButton.id == 6) {
                this.removeAll = !this.removeAll;
                clickedButton.displayString = "\u00a7cRemove all Servers: " + this.yesOrNo(this.removeAll);
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "remove all servers", this.yesOrNo(this.removeAll));
            } else if (clickedButton.id == 7) {
                WurstClient.INSTANCE.options.cleanupRename = !WurstClient.INSTANCE.options.cleanupRename;
                clickedButton.displayString = "Rename all Servers: " + this.yesOrNo(WurstClient.INSTANCE.options.cleanupRename);
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("clean up", "rename servers", this.yesOrNo(WurstClient.INSTANCE.options.cleanupRename));
            }
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        if (par2 == 28 || par2 == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Clean Up", this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "Please select the servers you want to remove:", this.width / 2, 36, 0xA0A0A0);
        super.drawScreen(par1, par2, par3);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (button.isMouseOver() && !this.toolTips[button.id].isEmpty()) {
                this.drawHoveringText(Arrays.asList(this.toolTips[button.id].split("\n")), par1, par2);
                break;
            }
            ++i;
        }
    }
}

