/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.multiplayer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.multiplayer.ServerData;
import org.lwjgl.input.Keyboard;
import tk.wurst_client.WurstClient;
import tk.wurst_client.servers.WurstServerPinger;
import tk.wurst_client.utils.MiscUtils;

public class GuiServerFinder
extends GuiScreen {
    private static final String[] stateStrings = new String[]{"", "\u00a72Searching...", "\u00a72Resolving...", "\u00a74Unknown Host!", "\u00a74Cancelled!", "\u00a72Done!", "\u00a74An error occurred!"};
    private GuiMultiplayer prevMenu;
    private GuiTextField ipBox;
    private GuiTextField maxThreadsBox;
    private int checked;
    private int working;
    private ServerFinderState state;

    public GuiServerFinder(GuiMultiplayer prevMultiplayerMenu) {
        this.prevMenu = prevMultiplayerMenu;
    }

    @Override
    public void updateScreen() {
        this.ipBox.updateCursorCounter();
        ((GuiButton)this.buttonList.get((int)0)).displayString = this.state.isRunning() ? "Cancel" : "Search";
        this.ipBox.setEnabled(!this.state.isRunning());
        this.maxThreadsBox.setEnabled(!this.state.isRunning());
        ((GuiButton)this.buttonList.get((int)0)).enabled = MiscUtils.isInteger(this.maxThreadsBox.getText()) && !this.ipBox.getText().isEmpty();
    }

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 96 + 12, "Search"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 120 + 12, "Tutorial"));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, this.height / 4 + 144 + 12, "Back"));
        this.ipBox = new GuiTextField(0, this.fontRendererObj, this.width / 2 - 100, this.height / 4 + 34, 200, 20);
        this.ipBox.setMaxStringLength(200);
        this.ipBox.setFocused(true);
        this.maxThreadsBox = new GuiTextField(1, this.fontRendererObj, this.width / 2 - 32, this.height / 4 + 58, 26, 12);
        this.maxThreadsBox.setMaxStringLength(3);
        this.maxThreadsBox.setFocused(false);
        this.maxThreadsBox.setText(Integer.toString(WurstClient.INSTANCE.options.serverFinderThreads));
        this.state = ServerFinderState.NOT_RUNNING;
        WurstClient.INSTANCE.analytics.trackPageView("/multiplayer/server-finder", "Server Finder");
    }

    @Override
    public void onGuiClosed() {
        this.state = ServerFinderState.CANCELLED;
        WurstClient.INSTANCE.analytics.trackEvent("server finder", "cancel", "gui closed", this.working);
        if (MiscUtils.isInteger(this.maxThreadsBox.getText())) {
            WurstClient.INSTANCE.options.serverFinderThreads = Integer.valueOf(this.maxThreadsBox.getText());
            WurstClient.INSTANCE.files.saveOptions();
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                if (this.state.isRunning()) {
                    this.state = ServerFinderState.CANCELLED;
                    WurstClient.INSTANCE.analytics.trackEvent("server finder", "cancel", "cancel button", this.working);
                } else {
                    if (MiscUtils.isInteger(this.maxThreadsBox.getText())) {
                        WurstClient.INSTANCE.options.serverFinderThreads = Integer.valueOf(this.maxThreadsBox.getText());
                        WurstClient.INSTANCE.files.saveOptions();
                    }
                    this.state = ServerFinderState.RESOLVING;
                    this.checked = 0;
                    this.working = 0;
                    new Thread("Server Finder"){

                        @Override
                        public void run() {
                            try {
                                int[] changes;
                                InetAddress addr = InetAddress.getByName(GuiServerFinder.this.ipBox.getText().split(":")[0].trim());
                                int[] ipParts = new int[4];
                                int i = 0;
                                while (i < 4) {
                                    ipParts[i] = addr.getAddress()[i] & 0xFF;
                                    ++i;
                                }
                                GuiServerFinder.this.state = ServerFinderState.SEARCHING;
                                ArrayList<WurstServerPinger> pingers = new ArrayList<WurstServerPinger>();
                                int[] nArray = new int[7];
                                nArray[1] = 1;
                                nArray[2] = -1;
                                nArray[3] = 2;
                                nArray[4] = -2;
                                nArray[5] = 3;
                                nArray[6] = -3;
                                int[] nArray2 = changes = nArray;
                                int n = changes.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int change = nArray2[n2];
                                    int i2 = 0;
                                    while (i2 <= 255) {
                                        if (GuiServerFinder.this.state == ServerFinderState.CANCELLED) {
                                            return;
                                        }
                                        int[] ipParts2 = (int[])ipParts.clone();
                                        ipParts2[2] = ipParts[2] + change & 0xFF;
                                        ipParts2[3] = i2;
                                        String ip = String.valueOf(ipParts2[0]) + "." + ipParts2[1] + "." + ipParts2[2] + "." + ipParts2[3];
                                        WurstServerPinger pinger = new WurstServerPinger();
                                        pinger.ping(ip);
                                        pingers.add(pinger);
                                        while (pingers.size() >= WurstClient.INSTANCE.options.serverFinderThreads) {
                                            if (GuiServerFinder.this.state == ServerFinderState.CANCELLED) {
                                                return;
                                            }
                                            GuiServerFinder.this.updatePingers(pingers);
                                        }
                                        ++i2;
                                    }
                                    ++n2;
                                }
                                while (pingers.size() > 0) {
                                    if (GuiServerFinder.this.state == ServerFinderState.CANCELLED) {
                                        return;
                                    }
                                    GuiServerFinder.this.updatePingers(pingers);
                                }
                                WurstClient.INSTANCE.analytics.trackEvent("server finder", "complete", "", GuiServerFinder.this.working);
                                GuiServerFinder.this.state = ServerFinderState.DONE;
                            }
                            catch (UnknownHostException e) {
                                GuiServerFinder.this.state = ServerFinderState.UNKNOWN_HOST;
                                WurstClient.INSTANCE.analytics.trackEvent("server finder", "unknown host");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                GuiServerFinder.this.state = ServerFinderState.ERROR;
                                WurstClient.INSTANCE.analytics.trackEvent("server finder", "error");
                            }
                        }
                    }.start();
                    WurstClient.INSTANCE.analytics.trackEvent("server finder", "start");
                }
            } else if (clickedButton.id == 1) {
                MiscUtils.openLink("https://www.wurst-client.tk/wiki/Special_Features/Server_Finder/");
            } else if (clickedButton.id == 2) {
                this.mc.displayGuiScreen(this.prevMenu);
            }
        }
    }

    private boolean serverInList(String ip) {
        int i = 0;
        while (i < this.prevMenu.savedServerList.countServers()) {
            if (this.prevMenu.savedServerList.getServerData((int)i).serverIP.equals(ip)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updatePingers(ArrayList<WurstServerPinger> pingers) {
        int i = 0;
        while (i < pingers.size()) {
            if (!pingers.get(i).isStillPinging()) {
                ++this.checked;
                if (pingers.get(i).isWorking()) {
                    ++this.working;
                    if (!this.serverInList(pingers.get((int)i).server.serverIP)) {
                        this.prevMenu.savedServerList.addServerData(new ServerData("Grief me #" + this.working, pingers.get((int)i).server.serverIP, false));
                        this.prevMenu.savedServerList.saveServerList();
                        this.prevMenu.serverListSelector.setSelectedSlotIndex(-1);
                        this.prevMenu.serverListSelector.updateOnlineServers(this.prevMenu.savedServerList);
                    }
                }
                pingers.remove(i);
            }
            ++i;
        }
    }

    @Override
    protected void keyTyped(char par1, int par2) {
        this.ipBox.textboxKeyTyped(par1, par2);
        this.maxThreadsBox.textboxKeyTyped(par1, par2);
        if (par2 == 28 || par2 == 156) {
            this.actionPerformed((GuiButton)this.buttonList.get(0));
        }
    }

    @Override
    protected void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
        this.ipBox.mouseClicked(par1, par2, par3);
        this.maxThreadsBox.mouseClicked(par1, par2, par3);
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Server Finder", this.width / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "This will search for servers with similar IPs", this.width / 2, 40, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "to the IP you type into the field below.", this.width / 2, 50, 0xA0A0A0);
        this.drawCenteredString(this.fontRendererObj, "The servers it finds will be added to your server list.", this.width / 2, 60, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Server address:", this.width / 2 - 100, this.height / 4 + 24, 0xA0A0A0);
        this.ipBox.drawTextBox();
        this.drawString(this.fontRendererObj, "Max. threads:", this.width / 2 - 100, this.height / 4 + 60, 0xA0A0A0);
        this.maxThreadsBox.drawTextBox();
        this.drawCenteredString(this.fontRendererObj, this.state.toString(), this.width / 2, this.height / 4 + 73, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Checked: " + this.checked + " / 1792", this.width / 2 - 100, this.height / 4 + 84, 0xA0A0A0);
        this.drawString(this.fontRendererObj, "Working: " + this.working, this.width / 2 - 100, this.height / 4 + 94, 0xA0A0A0);
        super.drawScreen(par1, par2, par3);
    }

    static enum ServerFinderState {
        NOT_RUNNING,
        SEARCHING,
        RESOLVING,
        UNKNOWN_HOST,
        CANCELLED,
        DONE,
        ERROR;


        public boolean isRunning() {
            return this == SEARCHING || this == RESOLVING;
        }

        public String toString() {
            return stateStrings[this.ordinal()];
        }
    }
}

