/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.gui.options;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import tk.wurst_client.WurstClient;
import tk.wurst_client.gui.options.keybinds.GuiKeybindManager;
import tk.wurst_client.gui.options.xray.GuiXRayBlocksManager;
import tk.wurst_client.gui.options.zoom.GuiZoomManager;
import tk.wurst_client.options.OptionsManager;
import tk.wurst_client.utils.MiscUtils;

public class GuiWurstOptions
extends GuiScreen {
    private GuiScreen prevMenu;
    private String[] modListModes = new String[]{"Auto", "Count", "Hidden"};
    private String[] toolTips = new String[]{"", "Add/remove friends by clicking them with\nthe middle mouse button.", "How the mod list under the Wurst logo\nshould be displayed.\n\u00a7lModes:\u00a7r\n\u00a7nAuto\u00a7r: Renders the whole list if it fits\nonto the screen.\n\u00a7nCount\u00a7r: Only renders the number of active\nmods.\n\u00a7nHidden\u00a7r: Renders nothing.", "Automatically maximizes the Minecraft window.\nWindows & Linux only!", "Whether or not the Wurst News should be\nshown in the main menu.", "Sends anonymous usage statistics that\nhelp us improve the Wurst Client.", "Keybinds allow you to toggle any mod\nor command by simply pressing a\nbutton.", "Manager for the blocks that X-Ray will\nshow.", "The Zoom Manager allows you to\nchange the zoom key, how far it\nwill zoom in and more.", "", "", "The official website of the Wurst\nClient. Here you can find the\nlatest Wurst updates, news and the\nWurst wiki.", "The official YouTube channel of the\nWurst Client. Here we post Wurst\nupdate videos, Wurst tutorials and\nmore.", "Our Twitter account shows the latest\nWurst updates, news and sneak peeks in\n140 characters or less.", "", ""};
    private boolean autoMaximize;

    public GuiWurstOptions(GuiScreen par1GuiScreen) {
        this.prevMenu = par1GuiScreen;
    }

    @Override
    public void initGui() {
        this.autoMaximize = WurstClient.INSTANCE.files.loadAutoMaximize();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 144 - 16, 200, 20, "Back"));
        this.buttonList.add(new GuiButton(1, this.width / 2 - 154, this.height / 4 + 24 - 16, 100, 20, "Click Friends: " + (WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 154, this.height / 4 + 48 - 16, 100, 20, "Mod List: " + this.modListModes[WurstClient.INSTANCE.options.modListMode]));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 154, this.height / 4 + 72 - 16, 100, 20, "AutoMaximize: " + (this.autoMaximize ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(4, this.width / 2 - 154, this.height / 4 + 96 - 16, 100, 20, "Wurst News: " + (WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(5, this.width / 2 - 154, this.height / 4 + 120 - 16, 100, 20, "Analytics: " + (WurstClient.INSTANCE.options.google_analytics.enabled ? "ON" : "OFF")));
        this.buttonList.add(new GuiButton(6, this.width / 2 - 50, this.height / 4 + 24 - 16, 100, 20, "Keybinds"));
        this.buttonList.add(new GuiButton(7, this.width / 2 - 50, this.height / 4 + 48 - 16, 100, 20, "X-Ray Blocks"));
        this.buttonList.add(new GuiButton(8, this.width / 2 - 50, this.height / 4 + 72 - 16, 100, 20, "Zoom"));
        this.buttonList.add(new GuiButton(11, this.width / 2 + 54, this.height / 4 + 24 - 16, 100, 20, "Wurst Website"));
        this.buttonList.add(new GuiButton(12, this.width / 2 + 54, this.height / 4 + 48 - 16, 100, 20, "Wurst on YouTube"));
        this.buttonList.add(new GuiButton(13, this.width / 2 + 54, this.height / 4 + 72 - 16, 100, 20, "Wurst on Twitter"));
        this.buttonList.add(new GuiButton(14, this.width / 2 + 54, this.height / 4 + 96 - 16, 100, 20, "Report a Bug"));
        ((GuiButton)this.buttonList.get((int)3)).enabled = !Minecraft.IS_RUNNING_ON_MAC;
    }

    @Override
    protected void actionPerformed(GuiButton clickedButton) {
        if (clickedButton.enabled) {
            if (clickedButton.id == 0) {
                this.mc.displayGuiScreen(this.prevMenu);
            } else if (clickedButton.id == 1) {
                WurstClient.INSTANCE.options.middleClickFriends = !WurstClient.INSTANCE.options.middleClickFriends;
                clickedButton.displayString = "Click Friends: " + (WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF");
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "click friends", WurstClient.INSTANCE.options.middleClickFriends ? "ON" : "OFF");
            } else if (clickedButton.id == 2) {
                ++WurstClient.INSTANCE.options.modListMode;
                if (WurstClient.INSTANCE.options.modListMode > 2) {
                    WurstClient.INSTANCE.options.modListMode = 0;
                }
                clickedButton.displayString = "Mod List: " + this.modListModes[WurstClient.INSTANCE.options.modListMode];
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "mod list", this.modListModes[WurstClient.INSTANCE.options.modListMode]);
            } else if (clickedButton.id == 3) {
                this.autoMaximize = !this.autoMaximize;
                clickedButton.displayString = "AutoMaximize: " + (this.autoMaximize ? "ON" : "OFF");
                WurstClient.INSTANCE.files.saveAutoMaximize(this.autoMaximize);
                WurstClient.INSTANCE.analytics.trackEvent("options", "automaximize", this.autoMaximize ? "ON" : "OFF");
            } else if (clickedButton.id == 4) {
                WurstClient.INSTANCE.options.wurstNews = !WurstClient.INSTANCE.options.wurstNews;
                clickedButton.displayString = "Wurst News: " + (WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF");
                WurstClient.INSTANCE.files.saveOptions();
                WurstClient.INSTANCE.analytics.trackEvent("options", "wurst news", WurstClient.INSTANCE.options.wurstNews ? "ON" : "OFF");
            } else if (clickedButton.id == 5) {
                OptionsManager.GoogleAnalytics analytics = WurstClient.INSTANCE.options.google_analytics;
                if (analytics.enabled) {
                    WurstClient.INSTANCE.analytics.trackEvent("options", "analytics", "disable");
                }
                boolean bl = analytics.enabled = !analytics.enabled;
                if (analytics.enabled) {
                    WurstClient.INSTANCE.analytics.trackEvent("options", "analytics", "enable");
                }
                clickedButton.displayString = "Analytics: " + (analytics.enabled ? "ON" : "OFF");
                WurstClient.INSTANCE.files.saveOptions();
            } else if (clickedButton.id == 6) {
                this.mc.displayGuiScreen(new GuiKeybindManager(this));
            } else if (clickedButton.id == 7) {
                this.mc.displayGuiScreen(new GuiXRayBlocksManager(this));
            } else if (clickedButton.id == 8) {
                this.mc.displayGuiScreen(new GuiZoomManager(this));
            } else if (clickedButton.id != 9 && clickedButton.id != 10) {
                if (clickedButton.id == 11) {
                    MiscUtils.openLink("https://www.wurst-client.tk/");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "wurst website");
                } else if (clickedButton.id == 12) {
                    MiscUtils.openLink("https://www.wurst-client.tk/youtube/");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "youtube channel");
                } else if (clickedButton.id == 13) {
                    MiscUtils.openLink("https://www.wurst-client.tk/twitter/");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "twitter");
                } else if (clickedButton.id == 14) {
                    MiscUtils.openLink("https://www.wurst-client.tk/bugs/");
                    WurstClient.INSTANCE.analytics.trackEvent("options", "bug tracker");
                } else {
                    int cfr_ignored_0 = clickedButton.id;
                }
            }
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        this.drawCenteredString(this.fontRendererObj, "Wurst Options", this.width / 2, 40, 0xFFFFFF);
        this.drawCenteredString(this.fontRendererObj, "Settings", this.width / 2 - 104, this.height / 4 + 24 - 28, 0xCCCCCC);
        this.drawCenteredString(this.fontRendererObj, "Managers", this.width / 2, this.height / 4 + 24 - 28, 0xCCCCCC);
        this.drawCenteredString(this.fontRendererObj, "Online", this.width / 2 + 104, this.height / 4 + 24 - 28, 0xCCCCCC);
        super.drawScreen(par1, par2, par3);
        int i = 0;
        while (i < this.buttonList.size()) {
            GuiButton button = (GuiButton)this.buttonList.get(i);
            if (button.isMouseOver() && !this.toolTips[button.id].isEmpty()) {
                this.drawHoveringText(Arrays.asList(this.toolTips[button.id].split("\n")), par1, par2);
                break;
            }
            ++i;
        }
    }
}

