/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.util.EnumHand;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.SliderSetting;

@Mod.Info(category=Mod.Category.COMBAT, description="Automatically eats soup if your health is below the set value.", name="AutoSoup", tags="auto soup", help="Mods/AutoSoup")
@Mod.Bypasses
public class AutoSoupMod
extends Mod
implements UpdateListener {
    public float health = 20.0f;

    @Override
    public void initSettings() {
        this.settings.add(new SliderSetting("Health", this.health, 2.0, 20.0, 1.0, SliderSetting.ValueDisplay.INTEGER){

            @Override
            public void update() {
                AutoSoupMod.this.health = (float)this.getValue();
            }
        });
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{AutoSoupMod.wurst.mods.autoEatMod};
    }

    @Override
    public void onEnable() {
        AutoSoupMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        if (AutoSoupMod.mc.currentScreen instanceof GuiContainer && !(AutoSoupMod.mc.currentScreen instanceof GuiInventory)) {
            return;
        }
        EntityPlayerSP player = AutoSoupMod.mc.thePlayer;
        if (player.getHealth() >= this.health) {
            return;
        }
        int soupInInventory = this.findSoup(9, 36);
        int soupInHotbar = this.findSoup(36, 45);
        if (soupInInventory == -1 && soupInHotbar == -1) {
            return;
        }
        Container inventoryContainer = player.inventoryContainer;
        PlayerControllerMP playerController = AutoSoupMod.mc.playerController;
        int i = 10;
        while (i < 45) {
            ItemStack stack = inventoryContainer.getSlot(i).getStack();
            if (stack != null && stack.getItem() == Items.BOWL) {
                playerController.windowClick(0, i, 0, ClickType.PICKUP, player);
                playerController.windowClick(0, 9, 0, ClickType.PICKUP, player);
            }
            ++i;
        }
        if (soupInHotbar != -1) {
            NetHandlerPlayClient connection = player.connection;
            connection.sendPacket(new CPacketHeldItemChange(soupInHotbar - 36));
            connection.sendPacket(new CPacketPlayerTryUseItem(EnumHand.MAIN_HAND));
            playerController.updateController();
        } else {
            playerController.windowClick(0, soupInInventory, 0, ClickType.QUICK_MOVE, player);
        }
    }

    @Override
    public void onDisable() {
        AutoSoupMod.wurst.events.remove(UpdateListener.class, this);
    }

    private int findSoup(int startSlot, int endSlot) {
        int i = startSlot;
        while (i < endSlot) {
            ItemStack stack = AutoSoupMod.mc.thePlayer.inventoryContainer.getSlot(i).getStack();
            if (stack != null && stack.getItem() == Items.MUSHROOM_STEW) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

