/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.settings.SliderSetting;

@Mod.Info(category=Mod.Category.COMBAT, description="Automatically throws splash healing potions if your health is below the set value.", name="AutoSplashPot", tags="AutoPotion,auto potion,auto splash potion", help="Mods/AutoSplashPot")
@Mod.Bypasses
public class AutoSplashPotMod
extends Mod
implements UpdateListener {
    public float health = 18.0f;

    @Override
    public void initSettings() {
        this.settings.add(new SliderSetting("Health", this.health, 2.0, 20.0, 1.0, SliderSetting.ValueDisplay.INTEGER){

            @Override
            public void update() {
                AutoSplashPotMod.this.health = (float)this.getValue();
            }
        });
    }

    @Override
    public void onEnable() {
        AutoSplashPotMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        if (AutoSplashPotMod.mc.currentScreen instanceof GuiContainer && !(AutoSplashPotMod.mc.currentScreen instanceof GuiInventory)) {
            return;
        }
        if (AutoSplashPotMod.mc.thePlayer.getHealth() >= this.health) {
            return;
        }
        int potionInInventory = this.findPotion(9, 36);
        int potionInHotbar = this.findPotion(36, 45);
        if (potionInInventory == -1 && potionInHotbar == -1) {
            return;
        }
        if (this.hasTimePassedM(500L)) {
            if (potionInHotbar != -1) {
                int oldSlot = AutoSplashPotMod.mc.thePlayer.inventory.currentItem;
                NetHandlerPlayClient connection = AutoSplashPotMod.mc.thePlayer.connection;
                connection.sendPacket(new CPacketPlayer.Rotation(AutoSplashPotMod.mc.thePlayer.rotationYaw, 90.0f, AutoSplashPotMod.mc.thePlayer.onGround));
                connection.sendPacket(new CPacketHeldItemChange(potionInHotbar - 36));
                AutoSplashPotMod.mc.playerController.updateController();
                connection.sendPacket(new CPacketPlayerTryUseItem(EnumHand.MAIN_HAND));
                connection.sendPacket(new CPacketHeldItemChange(oldSlot));
                connection.sendPacket(new CPacketPlayer.Rotation(AutoSplashPotMod.mc.thePlayer.rotationYaw, AutoSplashPotMod.mc.thePlayer.rotationPitch, AutoSplashPotMod.mc.thePlayer.onGround));
                this.updateLastMS();
            } else {
                AutoSplashPotMod.mc.playerController.windowClick(0, potionInInventory, 0, ClickType.QUICK_MOVE, AutoSplashPotMod.mc.thePlayer);
            }
        }
    }

    @Override
    public void onDisable() {
        AutoSplashPotMod.wurst.events.remove(UpdateListener.class, this);
    }

    private int findPotion(int startSlot, int endSlot) {
        int i = startSlot;
        while (i < endSlot) {
            ItemStack stack = AutoSplashPotMod.mc.thePlayer.inventoryContainer.getSlot(i).getStack();
            if (stack != null && stack.getItem() == Items.SPLASH_POTION) {
                for (PotionEffect effect : PotionUtils.getEffectsFromStack(stack)) {
                    if (effect.getPotion() != MobEffects.INSTANT_HEALTH) continue;
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }
}

