/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.settings.CheckboxSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.special.YesCheatSpf;
import tk.wurst_client.utils.BlockUtils;

@Mod.Info(category=Mod.Category.MISC, description="Automatically uses bone meal on specific types of plants.\nUse the checkboxes to specify the types of plants.", name="BonemealAura", tags="bonemeal aura, bone meal aura, AutoBone, auto bone", help="Mods/BonemealAura")
@Mod.Bypasses(ghostMode=false)
public class BonemealAuraMod
extends Mod
implements UpdateListener {
    public float normalRange = 5.0f;
    public float yesCheatRange = 4.25f;
    private final CheckboxSetting saplings = new CheckboxSetting("Saplings", true);
    private final CheckboxSetting crops = new CheckboxSetting("Carrots, Potatoes & Wheat", true);
    private final CheckboxSetting stems = new CheckboxSetting("Melons & Pumpkins", true);
    private final CheckboxSetting cocoa = new CheckboxSetting("Cocoa", true);
    private final CheckboxSetting other = new CheckboxSetting("Other", false);

    @Override
    public void initSettings() {
        this.settings.add(new SliderSetting("Range", this.normalRange, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL){

            @Override
            public void update() {
                BonemealAuraMod.this.normalRange = (float)this.getValue();
                BonemealAuraMod.this.yesCheatRange = Math.min(BonemealAuraMod.this.normalRange, 4.25f);
            }
        });
        this.settings.add(this.saplings);
        this.settings.add(this.crops);
        this.settings.add(this.stems);
        this.settings.add(this.cocoa);
        this.settings.add(this.other);
    }

    @Override
    public void onEnable() {
        BonemealAuraMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        ItemStack item = BonemealAuraMod.mc.thePlayer.inventory.getStackInSlot(BonemealAuraMod.mc.thePlayer.inventory.currentItem);
        if (item == null || !(item.getItem() instanceof ItemDye) || item.getMetadata() != 15) {
            return;
        }
        float range = BonemealAuraMod.wurst.special.yesCheatSpf.getBypassLevel().ordinal() >= YesCheatSpf.BypassLevel.ANTICHEAT.ordinal() ? this.yesCheatRange : this.normalRange;
        BlockPos pos = BonemealAuraMod.mc.thePlayer.getPosition();
        int y = (int)(-range) - 1;
        while (y < (int)range + 1) {
            int x = (int)(-range) - 1;
            while (x < (int)range + 1) {
                int z = (int)(-range) - 1;
                while (z < (int)range + 1) {
                    BlockPos currentPos = pos.add(x, y, z);
                    if (!(BlockUtils.getPlayerBlockDistance(currentPos) > range) && this.isCorrectBlock(currentPos)) {
                        BlockUtils.faceBlockPacket(currentPos);
                        BonemealAuraMod.mc.thePlayer.connection.sendPacket(new CPacketPlayerTryUseItemOnBlock(currentPos, EnumFacing.UP, EnumHand.MAIN_HAND, 0.5f, 1.0f, 0.5f));
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
    }

    private boolean isCorrectBlock(BlockPos pos) {
        IBlockState state = BonemealAuraMod.mc.theWorld.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof IGrowable) || block instanceof BlockGrass || !((IGrowable)((Object)block)).canGrow(BonemealAuraMod.mc.theWorld, pos, state, false)) {
            return false;
        }
        if (block instanceof BlockSapling) {
            return this.saplings.isChecked();
        }
        if (block instanceof BlockCrops) {
            return this.crops.isChecked();
        }
        if (block instanceof BlockStem) {
            return this.stems.isChecked();
        }
        if (block instanceof BlockCocoa) {
            return this.cocoa.isChecked();
        }
        return this.other.isChecked();
    }

    @Override
    public void onDisable() {
        BonemealAuraMod.wurst.events.remove(UpdateListener.class, this);
    }
}

