/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayDeque;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Allows you to see chests through walls.", name="ChestESP", tags="ChestFinder, chest esp, chest finder", help="Mods/ChestESP")
@Mod.Bypasses
public class ChestEspMod
extends Mod
implements RenderListener {
    private int maxChests = 1000;
    public boolean shouldInform = true;
    private TileEntityChest openChest;
    private ArrayDeque<TileEntityChest> emptyChests = new ArrayDeque();
    private ArrayDeque<TileEntityChest> nonEmptyChests = new ArrayDeque();

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{ChestEspMod.wurst.mods.itemEspMod, ChestEspMod.wurst.mods.searchMod, ChestEspMod.wurst.mods.xRayMod};
    }

    @Override
    public void onEnable() {
        this.shouldInform = true;
        this.emptyChests.clear();
        this.nonEmptyChests.clear();
        ChestEspMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        int chests = 0;
        int i = 0;
        while (i < ChestEspMod.mc.theWorld.loadedTileEntityList.size()) {
            TileEntity tileEntity = (TileEntity)ChestEspMod.mc.theWorld.loadedTileEntityList.get(i);
            if (chests >= this.maxChests) break;
            if (tileEntity instanceof TileEntityChest) {
                boolean trapped;
                ++chests;
                TileEntityChest chest = (TileEntityChest)tileEntity;
                boolean bl = trapped = chest.getChestType() == BlockChest.Type.TRAP;
                if (this.emptyChests.contains(tileEntity)) {
                    RenderUtils.blockEspBox(chest.getPos(), 0.25, 0.25, 0.25);
                } else if (this.nonEmptyChests.contains(tileEntity)) {
                    if (trapped) {
                        RenderUtils.blockEspBox(chest.getPos(), 0.5, 0.25, 0.0);
                    } else {
                        RenderUtils.blockEspBox(chest.getPos(), 0.0, 0.5, 0.0);
                    }
                } else if (trapped) {
                    RenderUtils.blockEsp(chest.getPos(), 1.0, 0.5, 0.0);
                } else {
                    RenderUtils.blockEsp(chest.getPos(), 0.0, 1.0, 0.0);
                }
                if (trapped) {
                    RenderUtils.blockEspFrame(chest.getPos(), 1.0, 0.5, 0.0);
                } else {
                    RenderUtils.blockEspFrame(chest.getPos(), 0.0, 1.0, 0.0);
                }
            } else if (tileEntity instanceof TileEntityEnderChest) {
                ++chests;
                RenderUtils.blockEsp(((TileEntityEnderChest)tileEntity).getPos(), 0.0, 1.0, 1.0);
            }
            ++i;
        }
        i = 0;
        while (i < ChestEspMod.mc.theWorld.loadedEntityList.size()) {
            Entity entity = (Entity)ChestEspMod.mc.theWorld.loadedEntityList.get(i);
            if (chests >= this.maxChests) break;
            if (entity instanceof EntityMinecartChest) {
                ++chests;
                RenderUtils.blockEsp(((EntityMinecartChest)entity).getPosition());
            }
            ++i;
        }
        if (chests >= this.maxChests && this.shouldInform) {
            ChestEspMod.wurst.chat.warning(String.valueOf(this.getName()) + " found \u00a7lA LOT\u00a7r of chests.");
            ChestEspMod.wurst.chat.message("To prevent lag, it will only show the first " + this.maxChests + " chests.");
            this.shouldInform = false;
        } else if (chests < this.maxChests) {
            this.shouldInform = true;
        }
    }

    @Override
    public void onDisable() {
        ChestEspMod.wurst.events.remove(RenderListener.class, this);
    }

    public void openChest(BlockPos pos) {
        TileEntity tileEntity = ChestEspMod.mc.theWorld.getTileEntity(pos);
        if (tileEntity instanceof TileEntityChest) {
            this.openChest = (TileEntityChest)tileEntity;
        }
    }

    public void closeChest(Container inventorySlots) {
        if (this.openChest == null) {
            return;
        }
        boolean empty = true;
        int i = 0;
        while (i < inventorySlots.inventorySlots.size() - 36) {
            if (inventorySlots.inventorySlots.get(i).getStack() != null) {
                empty = false;
                break;
            }
            ++i;
        }
        if (empty) {
            if (!this.emptyChests.contains(this.openChest)) {
                this.emptyChests.addLast(this.openChest);
            }
            if (this.emptyChests.size() >= 64) {
                this.emptyChests.removeFirst();
            }
            this.nonEmptyChests.remove(this.openChest);
        } else {
            if (!this.nonEmptyChests.contains(this.openChest)) {
                this.nonEmptyChests.addLast(this.openChest);
            }
            if (this.nonEmptyChests.size() >= 64) {
                this.nonEmptyChests.removeFirst();
            }
            this.emptyChests.remove(this.openChest);
        }
        System.out.println(String.valueOf(empty) + " " + this.nonEmptyChests.size() + " " + this.emptyChests.size());
        this.openChest = null;
    }
}

