/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoSwordMod;
import tk.wurst_client.mods.KillauraMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.CheckboxSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.special.YesCheatSpf;
import tk.wurst_client.utils.EntityUtils;

@Mod.Info(category=Mod.Category.COMBAT, description="A bot that automatically fights for you.\nIt walks around and kills everything.\nGood for MobArena.", name="FightBot", tags="fight bot", help="Mods/FightBot")
@Mod.Bypasses(ghostMode=false)
public class FightBotMod
extends Mod
implements UpdateListener {
    public CheckboxSetting useKillaura = new CheckboxSetting("Use Killaura settings", true){

        @Override
        public void update() {
            if (this.isChecked()) {
                KillauraMod killaura = FightBotMod.wurst.mods.killauraMod;
                FightBotMod.this.useCooldown.lock(killaura.useCooldown.isChecked());
                FightBotMod.this.speed.lockToValue(killaura.speed.getValue());
                FightBotMod.this.range.lockToValue(killaura.range.getValue());
            } else {
                FightBotMod.this.useCooldown.unlock();
                FightBotMod.this.speed.unlock();
                FightBotMod.this.range.unlock();
            }
        }
    };
    public CheckboxSetting useCooldown = new CheckboxSetting("Use Attack Cooldown as Speed", true){

        @Override
        public void update() {
            FightBotMod.this.speed.setDisabled(this.isChecked());
        }
    };
    public SliderSetting speed = new SliderSetting("Speed", 20.0, 2.0, 20.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    public SliderSetting range = new SliderSetting("Range", 6.0, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    public SliderSetting distance = new SliderSetting("Distance", 3.0, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);

    @Override
    public void initSettings() {
        this.settings.add(this.useKillaura);
        this.settings.add(this.useCooldown);
        this.settings.add(this.speed);
        this.settings.add(this.range);
        this.settings.add(this.distance);
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{FightBotMod.wurst.mods.killauraMod, FightBotMod.wurst.special.targetSpf, FightBotMod.wurst.special.yesCheatSpf};
    }

    @Override
    public void onEnable() {
        FightBotMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        EntityLivingBase target = EntityUtils.getClosestEntity(true, 360.0f, false);
        if (target == null) {
            return;
        }
        EntityUtils.faceEntityClient(target);
        FightBotMod.mc.gameSettings.keyBindForward.pressed = FightBotMod.mc.thePlayer.getDistanceToEntity(target) > this.distance.getValueF();
        if (FightBotMod.mc.thePlayer.isCollidedHorizontally && FightBotMod.mc.thePlayer.onGround) {
            FightBotMod.mc.thePlayer.jump();
        }
        if (FightBotMod.mc.thePlayer.isInWater() && FightBotMod.mc.thePlayer.posY < target.posY) {
            FightBotMod.mc.thePlayer.motionY += 0.04;
        }
        this.updateMS();
        if ((this.useCooldown.isChecked() ? FightBotMod.mc.thePlayer.getCooledAttackStrength(0.0f) >= 1.0f : this.hasTimePassedS(this.speed.getValueF())) && FightBotMod.mc.thePlayer.getDistanceToEntity(target) <= this.range.getValueF()) {
            if (FightBotMod.wurst.mods.autoSwordMod.isActive()) {
                AutoSwordMod.setSlot();
            }
            FightBotMod.wurst.mods.criticalsMod.doCritical();
            FightBotMod.wurst.mods.blockHitMod.doBlock();
            if (EntityUtils.getDistanceFromMouse(target) > 55) {
                EntityUtils.faceEntityClient(target);
            } else {
                EntityUtils.faceEntityClient(target);
                FightBotMod.mc.playerController.attackEntity(FightBotMod.mc.thePlayer, target);
                FightBotMod.mc.thePlayer.swingArm(EnumHand.MAIN_HAND);
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        FightBotMod.wurst.events.remove(UpdateListener.class, this);
        FightBotMod.mc.gameSettings.keyBindForward.pressed = false;
    }

    @Override
    public void onYesCheatUpdate(YesCheatSpf.BypassLevel bypassLevel) {
        switch (bypassLevel) {
            default: {
                this.speed.unlock();
                this.range.unlock();
                this.distance.unlock();
                break;
            }
            case ANTICHEAT: 
            case OLDER_NCP: 
            case LATEST_NCP: 
            case GHOST_MODE: {
                this.speed.lockToMax(12.0);
                this.range.lockToMax(4.25);
                this.distance.lockToMax(4.25);
            }
        }
    }
}

