/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.AutoSwordMod;
import tk.wurst_client.mods.KillauraMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.navigator.settings.CheckboxSetting;
import tk.wurst_client.navigator.settings.SliderSetting;
import tk.wurst_client.utils.EntityUtils;

@Mod.Info(category=Mod.Category.COMBAT, description="Faster Killaura that attacks multiple entities at once.", name="MultiAura", noCheatCompatible=false, tags="ForceField, multi aura, force field", help="Mods/MultiAura")
@Mod.Bypasses(ghostMode=false, latestNCP=false, olderNCP=false, antiCheat=false)
public class MultiAuraMod
extends Mod
implements UpdateListener {
    public CheckboxSetting useKillaura = new CheckboxSetting("Use Killaura settings", false){

        @Override
        public void update() {
            if (this.isChecked()) {
                KillauraMod killaura = MultiAuraMod.wurst.mods.killauraMod;
                MultiAuraMod.this.useCooldown.lock(killaura.useCooldown.isChecked());
                MultiAuraMod.this.speed.lockToValue(killaura.speed.getValue());
                MultiAuraMod.this.range.lockToValue(killaura.range.getValue());
                MultiAuraMod.this.fov.lockToValue(killaura.fov.getValue());
                MultiAuraMod.this.hitThroughWalls.lock(killaura.hitThroughWalls.isChecked());
            } else {
                MultiAuraMod.this.useCooldown.unlock();
                MultiAuraMod.this.speed.unlock();
                MultiAuraMod.this.range.unlock();
                MultiAuraMod.this.fov.unlock();
                MultiAuraMod.this.hitThroughWalls.unlock();
            }
        }
    };
    public CheckboxSetting useCooldown = new CheckboxSetting("Use Attack Cooldown as Speed", true){

        @Override
        public void update() {
            MultiAuraMod.this.speed.setDisabled(this.isChecked());
        }
    };
    public SliderSetting speed = new SliderSetting("Speed", 20.0, 2.0, 20.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    public SliderSetting range = new SliderSetting("Range", 6.0, 1.0, 6.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    public SliderSetting fov = new SliderSetting("FOV", 360.0, 30.0, 360.0, 10.0, SliderSetting.ValueDisplay.DEGREES);
    public CheckboxSetting hitThroughWalls = new CheckboxSetting("Hit through walls", true);

    @Override
    public void initSettings() {
        this.settings.add(this.useKillaura);
        this.settings.add(this.useCooldown);
        this.settings.add(this.speed);
        this.settings.add(this.range);
        this.settings.add(this.fov);
        this.settings.add(this.hitThroughWalls);
    }

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{MultiAuraMod.wurst.special.targetSpf, MultiAuraMod.wurst.mods.killauraMod, MultiAuraMod.wurst.mods.killauraLegitMod, MultiAuraMod.wurst.mods.clickAuraMod, MultiAuraMod.wurst.mods.triggerBotMod};
    }

    @Override
    public void onEnable() {
        if (MultiAuraMod.wurst.mods.killauraMod.isEnabled()) {
            MultiAuraMod.wurst.mods.killauraMod.setEnabled(false);
        }
        if (MultiAuraMod.wurst.mods.killauraLegitMod.isEnabled()) {
            MultiAuraMod.wurst.mods.killauraLegitMod.setEnabled(false);
        }
        if (MultiAuraMod.wurst.mods.clickAuraMod.isEnabled()) {
            MultiAuraMod.wurst.mods.clickAuraMod.setEnabled(false);
        }
        if (MultiAuraMod.wurst.mods.tpAuraMod.isEnabled()) {
            MultiAuraMod.wurst.mods.tpAuraMod.setEnabled(false);
        }
        if (MultiAuraMod.wurst.mods.triggerBotMod.isEnabled()) {
            MultiAuraMod.wurst.mods.triggerBotMod.setEnabled(false);
        }
        MultiAuraMod.wurst.events.add(UpdateListener.class, this);
    }

    @Override
    public void onUpdate() {
        this.updateMS();
        EntityLivingBase closestEntity = EntityUtils.getClosestEntity(true, 360.0f, this.hitThroughWalls.isChecked());
        if (closestEntity == null || MultiAuraMod.mc.thePlayer.getDistanceToEntity(closestEntity) > this.range.getValueF()) {
            EntityUtils.lookChanged = false;
            return;
        }
        EntityUtils.lookChanged = true;
        if (!this.useCooldown.isChecked() || MultiAuraMod.mc.thePlayer.getCooledAttackStrength(0.0f) >= 1.0f) {
            if (MultiAuraMod.wurst.mods.autoSwordMod.isActive()) {
                AutoSwordMod.setSlot();
            }
            MultiAuraMod.wurst.mods.criticalsMod.doCritical();
            MultiAuraMod.wurst.mods.blockHitMod.doBlock();
            ArrayList<EntityLivingBase> entities = EntityUtils.getCloseEntities(true, this.range.getValueF(), this.hitThroughWalls.isChecked());
            int i = 0;
            while (i < Math.min(entities.size(), 64)) {
                EntityLivingBase en = entities.get(i);
                EntityUtils.faceEntityPacket(en);
                MultiAuraMod.mc.playerController.attackEntity(MultiAuraMod.mc.thePlayer, en);
                MultiAuraMod.mc.thePlayer.swingArm(EnumHand.MAIN_HAND);
                ++i;
            }
            this.updateLastMS();
        }
    }

    @Override
    public void onDisable() {
        MultiAuraMod.wurst.events.remove(UpdateListener.class, this);
        EntityUtils.lookChanged = false;
    }
}

