/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.awt.Color;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEffect;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.util.math.BlockPos;
import tk.wurst_client.events.PacketInputEvent;
import tk.wurst_client.events.listeners.PacketInputListener;
import tk.wurst_client.events.listeners.RenderListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.navigator.NavigatorItem;
import tk.wurst_client.utils.BlockUtils;
import tk.wurst_client.utils.RenderUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Finds far players during thunderstorms.", name="PlayerFinder", tags="player finder", help="Mods/PlayerFinder")
@Mod.Bypasses
public class PlayerFinderMod
extends Mod
implements PacketInputListener,
RenderListener {
    private BlockPos blockPos;

    @Override
    public NavigatorItem[] getSeeAlso() {
        return new NavigatorItem[]{PlayerFinderMod.wurst.mods.playerEspMod, PlayerFinderMod.wurst.mods.tracersMod};
    }

    @Override
    public void onEnable() {
        this.blockPos = null;
        PlayerFinderMod.wurst.events.add(PacketInputListener.class, this);
        PlayerFinderMod.wurst.events.add(RenderListener.class, this);
    }

    @Override
    public void onRender() {
        if (this.blockPos == null) {
            return;
        }
        float red = (1.0f - (float)Math.sin((double)((float)(System.currentTimeMillis() % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        float green = (1.0f - (float)Math.sin((double)((float)((System.currentTimeMillis() + 333L) % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        float blue = (1.0f - (float)Math.sin((double)((float)((System.currentTimeMillis() + 666L) % 1000L) / 1000.0f) * Math.PI * 2.0)) / 2.0f;
        Color color = new Color(red, green, blue);
        RenderUtils.tracerLine(this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ(), color);
        RenderUtils.blockEsp(this.blockPos);
    }

    @Override
    public void onDisable() {
        PlayerFinderMod.wurst.events.remove(PacketInputListener.class, this);
        PlayerFinderMod.wurst.events.remove(RenderListener.class, this);
    }

    @Override
    public void onReceivedPacket(PacketInputEvent event) {
        SPacketSpawnGlobalEntity lightning;
        BlockPos pos;
        if (PlayerFinderMod.mc.thePlayer == null) {
            return;
        }
        Packet packet = event.getPacket();
        if (packet instanceof SPacketEffect) {
            SPacketEffect effect = (SPacketEffect)packet;
            BlockPos pos2 = effect.getSoundPos();
            if (BlockUtils.getPlayerBlockDistance(pos2) >= 160.0f) {
                this.blockPos = pos2;
            }
        } else if (packet instanceof SPacketSoundEffect) {
            SPacketSoundEffect sound = (SPacketSoundEffect)packet;
            BlockPos pos3 = new BlockPos(sound.getX(), sound.getY(), sound.getZ());
            if (BlockUtils.getPlayerBlockDistance(pos3) >= 160.0f) {
                this.blockPos = pos3;
            }
        } else if (packet instanceof SPacketSpawnGlobalEntity && BlockUtils.getPlayerBlockDistance(pos = new BlockPos((lightning = (SPacketSpawnGlobalEntity)packet).getX() / 32.0, lightning.getY() / 32.0, lightning.getZ() / 32.0)) >= 160.0f) {
            this.blockPos = pos;
        }
    }
}

