/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.mods;

import java.util.UUID;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import tk.wurst_client.events.listeners.UpdateListener;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.utils.EntityUtils;

@Mod.Info(category=Mod.Category.RENDER, description="Allows you to see the world as someone else.\nUse the .rv command to make it target a specific entity.", name="RemoteView", tags="remote view", help="Mods/RemoteView")
@Mod.Bypasses
public class RemoteViewMod
extends Mod
implements UpdateListener {
    private EntityPlayerSP newView = null;
    private double oldX;
    private double oldY;
    private double oldZ;
    private float oldYaw;
    private float oldPitch;
    private EntityLivingBase otherView = null;
    private static UUID otherID = null;
    private boolean wasInvisible;

    @Override
    public void onEnable() {
        if (EntityUtils.getClosestEntityRaw(false) == null) {
            RemoteViewMod.wurst.chat.message("There is no nearby entity.");
            this.setEnabled(false);
            return;
        }
        this.oldX = RemoteViewMod.mc.thePlayer.posX;
        this.oldY = RemoteViewMod.mc.thePlayer.posY;
        this.oldZ = RemoteViewMod.mc.thePlayer.posZ;
        this.oldYaw = RemoteViewMod.mc.thePlayer.rotationYaw;
        this.oldPitch = RemoteViewMod.mc.thePlayer.rotationPitch;
        RemoteViewMod.mc.thePlayer.noClip = true;
        if (otherID == null) {
            otherID = EntityUtils.getClosestEntityRaw(false).getUniqueID();
        }
        this.otherView = EntityUtils.searchEntityByIdRaw(otherID);
        this.wasInvisible = this.otherView.isInvisibleToPlayer(RemoteViewMod.mc.thePlayer);
        EntityOtherPlayerMP fakePlayer = new EntityOtherPlayerMP(RemoteViewMod.mc.theWorld, RemoteViewMod.mc.thePlayer.getGameProfile());
        fakePlayer.clonePlayer(RemoteViewMod.mc.thePlayer, true);
        fakePlayer.copyLocationAndAnglesFrom(RemoteViewMod.mc.thePlayer);
        fakePlayer.rotationYawHead = RemoteViewMod.mc.thePlayer.rotationYawHead;
        RemoteViewMod.mc.theWorld.addEntityToWorld(-69, fakePlayer);
        RemoteViewMod.wurst.chat.message("Now viewing " + this.otherView.getName() + ".");
        RemoteViewMod.wurst.events.add(UpdateListener.class, this);
    }

    public static void onEnabledByCommand(String viewName) {
        try {
            if (otherID == null && !viewName.equals("")) {
                otherID = EntityUtils.searchEntityByNameRaw(viewName).getUniqueID();
            }
            RemoteViewMod.wurst.mods.remoteViewMod.toggle();
        }
        catch (NullPointerException e) {
            RemoteViewMod.wurst.chat.error("Entity not found.");
        }
    }

    @Override
    public void onUpdate() {
        if (EntityUtils.searchEntityByIdRaw(otherID) == null) {
            this.setEnabled(false);
            return;
        }
        this.newView = RemoteViewMod.mc.thePlayer;
        this.otherView = EntityUtils.searchEntityByIdRaw(otherID);
        this.newView.copyLocationAndAnglesFrom(this.otherView);
        RemoteViewMod.mc.thePlayer.motionX = 0.0;
        RemoteViewMod.mc.thePlayer.motionY = 0.0;
        RemoteViewMod.mc.thePlayer.motionZ = 0.0;
        RemoteViewMod.mc.thePlayer = this.newView;
        this.otherView.setInvisible(true);
    }

    @Override
    public void onDisable() {
        RemoteViewMod.wurst.events.remove(UpdateListener.class, this);
        if (this.otherView != null) {
            RemoteViewMod.wurst.chat.message("No longer viewing " + this.otherView.getName() + ".");
            this.otherView.setInvisible(this.wasInvisible);
            RemoteViewMod.mc.thePlayer.noClip = false;
            RemoteViewMod.mc.thePlayer.setPositionAndRotation(this.oldX, this.oldY, this.oldZ, this.oldYaw, this.oldPitch);
            RemoteViewMod.mc.theWorld.removeEntityFromWorld(-69);
        }
        this.newView = null;
        this.otherView = null;
        otherID = null;
    }
}

